/**
 *
 */
package de.upb.pga3.panda2.core.datastructures;

/**
 * This is a model for storing information of a method (normal java methods or
 * android methods)
 *
 * @author nptsy
 */
public class JavaAPIMethod {

	// method name
	private String mMethodName;

	// class name
	private String mClassName;

	// return type
	private String mReturnType;

	// signature
	private String mSignature;

	// sub signature
	private String mSubSignature;

	// hashcode
	private int mHashCode = 0;

	public JavaAPIMethod(final String inSignature) {
		this.mSignature = inSignature;
		parseSignature(inSignature);
	}

	/**
	 * parse signature
	 *
	 * @param inSignature
	 *            the signature of a method
	 */
	private void parseSignature(final String inSignature) {
		if (inSignature != null && !inSignature.isEmpty()) {
			// remove < and >
			String optimizedSignature = inSignature.replace("<", "");
			optimizedSignature = optimizedSignature.replace(">", "");

			// split the signature into parts based on the blank space
			final String[] lstSubStr = optimizedSignature.split(" ");

			// in case of valid list of sub strings
			if (lstSubStr.length == 3) {
				// the 1st is class name
				this.mClassName = lstSubStr[0].replace(":", "");

				// the 2nd is return type
				this.mReturnType = lstSubStr[1];

				// the 3rd is method
				this.mMethodName = lstSubStr[2];

				// the sub signature
				this.mSubSignature = this.mReturnType + " " + this.mMethodName;
			}
		}
	}

	/**
	 * get method name
	 *
	 * @return
	 */
	public String getMethodName() {
		return this.mMethodName;
	}

	/**
	 * get class name
	 *
	 * @return
	 */

	public String getClassName() {
		return this.mClassName;
	}

	/**
	 * get return type
	 *
	 * @return
	 */
	public String getReturnType() {
		return this.mReturnType;
	}

	/**
	 * get sub signature
	 *
	 * @return
	 */
	public String getSubSignature() {
		return this.mSubSignature;
	}

	/**
	 * get signature
	 *
	 * @return
	 */
	public String getSignature() {
		return this.mSignature;
	}

	@Override
	public boolean equals(final Object another) {
		if (super.equals(another)) {
			return true;
		}
		if (!(another instanceof JavaAPIMethod)) {
			return false;
		}
		final JavaAPIMethod otherMethod = (JavaAPIMethod) another;

		if (!this.mSignature.equals(otherMethod.mSignature)) {
			return false;
		}
		if (!this.mMethodName.equals(otherMethod.mMethodName)) {
			return false;
		}
		if (!this.mClassName.equals(otherMethod.mClassName)) {
			return false;
		}
		if (!this.mReturnType.equals(otherMethod.mReturnType)) {
			return false;
		}
		return true;
	}

	@Override
	public int hashCode() {
		if (this.mHashCode == 0) {
			this.mHashCode = this.mMethodName.hashCode() + this.mClassName.hashCode() * 5;
		}
		/*
		 * The parameter list is available from the outside, so we can't cache
		 * it
		 */
		return this.mHashCode;
	}

	@Override
	public String toString() {
		return this.mSignature;
	}
}