package de.upb.pga3.panda2.core;

import java.util.List;

/**
 * Factory interface for creating analyses. Creation parameters should be
 * provided in the constructor of the implementing class.
 * 
 * @author Fabian
 *
 */
public interface AnalysisFactory {

	/**
	 * Creates an analysis in form of a list of {@code Analysis} instances. This
	 * list can ten be passed to the {@code AnalysisRunner} to perform the
	 * analysis.
	 * 
	 * @return A list of {@code Analysis} instances.
	 * @see Analysis
	 */
	public List<Analysis> createAnalysis();

}
