package de.upb.pga3.panda2.client.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import de.upb.pga3.panda2.client.core.AnalysisRegistry;
import de.upb.pga3.panda2.client.core.AppIdentifier;
import de.upb.pga3.panda2.client.core.datastructures.UIMessage;
import de.upb.pga3.panda2.client.core.datastructures.UIMessageType;
import de.upb.pga3.panda2.utilities.Constants;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

/**
 * The wizard used to start a new analysis is defined in this class. It does not
 * follow the MVC pattern which is implemented for the main part of the GUI.
 *
 * @author Felix
 */
public class Wizard extends Application {
	private static Wizard instance = null;

	// MVC
	private Model model;

	public static final String MODE_APP = "APP";
	public static final String MODE_ALL = "ALL";

	private final ImageView chooserFNF1;
	private final ImageView chooserFNF2;
	final ImageView chooserFNF3;
	Stage stage;
	ComboBox<String> page1Mode;
	private Text text2;

	private BorderPane pane;
	private Button btnPrev, btnNext, btnFinish, btnCancel;
	private final int numPages = 2;
	private int currentPage;

	private final FileChooser chooserDialog1, chooserDialog2, chooserDialog3;

	private final AppIdentifier appIdentifier;

	// Images
	private Image imgTick;

	// Selections
	String selectedLevel;
	boolean selectedAllmode;
	File selectedApk;
	File selectedPrevResult;
	List<File> selectedAdditionalApks;

	Wizard(final Model model) {
		super();

		this.model = model;

		this.currentPage = 1;
		this.chooserFNF1 = new ImageView();
		this.chooserFNF2 = new ImageView();
		this.chooserFNF3 = new ImageView();
		this.selectedLevel = AnalysisRegistry.LEVEL1;
		this.selectedAllmode = false;
		this.selectedApk = null;
		this.selectedPrevResult = null;

		this.chooserDialog1 = new FileChooser();
		this.chooserDialog2 = new FileChooser();
		this.chooserDialog3 = new FileChooser();
		final FileChooser.ExtensionFilter allFilesFilter = new FileChooser.ExtensionFilter("*.* - All files", "*.*");
		final FileChooser.ExtensionFilter apkFilter = new FileChooser.ExtensionFilter(
				"*" + Constants.APK_EXTENSION + "- Android application package", "*" + Constants.APK_EXTENSION);
		final FileChooser.ExtensionFilter pa2Filter = new FileChooser.ExtensionFilter(
				"*" + Constants.SAVED_RESULT_EXTENSION + " - Panda2 Analysis Result File",
				"*" + Constants.SAVED_RESULT_EXTENSION);
		final FileChooser.ExtensionFilter apkPa2Filter = new FileChooser.ExtensionFilter(
				"*" + Constants.SAVED_RESULT_EXTENSION + "/*" + Constants.APK_EXTENSION
						+ " - Panda2 Analysis Result File / Android application package",
				"*" + Constants.SAVED_RESULT_EXTENSION, "*" + Constants.APK_EXTENSION);
		this.chooserDialog1.getExtensionFilters().addAll(apkFilter, allFilesFilter);
		this.chooserDialog2.getExtensionFilters().addAll(apkPa2Filter, pa2Filter, apkFilter, allFilesFilter);
		this.chooserDialog3.getExtensionFilters().addAll(apkFilter, allFilesFilter);

		this.appIdentifier = new AppIdentifier();

		instance = this;
	}

	public static Wizard getInstance() {
		return instance;
	}

	private Model getModel() {
		return this.model;
	}

	@Override
	public void start(final Stage stageParameter) {
		this.stage = stageParameter;
		this.stage.setTitle("Analysis Wizard");
		GUIHelper.setPandaIcon(this.stage);
		this.stage.setOnCloseRequest(new EventHandler<WindowEvent>() {
			@Override
			public void handle(final WindowEvent we) {
				we.consume();
				exitClicked();
			}
		});
		this.stage.setResizable(false);

		this.imgTick = new Image("file:data/images/tick_16.png");

		final BorderPane bottomPane = new BorderPane();
		bottomPane.setPadding(new Insets(5, 5, 5, 5));

		final HBox buttonBox = new HBox();
		this.btnPrev = new Button("Previous");
		this.btnPrev.setGraphic(new ImageView(new Image("file:data/images/left_16.png")));
		this.btnPrev.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				prevPage();
			}
		});
		this.btnNext = new Button("Next");
		this.btnNext.setGraphic(new ImageView(new Image("file:data/images/right_16.png")));
		this.btnNext.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				nextPage();
			}
		});
		this.btnFinish = new Button("Finish");
		this.btnFinish.setMinHeight(24d);
		this.btnFinish.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				finish();
			}
		});
		buttonBox.getChildren().addAll(this.btnPrev, this.btnNext, this.btnFinish);

		this.btnCancel = new Button("Cancel");
		this.btnCancel.setMinHeight(24d);
		this.btnCancel.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				exitClicked();
			}
		});

		bottomPane.setLeft(this.btnCancel);
		bottomPane.setRight(buttonBox);

		// Build
		this.pane = new BorderPane();
		this.pane.setBottom(bottomPane);

		// Set and show stage
		final Scene scene = new Scene(this.pane, 550, 400);
		this.stage.setScene(scene);

		this.stage.show();

		// Load first page
		loadPage();
	}

	private void loadPage() {
		checkFinish();
		checkComparison();
		if (this.currentPage >= this.numPages) {
			this.btnNext.setDisable(true);
		} else {
			this.btnNext.setDisable(false);
		}
		if (this.currentPage <= 1) {
			this.btnPrev.setDisable(true);
		} else {
			this.btnPrev.setDisable(false);
		}

		switch (this.currentPage) {
		case 1:
			this.pane.setCenter(page1());
			break;
		case 2:
			this.pane.setCenter(page2());
			break;
		default:
			this.pane.setCenter(page1());
			break;
		}
	}

	void nextPage() {
		this.currentPage++;
		loadPage();
	}

	void prevPage() {
		this.currentPage--;
		loadPage();
	}

	void exitClicked() {
		this.stage.hide();
	}

	void finish() {
		this.stage.hide();
		getModel().startAnalysis(this.selectedLevel, this.selectedApk, this.selectedPrevResult,
				this.selectedAdditionalApks, this.selectedAllmode);
	}

	public void show() {
		this.currentPage = 1;
		loadPage();
		this.stage.show();
	}

	void checkFinish() {
		if (Wizard.getInstance().selectedApk != null && Wizard.getInstance().selectedApk.exists()
				&& Wizard.getInstance().selectedApk.toString().length() >= 4
				&& Wizard.getInstance().selectedApk.toString()
						.substring(Wizard.getInstance().selectedApk.toString().length() - 4,
								Wizard.getInstance().selectedApk.toString().length())
						.equals(Constants.APK_EXTENSION)) {
			if (this.currentPage == this.numPages) {
				this.btnFinish.setDisable(false);
			} else {
				this.btnFinish.setDisable(true);
			}
			this.chooserFNF1.setImage(this.imgTick);
		} else {
			this.btnFinish.setDisable(true);
			this.chooserFNF1.setImage(new Image("file:data/images/delete_16.png"));
		}
	}

	void checkComparison() {
		if (Wizard.getInstance().selectedPrevResult == null) {
			this.chooserFNF2.setImage(new Image("file:data/images/info_16.png"));
		} else {
			if (Wizard.getInstance().selectedPrevResult != null && Wizard.getInstance().selectedPrevResult.exists()
					&& Wizard.getInstance().selectedPrevResult.toString().length() >= 4
					&& (Wizard.getInstance().selectedPrevResult.toString()
							.substring(Wizard.getInstance().selectedPrevResult.toString().length() - 4,
									Wizard.getInstance().selectedPrevResult.toString().length())
							.equals(Constants.SAVED_RESULT_EXTENSION)
							|| Wizard.getInstance().selectedPrevResult.toString()
									.substring(Wizard.getInstance().selectedPrevResult.toString().length() - 4,
											Wizard.getInstance().selectedPrevResult.toString().length())
									.equals(Constants.APK_EXTENSION))) {

				// Check for same
				if (this.selectedApk != null && this.selectedPrevResult != null && this.selectedApk.exists()
						&& this.selectedPrevResult.exists()) {
					final UIMessage msg = this.appIdentifier.compareAppWithPreviousResult(this.selectedApk,
							this.selectedPrevResult);
					if (msg.getType() == UIMessageType.INFO) {
						this.chooserFNF2.setImage(new Image("file:data/images/flag_16.png"));
						this.text2.setText(msg.getBody());
						this.text2.setFill(Color.BLUE);
					} else if (msg.getType() == UIMessageType.WARNING) {
						this.chooserFNF2.setImage(new Image("file:data/images/warning_16.png"));
						this.text2.setText(msg.getBody());
						this.text2.setFill(Color.ORANGE);
					} else if (msg.getType() == UIMessageType.ERROR) {
						this.chooserFNF2.setImage(new Image("file:data/images/delete_16.png"));
						this.text2.setText(msg.getBody());
						this.text2.setFill(Color.RED);
					} else {
						this.chooserFNF2.setImage(this.imgTick);
						this.text2.setText("");
					}
				} else {
					this.chooserFNF2.setImage(this.imgTick);
					this.text2.setText("");
				}
			} else {
				this.chooserFNF2.setImage(new Image("file:data/images/delete_16.png"));
			}
		}
	}

	List<File> createAdditionalApkList(final String apksStrParameter) {
		if (apksStrParameter != null && !apksStrParameter.equals("")) {
			final String apksStr = apksStrParameter.replaceAll(",[ \t\n]*", ",").replaceAll("[\t\n]", "");
			final List<String> tempList = Arrays.asList(apksStr.split(","));
			final List<File> fileList = new ArrayList<>();
			for (final String item : tempList) {
				final File file = new File(item);
				if (file.toString() != null && file.exists() && file.toString().length() >= 4
						&& file.toString().substring(file.toString().length() - 4, file.toString().length())
								.equals(Constants.APK_EXTENSION)) {
					fileList.add(file);
				} else {
					this.chooserFNF3.setImage(new Image("file:data/images/delete_16.png"));
					return null;
				}
			}
			this.chooserFNF3.setImage(this.imgTick);
			return fileList;
		} else {
			this.chooserFNF3.setImage(new Image("file:data/images/info_16.png"));
			return null;
		}
	}

	private Pane page1() {
		// Page 1 (Select Analysis)
		final VBox page1 = new VBox(15);
		page1.setFillWidth(true);
		page1.setMaxWidth(Double.MAX_VALUE);
		page1.setPadding(new Insets(15, 15, 15, 15));

		// Title
		final Text page1title = new Text("Step (" + this.currentPage + "/" + this.numPages + "): Choose Analysis");
		page1title.setFont(Font.font("Verdana", FontWeight.BOLD, 12));

		// Part 1
		final VBox page1Part1 = new VBox();
		Tooltip.install(page1Part1, new Tooltip("Select the type of analysis you want to run."));
		page1Part1.setFillWidth(true);
		page1Part1.setMaxWidth(Double.MAX_VALUE);
		final Label page1Label1 = new Label("Analysis:");
		final ObservableList<String> page1AnalysisOptions = FXCollections
				.observableArrayList(AnalysisRegistry.getInstance().getAnalysisNames());
		final ComboBox<String> page1Analysis = new ComboBox<>(page1AnalysisOptions);
		page1Analysis.setValue(this.selectedLevel);
		page1Analysis.setMaxWidth(Double.MAX_VALUE);
		page1Analysis.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				for (final String name : AnalysisRegistry.getInstance().getAnalysisNames()) {
					if (name.equals(page1Analysis.getValue())) {
						Wizard.getInstance().selectedLevel = name;
						if (AnalysisRegistry.LEVEL2B.equals(name)) {
							Wizard.this.page1Mode.setDisable(false);
						} else {
							Wizard.this.page1Mode.setDisable(true);
						}
					}
				}
			}
		});

		// Part 2
		final VBox page1Part2 = new VBox();
		Tooltip.install(page1Part2, new Tooltip("In case of an " + AnalysisRegistry.LEVEL2B
				+ " analysis you can choose a mode here.\nAPP: In this mode all Apps reachable from the analysed App are considered.\nALL: In this mode connections from other Apps to the analysed App are considered as well."));
		page1Part2.setFillWidth(true);
		page1Part2.setMaxWidth(Double.MAX_VALUE);
		final Label page1Label2 = new Label("Mode:");
		final ObservableList<String> page1ModeOptions = FXCollections.observableArrayList(MODE_APP, MODE_ALL);
		this.page1Mode = new ComboBox<>(page1ModeOptions);
		if (this.selectedAllmode) {
			this.page1Mode.setValue(MODE_ALL);
		} else {
			this.page1Mode.setValue(MODE_APP);
		}
		this.page1Mode.setMaxWidth(Double.MAX_VALUE);
		this.page1Mode.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				if (Wizard.this.page1Mode.getValue().equals(MODE_APP)) {
					Wizard.this.selectedAllmode = false;
				} else if (Wizard.this.page1Mode.getValue().equals(MODE_ALL)) {
					Wizard.this.selectedAllmode = true;
				}
			}
		});
		if (this.selectedLevel == AnalysisRegistry.LEVEL2B) {
			this.page1Mode.setDisable(false);
		} else {
			this.page1Mode.setDisable(true);
		}

		// Build
		page1Part1.getChildren().addAll(page1Label1, page1Analysis);
		page1Part2.getChildren().addAll(page1Label2, this.page1Mode);
		page1.getChildren().addAll(page1title, page1Part1, page1Part2);

		return page1;
	}

	private Pane page2() {
		// Page 2 (Select Input)
		final VBox page = new VBox(15);
		page.setFillWidth(true);
		page.setMaxWidth(Double.MAX_VALUE);
		page.setPadding(new Insets(15, 15, 15, 15));

		// Title
		final Text title = new Text("Step (" + this.currentPage + "/" + this.numPages + "): Select input");
		title.setFont(Font.font("Verdana", FontWeight.BOLD, 12));

		// Part 1
		final VBox part1 = new VBox();
		Tooltip.install(part1,
				new Tooltip("Select the " + Constants.APK_EXTENSION + " file of the App you want to be analysed."));
		part1.setFillWidth(true);
		part1.setMaxWidth(Double.MAX_VALUE);
		final Label label1 = new Label("Analysed App:");
		final HBox chooser1 = new HBox(5);
		chooser1.setMaxWidth(Double.MAX_VALUE);
		final TextField chooserText1 = new TextField();
		if (this.selectedApk != null) {
			chooserText1.setText(this.selectedApk.toString());
		}
		chooserText1.textProperty().addListener(new ChangeListener<String>() {
			@Override
			public void changed(final ObservableValue<? extends String> observable, final String oldValue,
					final String newValue) {
				if (!newValue.equals("")) {
					Wizard.getInstance().selectedApk = new File(newValue);
					if (Wizard.this.selectedApk.getParentFile().exists()) {
						GuiConfig.getInstance().setApkFolder(Wizard.getInstance().selectedApk.getParentFile());
					}
				} else {
					Wizard.getInstance().selectedApk = null;
				}
				checkFinish();
				if (Wizard.this.selectedPrevResult != null) {
					checkComparison();
				}
			}
		});
		chooserText1.setPrefWidth(Integer.MAX_VALUE);
		final Button btnOpen1 = new Button("Browse...");
		btnOpen1.setMinWidth(75d);
		btnOpen1.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent e) {
				Wizard.this.chooserDialog1.setInitialDirectory(GuiConfig.getInstance().getApkFolder());
				final File file = Wizard.this.chooserDialog1.showOpenDialog(Wizard.getInstance().stage);
				if (file != null) {
					chooserText1.setText(file.toString());
				}
			}
		});
		chooser1.getChildren().addAll(this.chooserFNF1, chooserText1, btnOpen1);

		// Part 2
		final VBox part2 = new VBox();
		Tooltip.install(part2, new Tooltip(
				"Optionally select an analysis result or an .apk file in order to create an analysis result for comparison here.\nThis automatically turns the tool into comparison mode."));
		part2.setFillWidth(true);
		part2.setMaxWidth(Double.MAX_VALUE);
		final HBox part2labelBox = new HBox(3);
		final Label label2 = new Label("Previous analysis for comparison (optional):");
		this.text2 = new Text();
		part2labelBox.getChildren().addAll(label2, this.text2);
		final HBox chooser2 = new HBox(5);
		chooser2.setMaxWidth(Double.MAX_VALUE);
		final TextField chooserText2 = new TextField();
		if (this.selectedPrevResult != null) {
			chooserText2.setText(this.selectedPrevResult.toString());
		}
		chooserText2.textProperty().addListener(new ChangeListener<String>() {
			@Override
			public void changed(final ObservableValue<? extends String> observable, final String oldValue,
					final String newValue) {
				if (!newValue.equals("")) {
					Wizard.getInstance().selectedPrevResult = new File(newValue);
					if (Wizard.this.selectedPrevResult.getParentFile().exists()) {
						GuiConfig.getInstance()
								.setPrevResultFolder(Wizard.getInstance().selectedPrevResult.getParentFile());
					}
				} else {
					Wizard.getInstance().selectedPrevResult = null;
				}
				checkComparison();
			}
		});
		chooserText2.setPrefWidth(Integer.MAX_VALUE);
		final Button btnOpen2 = new Button("Browse...");
		btnOpen2.setMinWidth(75d);
		btnOpen2.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent e) {
				Wizard.this.chooserDialog2.setInitialDirectory(GuiConfig.getInstance().getPrevResultFolder());
				final File file = Wizard.this.chooserDialog2.showOpenDialog(Wizard.getInstance().stage);
				if (file != null) {
					chooserText2.setText(file.toString());
				}
			}
		});
		chooser2.getChildren().addAll(this.chooserFNF2, chooserText2, btnOpen2);

		// Part 3
		final VBox part3 = new VBox();
		Tooltip.install(part3,
				new Tooltip("For any inter-App analysis you can optionally specify more involved Apps here."));
		part3.setFillWidth(true);
		part3.setMaxWidth(Double.MAX_VALUE);
		final Label label3 = new Label("Additional Apps (optional):");
		final HBox chooser3 = new HBox(5);
		chooser3.setMaxWidth(Double.MAX_VALUE);
		final TextArea chooserText3 = new TextArea();
		if (this.selectedAdditionalApks != null) {
			chooserText3.setText(this.selectedAdditionalApks.toString());
		}
		chooserText3.textProperty().addListener(new ChangeListener<String>() {
			@Override
			public void changed(final ObservableValue<? extends String> observable, final String oldValue,
					final String newValue) {
				try {
					if (!newValue.equals("")) {
						Wizard.getInstance().selectedAdditionalApks = createAdditionalApkList(newValue);
						if (Wizard.getInstance().selectedAdditionalApks != null) {
							chooserText3.setText(chooserText3.getText().toString().replaceAll(",[ \t\n]*", ",\n"));
						}
						if (Wizard.this.selectedAdditionalApks
								.get(Wizard.getInstance().selectedAdditionalApks.size() - 1).getParentFile().exists()) {
							GuiConfig.getInstance().setNnApkFolder(Wizard.getInstance().selectedAdditionalApks
									.get(Wizard.getInstance().selectedAdditionalApks.size() - 1).getParentFile());
						}
					} else {
						Wizard.this.chooserFNF3.setImage(new Image("file:data/images/info_16.png"));
						Wizard.getInstance().selectedAdditionalApks = null;
					}
				} catch (final NullPointerException e) {
					Wizard.this.chooserFNF3.setImage(new Image("file:data/images/delete_16.png"));
					Wizard.getInstance().selectedAdditionalApks = null;
				}
			}
		});
		if (this.selectedAdditionalApks != null) {
			final String tempStr = this.selectedAdditionalApks.toString().substring(1,
					this.selectedAdditionalApks.toString().length() - 1);
			chooserText3.setText(tempStr);
			createAdditionalApkList(tempStr);
		} else {
			createAdditionalApkList(null);
		}
		final Button btnOpen3 = new Button("Browse...");
		btnOpen3.setMinWidth(75d);
		btnOpen3.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent e) {
				Wizard.this.chooserDialog3.setInitialDirectory(GuiConfig.getInstance().getNnApkFolder());
				final List<File> files = Wizard.this.chooserDialog3.showOpenMultipleDialog(Wizard.getInstance().stage);
				if (files != null) {
					final String tempStr = chooserText3.getText().toString().replaceAll(",[ \t\n]*", ",");
					if (tempStr != null && !tempStr.equals("")) {
						chooserText3
								.setText((tempStr + "," + files.toString().substring(1, files.toString().length() - 1))
										.replaceAll(",", ",\n"));
					} else {
						chooserText3.setText(
								files.toString().substring(1, files.toString().length() - 1).replaceAll(",", ",\n"));
					}
				}
			}
		});
		chooser3.getChildren().addAll(this.chooserFNF3, chooserText3, btnOpen3);
		if (this.selectedLevel == AnalysisRegistry.LEVEL2B) {
			chooser3.setDisable(false);
		} else {
			chooser3.setDisable(true);
		}

		// Build
		part1.getChildren().addAll(label1, chooser1);
		part2.getChildren().addAll(part2labelBox, chooser2);
		part3.getChildren().addAll(label3, chooser3);
		page.getChildren().addAll(title, part1, part2, part3);

		return page;
	}
}
