package de.upb.pga3.panda2.client.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.upb.pga3.panda2.client.core.AnalysisRegistry;
import de.upb.pga3.panda2.client.core.ResultLoader;
import de.upb.pga3.panda2.core.Analysis;
import de.upb.pga3.panda2.core.AnalysisFactory;
import de.upb.pga3.panda2.core.AnalysisRunner;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.extension.lvl2b.ExtraAnalysisInputLvl2b;
import de.upb.pga3.panda2.utilities.Constants;

/**
 * Model class of the GUI.
 *
 * @author Felix
 */
public class Model {
	// MVC
	GUIView view;

	public static final int STATUS_READY = 0;
	public static final int STATUS_LOADING = 1;

	File saveFile = null;
	List<AnalysisResult> analysisResults = new ArrayList<>();
	Map<AnalysisResult, List<String>> mapAnalysisResults = new HashMap<>();
	List<String> lastSetup = new ArrayList<>();
	AnalysisResult currentAnalysisResult;
	int loadedCounter = 0;
	long time;

	double zoomTextual = 1.0d, zoomGrapical = 1.0d;
	double initDevPxRatioTextual = 1.0d, initDevPxRatioGraphical = 1.0d;

	boolean dontJumpFlag = false;

	Model(final GUIView view) {
		this.view = view;
	}

	GUIView getView() {
		return this.view;
	}

	public void setLastSetup(final String level, final String apkStr) {
		this.lastSetup = new ArrayList<>();
		this.lastSetup.add(level);
		this.lastSetup.add(apkStr);
	}

	public void startAnalysis(final String level, final File apk, final File prevResult,
			final List<File> additionalApks, final boolean allmode) {
		setLastSetup(level, apk.toString());

		AnalysisFactory analysisFactory = null;
		final List<Analysis> analysisList;
		final AnalysisResult analysisResult;
		if (prevResult != null
				&& prevResult.toString().substring(prevResult.toString().length() - 4, prevResult.toString().length())
						.equals(Constants.SAVED_RESULT_EXTENSION)) {
			analysisResult = ResultLoader.loadPreviousAnalysisResult(prevResult.toString());
		} else {
			analysisResult = null;
		}
		analysisFactory = AnalysisRegistry.getInstance().getFactory(level, apk, analysisResult, prevResult,
				additionalApks, new ExtraAnalysisInputLvl2b(allmode));
		if (analysisFactory == null) {
			GUIView.log(
					"Could not start Analysis.\n(The selected previous result belongs to a different type of analysis. Selected analysis: "
							+ level + ")");
			return;
		}
		analysisList = analysisFactory.createAnalysis();

		final AnalysisRunner analysisRunner = new AnalysisRunner();
		analysisRunner.analyzeAsync(analysisList, getView());
		String logStr = "Analysis started.\n\nSelected Analysis: " + level;
		if (level == AnalysisRegistry.LEVEL2B) {
			if (allmode) {
				logStr += " [ALL]";
			} else {
				logStr += " [APP]";
			}
		}
		logStr += "\nSelected input: " + apk.toString() + "\n";
		if (additionalApks != null && level == AnalysisRegistry.LEVEL2B) {
			for (final File additionalApk : additionalApks) {
				logStr += "Additional input: " + additionalApk.toString() + "\n";
			}
		}
		if (prevResult != null) {
			logStr += "Input for comparison: " + prevResult.toString() + "\n";
		}
		GUIView.log(logStr);
		getView().setStatus(Model.STATUS_LOADING);

		this.time = new Date().getTime() / 1000;
	}
}
