package de.upb.pga3.panda2.client.gui;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;

import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;

/**
 * The info window which will show up once info has been clicked is defined in
 * this class.
 *
 * @author Felix
 */
public class InfoWindow extends Application {
	@Override
	public void start(final Stage stage) {
		stage.setTitle("Information");
		GUIHelper.setPandaIcon(stage);
		stage.setResizable(false);

		final BorderPane pane = new BorderPane();
		final WebView htmlView = new WebView();
		final WebEngine htmlEngine = htmlView.getEngine();
		final File temp = new File("data/help/info.html");
		htmlEngine.load("file:///" + temp.getAbsolutePath().toString().replaceAll("\\\\", "/"));
		htmlEngine.locationProperty().addListener(new ChangeListener<String>() {
			@Override
			public void changed(final ObservableValue<? extends String> observable, final String oldValue,
					final String newValue) {
				final Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
				if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
					try {
						desktop.browse(new URI("http://www.uni-paderborn.de"));
					} catch (final Exception e) {
						final Alert alert = new Alert(AlertType.INFORMATION);
						final Stage alertStage = (Stage) alert.getDialogPane().getScene().getWindow();
						GUIHelper.setPandaIcon(alertStage);
						alert.setTitle("Error");
						alert.setHeaderText("External Browser");
						alert.setContentText("Could not open the external browser.");

						alert.showAndWait();
					}
				}
				// stage.hide();
				Platform.runLater(new Runnable() {
					@Override
					public void run() {
						htmlEngine.load("file:///" + temp.getAbsolutePath().toString().replaceAll("\\\\", "/"));
					}
				});
			}
		});
		pane.setCenter(htmlView);

		// Set and show stage
		final Scene scene = new Scene(pane, 550, 400);
		stage.setScene(scene);

		stage.show();
	}
}