package de.upb.pga3.panda2.client.gui;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

import de.upb.pga3.panda2.client.core.AnalysisRegistry;
import de.upb.pga3.panda2.core.AsyncAnalysisResult;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.core.datastructures.Message;
import de.upb.pga3.panda2.core.datastructures.MessageType;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl2b.AnalysisResultLvl2b;
import de.upb.pga3.panda2.utilities.Constants;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

/**
 * View class of the GUI.
 *
 * @author Felix
 * @author Fabian
 */
public class GUIView extends Application implements AsyncAnalysisResult {
	static final Logger LOGGER = LogManager.getLogger(GUIView.class);

	static final String JS_SCRIPT_ENABLE_FIREBUG = "if (!document.getElementById('FirebugLite')){E = document['createElement' + 'NS'] && document.documentElement.namespaceURI;E = E ? document['createElement' + 'NS'](E, 'script') : document['createElement']('script');E['setAttribute']('id', 'FirebugLite');E['setAttribute']('src', 'https://getfirebug.com/' + 'firebug-lite.js' + '#startOpened');E['setAttribute']('FirebugLite', '4');(document['getElementsByTagName']('head')[0] || document['getElementsByTagName']('body')[0]).appendChild(E);E = new Image;E['setAttribute']('src', 'https://getfirebug.com/' + '#startOpened');}";

	// Show Result
	private static AnalysisResult initialResult = null;
	private static File initialApk;
	boolean wait1 = false;
	boolean wait2 = false;

	// MVC
	private Model model = new Model(this);
	private Controller controller = new Controller(this, this.model);

	// Data
	DetailLevel selectedDetailLevel;
	List<String> selectedFilters;
	boolean selectedShowStats;

	// View elements
	private ImageView statusImage;

	// Messages
	private final static int suggestions = 0;
	private final static int errors = 1;
	private final static int warnings = 2;
	private final static int infos = 3;
	List<List<Node>> messageItems;
	int[] messages;
	Button[] loadAllMessages;
	List<VBox> msgPartBox;

	Stage stage;
	TabPane tabPane;
	Tab tabTextual, tabGraphical, tabMessages;
	static TextArea infoArea = null;
	WebView htmlTextual, htmlGraphical;
	WebEngine htmlEngineTextual, htmlEngineGraphical;
	DebugChangeListener dbgChngLstnrTextual, dbgChngLstnrGraphical;
	VBox filterBox;
	VBox messageBox;
	FlowPane flowPaneActiveFilters;
	Button btnPrev, btnNext, btnSave, btnNew, btnOpen, btnViewInBrowser;
	ComboBox<String> analysisJumper;
	Button btnClearJumper;
	MenuItem menuItemNew, menuItemOpen, menuItemSave, menuItemSaveAs;

	// Output options
	String htmlTextualStr, htmlGraphicalStr;
	boolean isFile;

	Model getModel() {
		return this.model;
	}

	public Controller getController() {
		return this.controller;
	}

	public static void setInitialResult(final AnalysisResult result, final File apk) {
		initialResult = result;
		initialApk = apk;
	}

	@Override
	public void start(final Stage inStage) {
		// Gui config
		GuiConfig.getInstance().load();

		// Main
		this.stage = inStage;
		this.stage.setTitle("PAndA\u00B2");
		GUIHelper.setPandaIcon(this.stage);
		this.stage.setOnCloseRequest(new EventHandler<WindowEvent>() {
			@Override
			public void handle(final WindowEvent we) {
				we.consume();
				getController().exitClicked();
			}
		});

		// MenuBar
		final VBox menuBox = new VBox();
		final MenuBar menuBar = new MenuBar();
		final Menu menuFile = new Menu("File");
		this.menuItemNew = new MenuItem("New Analysis...");
		this.menuItemNew.setGraphic(new ImageView(new Image("file:data/images/document_16.png")));
		this.menuItemNew.setAccelerator(new KeyCodeCombination(KeyCode.N, KeyCombination.CONTROL_DOWN));
		this.menuItemNew.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				getController().newClicked();
			}
		});
		final SeparatorMenuItem seperator1 = new SeparatorMenuItem();
		this.menuItemOpen = new MenuItem("Open previous result");
		this.menuItemOpen.setGraphic(new ImageView(new Image("file:data/images/folder_16.png")));
		this.menuItemOpen.setAccelerator(new KeyCodeCombination(KeyCode.O, KeyCombination.CONTROL_DOWN));
		this.menuItemOpen.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				getController().openClicked();
			}
		});
		final SeparatorMenuItem seperator2 = new SeparatorMenuItem();
		this.menuItemSave = new MenuItem("Save");
		this.menuItemSave.setGraphic(new ImageView(new Image("file:data/images/save_16.png")));
		this.menuItemSave.setAccelerator(new KeyCodeCombination(KeyCode.S, KeyCombination.CONTROL_DOWN));
		this.menuItemSave.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				getController().saveClicked();
			}
		});
		this.menuItemSaveAs = new MenuItem("Save As...");
		this.menuItemSaveAs.setGraphic(new ImageView(new Image("file:data/images/save_16.png")));
		this.menuItemSaveAs.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				getController().saveAsClicked();
			}
		});
		final SeparatorMenuItem seperator3 = new SeparatorMenuItem();
		final MenuItem menuItemExit = new MenuItem("Exit");
		menuItemExit.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				getController().exitClicked();
			}
		});
		menuFile.getItems().addAll(this.menuItemNew, seperator1, this.menuItemOpen, seperator2, this.menuItemSave,
				this.menuItemSaveAs, seperator3, menuItemExit);
		final Menu menuHelp = new Menu("Help");
		// Add debug HTML
		final CheckMenuItem debugHTMLCheckBox = new CheckMenuItem();
		debugHTMLCheckBox.setGraphic(new ImageView(new Image("file:data/images/firebug.png")));
		debugHTMLCheckBox.setSelected(false);
		debugHTMLCheckBox.setText("Debug HTML");
		debugHTMLCheckBox.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				if (debugHTMLCheckBox.isSelected()) {
					GUIView.this.htmlEngineTextual.documentProperty().addListener(GUIView.this.dbgChngLstnrTextual);
					GUIView.this.htmlEngineGraphical.documentProperty().addListener(GUIView.this.dbgChngLstnrGraphical);
					log("Debug HTML enabled");
				} else {
					GUIView.this.htmlEngineTextual.documentProperty().removeListener(GUIView.this.dbgChngLstnrTextual);
					GUIView.this.htmlEngineGraphical.documentProperty()
							.removeListener(GUIView.this.dbgChngLstnrGraphical);
					log("Debug HTML disabled");
				}
			}
		});
		final MenuItem menuItemManual = new MenuItem("Manual");
		menuItemManual.setGraphic(new ImageView(new Image("file:data/images/help_16.png")));
		menuItemManual.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				if (Desktop.isDesktopSupported()) {
					try {
						final File myFile = new File("data/help/manual.pdf");
						Desktop.getDesktop().open(myFile);
					} catch (final IOException ex) {
						LOGGER.error("Could not access manual.pdf or PDF Viewer.");
					}
				}
			}
		});
		final MenuItem menuItemInfo = new MenuItem("Info");
		menuItemInfo.setGraphic(new ImageView(new Image("file:data/images/logo_panda_16.png")));
		menuItemInfo.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				new InfoWindow().start(new Stage());
			}
		});
		menuHelp.getItems().addAll(debugHTMLCheckBox, menuItemManual, menuItemInfo);
		menuBar.getMenus().addAll(menuFile, menuHelp);

		// Toolbar
		final ToolBar toolBar = new ToolBar();
		this.btnNew = new Button();
		this.btnNew.setGraphic(new ImageView(new Image("file:data/images/document_16.png")));
		this.btnNew.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				getController().newClicked();
			}
		});
		this.btnOpen = new Button();
		this.btnOpen.setGraphic(new ImageView(new Image("file:data/images/folder_16.png")));
		this.btnOpen.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				getController().openClicked();
			}
		});
		this.btnSave = new Button();
		this.btnSave.setGraphic(new ImageView(new Image("file:data/images/save_16.png")));
		this.btnSave.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				getController().saveClicked();
			}
		});
		final Separator separator = new Separator();
		this.btnPrev = new Button();
		this.btnPrev.setGraphic(new ImageView(new Image("file:data/images/left_16.png")));
		this.btnPrev.setDisable(true);
		this.btnPrev.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				AnalysisResult tempResult = getModel().currentAnalysisResult;
				for (final AnalysisResult item : getModel().analysisResults) {
					if (item == getModel().currentAnalysisResult) {
						break;
					} else {
						tempResult = item;
					}
				}
				analysisLoad(tempResult);
			}
		});
		this.btnNext = new Button();
		this.btnNext.setGraphic(new ImageView(new Image("file:data/images/right_16.png")));
		this.btnNext.setDisable(true);
		this.btnNext.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				AnalysisResult tempResult = getModel().currentAnalysisResult;
				for (int i = getModel().analysisResults.size() - 1; i >= 0; i--) {
					final AnalysisResult item = getModel().analysisResults.get(i);
					if (item == getModel().currentAnalysisResult) {
						break;
					} else {
						tempResult = item;
					}
				}
				analysisLoad(tempResult);
			}
		});
		this.analysisJumper = new ComboBox<>();
		this.analysisJumper.setDisable(true);
		this.analysisJumper.setMaxWidth(250d);
		this.analysisJumper.setPrefWidth(250d);
		this.analysisJumper.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				if (!getModel().dontJumpFlag) {
					final String tempStr = GUIView.this.analysisJumper.getValue().toString();
					for (int i = 0; i < getModel().analysisResults.size(); i++) {
						final AnalysisResult result = getModel().analysisResults.get(i);
						final String equalStr = (i + 1) + ". " + getModel().mapAnalysisResults.get(result).get(0) + ", "
								+ getModel().mapAnalysisResults.get(result).get(1);
						if (tempStr.equals(equalStr)) {
							analysisLoad(result);
							break;
						}
					}
				}
			}
		});
		this.btnClearJumper = new Button("Clear");
		this.btnClearJumper.setGraphic(new ImageView(new Image("file:data/images/trash_16.png")));
		this.btnClearJumper.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				getModel().analysisResults.clear();
				getModel().mapAnalysisResults.clear();
				setStatus(Model.STATUS_READY);
			}
		});

		final HBox zoomSpaceingBox = new HBox();
		HBox.setHgrow(zoomSpaceingBox, Priority.ALWAYS);

		this.btnViewInBrowser = new Button();
		this.btnViewInBrowser.setGraphic(new ImageView(new Image("file:data/images/globe_16.png")));
		this.btnViewInBrowser.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				getController().viewInBrowser(!GUIView.this.isFile);
			}
		});
		this.btnViewInBrowser.setDisable(true);
		final Separator separator2 = new Separator();
		final Button btnZoomIn = new Button();
		btnZoomIn.setGraphic(new ImageView(new Image("file:data/images/zoomIn_16.png")));
		btnZoomIn.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				getController().zoomIn();
			}
		});
		final Button btnZoomOut = new Button();
		btnZoomOut.setGraphic(new ImageView(new Image("file:data/images/zoomOut_16.png")));
		btnZoomOut.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				getController().zoomOut();
			}
		});
		final Button btnZoomReset = new Button();
		btnZoomReset.setGraphic(new ImageView(new Image("file:data/images/zoomReset_16.png")));
		btnZoomReset.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {
				getController().zoomReset();
			}
		});
		Platform.runLater(new Runnable() {
			@Override
			public void run() {
				btnZoomIn.getScene().getAccelerators()
						.put(new KeyCodeCombination(KeyCode.PLUS, KeyCombination.CONTROL_ANY), new Runnable() {
					@Override
					public void run() {
						btnZoomIn.fire();
					}
				});
				btnZoomOut.getScene().getAccelerators()
						.put(new KeyCodeCombination(KeyCode.MINUS, KeyCombination.CONTROL_ANY), new Runnable() {
					@Override
					public void run() {
						btnZoomOut.fire();
					}
				});
				btnZoomReset.getScene().getAccelerators()
						.put(new KeyCodeCombination(KeyCode.DIGIT0, KeyCombination.CONTROL_ANY), new Runnable() {
					@Override
					public void run() {
						btnZoomReset.fire();
					}
				});
			}
		});
		toolBar.getItems().addAll(this.btnNew, this.btnOpen, this.btnSave, separator, this.btnPrev, this.btnNext,
				this.analysisJumper, this.btnClearJumper, zoomSpaceingBox, this.btnViewInBrowser, separator2, btnZoomIn,
				btnZoomOut, btnZoomReset);

		menuBox.getChildren().addAll(menuBar, toolBar);

		// Tabs
		this.tabPane = new TabPane();
		this.tabTextual = new Tab();
		this.tabTextual.setGraphic(new ImageView(new Image("file:data/images/address_16.png")));
		this.tabTextual.setText("Textual");
		this.tabTextual.setClosable(false);
		this.htmlTextual = new WebView();
		this.htmlEngineTextual = this.htmlTextual.getEngine();
		this.dbgChngLstnrTextual = new DebugChangeListener(this.htmlEngineTextual);
		this.htmlEngineTextual.loadContent(GUIHelper.generateHTMLDocument(""));
		getModel().initDevPxRatioTextual = Controller.getDevPxRatio(this.htmlEngineTextual);
		this.tabTextual.setContent(this.htmlTextual);

		this.tabGraphical = new Tab();
		this.tabGraphical.setGraphic(new ImageView(new Image("file:data/images/diagram_16.png")));
		this.tabGraphical.setText("Graphical");
		this.tabGraphical.setClosable(false);
		this.htmlGraphical = new WebView();
		this.htmlEngineGraphical = this.htmlGraphical.getEngine();
		this.dbgChngLstnrGraphical = new DebugChangeListener(this.htmlEngineGraphical);
		this.htmlEngineGraphical.loadContent(GUIHelper.generateHTMLDocument(""));
		getModel().initDevPxRatioGraphical = Controller.getDevPxRatio(this.htmlEngineGraphical);
		this.tabGraphical.setContent(this.htmlGraphical);

		LOGGER.debug("WebView User Agent: {}", this.htmlEngineGraphical.getUserAgent());

		this.tabMessages = new Tab();
		this.tabMessages.setGraphic(new ImageView(new Image("file:data/images/bubble_16.png")));
		this.tabMessages.setText("Messages");
		this.tabMessages.setClosable(false);
		final ScrollPane scrollPaneMessages = new ScrollPane();
		scrollPaneMessages.setFitToWidth(true);
		this.messageBox = new VBox();
		this.messageBox.setPadding(new Insets(15, 15, 15, 15));
		scrollPaneMessages.setContent(this.messageBox);
		this.tabMessages.setContent(scrollPaneMessages);
		this.messageItems = new ArrayList<>(4);
		this.loadAllMessages = new Button[4];
		this.messages = new int[4];
		for (int i = 0; i <= 3; i++) {
			this.messageItems.add(new ArrayList<Node>());

			final int current = i;
			this.loadAllMessages[current] = new Button("Show more");
			this.loadAllMessages[current].setPrefWidth(Double.MAX_VALUE);
			this.loadAllMessages[current].setOnAction(new EventHandler<ActionEvent>() {
				@Override
				public void handle(final ActionEvent event) {
					getController().loadMessages(current);
				}
			});
		}

		this.tabPane.getTabs().addAll(this.tabTextual, this.tabGraphical, this.tabMessages);

		// Filters
		final BorderPane bottomPane = new BorderPane();
		this.filterBox = new VBox(10);
		final TitledPane filterPane = new TitledPane("Filter", this.filterBox);
		filterPane.setExpanded(false);
		final HBox infoBox = new HBox();
		infoBox.setMaxWidth(Double.MAX_VALUE);
		final VBox statusBox = new VBox(15);
		final Label statusLabel = new Label("Status:");
		statusLabel.setMinWidth(50d);
		this.statusImage = new ImageView();
		setStatus(Model.STATUS_READY);
		statusBox.getChildren().addAll(statusLabel, this.statusImage);
		infoArea = new TextArea();
		infoArea.textProperty().addListener(new ChangeListener<Object>() {
			@Override
			public void changed(final ObservableValue<?> observable, final Object oldValue, final Object newValue) {
				infoArea.setScrollTop(Double.MAX_VALUE);
			}
		});
		infoArea.setEditable(false);
		infoArea.setPrefWidth(Integer.MAX_VALUE);
		infoBox.getChildren().addAll(statusBox, infoArea);
		final TitledPane infoPane = new TitledPane("Details", infoBox);
		bottomPane.setTop(filterPane);
		bottomPane.setCenter(infoPane);

		// Build
		final BorderPane pane = new BorderPane();
		pane.setTop(menuBox);
		pane.setCenter(this.tabPane);
		pane.setBottom(bottomPane);

		// Set and show stage
		final Scene scene = new Scene(pane, 800, 600);
		this.stage.setScene(scene);

		// Load initial Result
		if (initialResult != null) {
			getModel().setLastSetup(AnalysisRegistry.getInstance().getName(initialResult), initialApk.toString());

			final SingleSelectionModel<Tab> selectionModel = this.tabPane.getSelectionModel();
			selectionModel.select(this.tabGraphical);
			analysisFinished(initialResult);

			initialResult = null;
		}

		this.stage.show();
	}

	void setStatus(final int status) {
		if (status == Model.STATUS_READY) {
			this.menuItemNew.setDisable(false);
			this.btnNew.setDisable(false);
			this.menuItemOpen.setDisable(false);
			this.btnOpen.setDisable(false);
			if (!getModel().analysisResults.isEmpty()) {
				this.menuItemSave.setDisable(false);
				this.btnSave.setDisable(false);
				this.menuItemSaveAs.setDisable(false);
			} else {
				this.menuItemSave.setDisable(true);
				this.btnSave.setDisable(true);
				this.menuItemSaveAs.setDisable(true);
			}
			this.statusImage.setImage(new Image("file:data/images/tick_32.png"));
		} else if (status == Model.STATUS_LOADING) {
			this.menuItemNew.setDisable(true);
			this.btnNew.setDisable(true);
			this.menuItemOpen.setDisable(true);
			this.btnOpen.setDisable(true);
			this.menuItemSave.setDisable(true);
			this.btnSave.setDisable(true);
			this.menuItemSaveAs.setDisable(true);
			this.statusImage.setImage(new Image("file:data/images/loading.gif"));
		}

		// Check toolbar
		final int current = getModel().analysisResults.indexOf(getModel().currentAnalysisResult);
		if (getModel().analysisResults.size() >= 1) {
			this.analysisJumper.setDisable(false);
			this.btnClearJumper.setDisable(false);
			Platform.runLater(new Runnable() {
				@Override
				public void run() {
					for (int i = 0; i < getModel().analysisResults.size(); i++) {
						final AnalysisResult result = getModel().analysisResults.get(i);
						final String tempStr = (i + 1) + ". " + getModel().mapAnalysisResults.get(result).get(0) + ", "
								+ getModel().mapAnalysisResults.get(result).get(1);
						if (!GUIView.this.analysisJumper.getItems().contains(tempStr)) {
							GUIView.this.analysisJumper.getItems().add(tempStr);
						}
						if (result == getModel().currentAnalysisResult) {
							getModel().dontJumpFlag = true;
							GUIView.this.analysisJumper.setValue(tempStr);
							getModel().dontJumpFlag = false;
						}
					}
				}
			});
		} else {
			this.analysisJumper.setDisable(true);
			this.btnClearJumper.setDisable(true);
		}
		if (getModel().analysisResults.size() > 1) {
			if (current != 0) {
				this.btnPrev.setDisable(false);
			} else {
				this.btnPrev.setDisable(true);
			}
			if (current != getModel().analysisResults.size() - 1) {
				this.btnNext.setDisable(false);
			} else {
				this.btnNext.setDisable(true);
			}
		} else {
			this.btnPrev.setDisable(true);
			this.btnNext.setDisable(true);
		}
	}

	static void log(final String msg) {
		if (infoArea != null) {
			// Get date
			final DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
			final Date date = new Date();

			// Build log msg
			Platform.runLater(new Runnable() {
				@Override
				public void run() {
					infoArea.appendText(dateFormat.format(date) + ": " + msg + "\n");
				}
			});
		}
	}

	void analysisLoad(final AnalysisResult result) {
		final List<String> loadedSetup = getModel().mapAnalysisResults.get(result);
		log("Analysis result loaded: " + loadedSetup.get(0) + ", " + loadedSetup.get(1));
		loadAnalysisResult(result);
	}

	@Override
	public void analysisFinished(final AnalysisResult result) {
		getModel().mapAnalysisResults.put(result, getModel().lastSetup);
		getModel().time = new Date().getTime() / 1000 - getModel().time;
		if (initialResult == null) {
			log("Analysis finished (" + getModel().time + "s)");
		}

		loadAnalysisResult(result);
	}

	void loadAnalysisResult(final AnalysisResult result) {
		this.wait1 = true;
		this.wait2 = true;

		if (!getModel().analysisResults.contains(result)) {
			getModel().analysisResults.add(result);
		}
		getModel().currentAnalysisResult = result;

		// Run on UI thread
		Platform.runLater(new Runnable() {
			@Override
			public void run() {
				GUIView.this.filterBox.getChildren().removeAll(GUIView.this.filterBox.getChildren());

				// Add show stats
				final CheckBox showStatsCheckBox = new CheckBox();
				showStatsCheckBox.setSelected(true);
				GUIView.this.selectedShowStats = showStatsCheckBox.isSelected();
				showStatsCheckBox.setText("Auto hide statistics & legend");
				showStatsCheckBox.setOnAction(new EventHandler<ActionEvent>() {
					@Override
					public void handle(final ActionEvent event) {
						GUIView.this.selectedShowStats = showStatsCheckBox.isSelected();
						if (GUIView.this.selectedShowStats) {
							log("Statistics enabled");
						} else {
							log("Statistics disabled");
						}
						showResult(result);
					}
				});
				final Separator separatorCheckBox = new Separator();
				separatorCheckBox.setOrientation(Orientation.VERTICAL);

				// Add detail levels
				GUIView.this.selectedDetailLevel = result.getDetailLevels().get(0);
				final HBox detailLevelBox = new HBox(25);
				final ToggleGroup detailLevelRadioGroup = new ToggleGroup();
				boolean first = true;
				for (final DetailLevel level : result.getDetailLevels()) {
					final RadioButton radioBtn = new RadioButton(level.toString().replaceAll("_", " "));
					if (first) {
						radioBtn.setSelected(true);
						first = false;
					}
					radioBtn.setToggleGroup(detailLevelRadioGroup);
					radioBtn.setOnAction(new EventHandler<ActionEvent>() {
						@Override
						public void handle(final ActionEvent event) {
							GUIView.this.selectedDetailLevel = level;
							log("Detaillevel selected: " + level.toString());
							showResult(result);
						}
					});
					detailLevelBox.getChildren().add(radioBtn);
				}
				detailLevelBox.getChildren().addAll(separatorCheckBox, showStatsCheckBox);
				final Separator separator1 = new Separator();
				GUIView.this.filterBox.getChildren().addAll(detailLevelBox, separator1);

				// Add filters
				final VBox outerFilterBox = new VBox(10);
				final HBox innerFilterBox = new HBox(5);

				final String[] prefixes = { Constants.PREFIX_PERMISSION, Constants.PREFIX_SOURCE,
						Constants.PREFIX_SINK };
				GUIView.this.selectedFilters = new ArrayList<>();
				for (final String filter : result.getFilters()) {
					if (!filter.contains(prefixes[0]) && !filter.contains(prefixes[1])
							&& !filter.contains(prefixes[2])) {
						GUIView.this.selectedFilters.add(filter);
					}
				}

				for (int i = 0; i <= prefixes.length; i++) {
					final List<String> tempList;
					if (i == prefixes.length) {
						tempList = GUIView.this.selectedFilters;
					} else {
						tempList = new ArrayList<>();
						for (final String filter : result.getFilters()) {
							if (filter.contains(prefixes[i])) {
								tempList.add(filter);
							}
						}
					}
					if (!tempList.isEmpty()) {
						final ObservableList<String> filterOptions = FXCollections.observableArrayList(tempList);
						final ComboBox<String> filterChooser = new ComboBox<>(filterOptions);
						filterChooser.setMaxWidth(250d);
						filterChooser.setValue(tempList.get(0));
						final ChooserEventHandler filterChooserHandler = new ChooserEventHandler(filterChooser,
								filterOptions);
						filterChooser.setOnKeyPressed(filterChooserHandler);
						filterChooser.focusedProperty().addListener(new ChangeListener<Boolean>() {
							@Override
							public void changed(final ObservableValue<? extends Boolean> arg0,
									final Boolean oldPropertyValue, final Boolean newPropertyValue) {
								if (!newPropertyValue) {
									filterChooserHandler.reset(false);
								}
							}
						});
						final Button btnFilterAdd = new Button("Add");
						btnFilterAdd.setGraphic(new ImageView(new Image("file:data/images/plus_16.png")));
						btnFilterAdd.setOnAction(new EventHandler<ActionEvent>() {
							@Override
							public void handle(final ActionEvent event) {
								if (!GUIView.this.selectedFilters.contains(filterChooser.getValue())) {
									addActiveFilter(filterChooser.getValue());
									GUIView.this.selectedFilters.add(filterChooser.getValue());
									log("Filter activated: " + filterChooser.getValue());
								} else {
									if (getController().removeFilter(filterChooser.getValue())) {
										GUIView.this.selectedFilters.remove(filterChooser.getValue());
										for (final Node box : GUIView.this.flowPaneActiveFilters.getChildren()) {
											if (((Label) ((HBox) box).getChildren().get(1)).getText()
													.equals(filterChooser.getValue())) {
												GUIView.this.flowPaneActiveFilters.getChildren().remove(box);
												break;
											}
										}
									}
								}
								showResult(result);
							}
						});
						final Separator separator = new Separator();
						separator.setOrientation(Orientation.VERTICAL);
						innerFilterBox.getChildren().addAll(filterChooser, btnFilterAdd, separator);
					}
				}

				// Adaption of filters for Intra-App Permission Usage Analysis
				if (GUIView.this.selectedFilters.contains(AnalysisResultLvl1.TREEOPTION)) {
					GUIView.this.selectedFilters.remove(AnalysisResultLvl1.TREEOPTION);
				}

				// Adaption of filters for Inter-App Permission Usage Analysis
				if (GUIView.this.selectedFilters.contains(AnalysisResultLvl2b.TREEOPTION)) {
					GUIView.this.selectedFilters.remove(AnalysisResultLvl2b.TREEOPTION);
				}

				if (GUIView.this.selectedFilters.isEmpty()) {
					GUIView.this.selectedFilters = result.getFilters();
				}

				final Button btnFilterAddAll = new Button("Add All filters");
				btnFilterAddAll.setGraphic(new ImageView(new Image("file:data/images/plusplus_16.png")));
				btnFilterAddAll.setOnAction(new EventHandler<ActionEvent>() {
					@Override
					public void handle(final ActionEvent event) {
						for (final String tempFilter : result.getFilters()) {
							if (!GUIView.this.selectedFilters.contains(tempFilter)) {
								addActiveFilter(tempFilter);
								GUIView.this.selectedFilters.add(tempFilter);
							}
						}
						log("All available filters activated");
						showResult(result);
					}
				});
				final Button btnFilterClear = new Button("Clear");
				btnFilterClear.setGraphic(new ImageView(new Image("file:data/images/trash_16.png")));
				btnFilterClear.setOnAction(new EventHandler<ActionEvent>() {
					@Override
					public void handle(final ActionEvent event) {
						GUIView.this.selectedFilters.clear();
						GUIView.this.flowPaneActiveFilters.getChildren()
								.removeAll(GUIView.this.flowPaneActiveFilters.getChildren());
						log("All active filters removed");
						showResult(result);
					}
				});
				final BorderPane activeFilterBox = new BorderPane();
				final Text activeFilterText = new Text("Active filters:");
				activeFilterText.setFont(Font.font("Verdana", FontWeight.BOLD, 12));
				GUIView.this.flowPaneActiveFilters = new FlowPane();
				GUIView.this.flowPaneActiveFilters.setStyle("-fx-background-color: white");
				GUIView.this.flowPaneActiveFilters.setHgap(10d);
				GUIView.this.flowPaneActiveFilters.setVgap(5d);
				final ScrollPane filterFlowPaneScrollPane = new ScrollPane(GUIView.this.flowPaneActiveFilters);
				filterFlowPaneScrollPane.setFitToWidth(true);
				filterFlowPaneScrollPane.setFitToHeight(true);
				filterFlowPaneScrollPane.setMaxHeight(155d);
				filterFlowPaneScrollPane.setMinHeight(19d);
				activeFilterBox.setLeft(activeFilterText);
				activeFilterBox.setCenter(filterFlowPaneScrollPane);
				innerFilterBox.getChildren().addAll(btnFilterAddAll, btnFilterClear);
				outerFilterBox.getChildren().addAll(innerFilterBox, activeFilterBox);
				GUIView.this.filterBox.getChildren().add(outerFilterBox);
				for (final String filter : GUIView.this.selectedFilters) {
					addActiveFilter(filter);
				}

				GUIView.this.wait1 = false;
				GUIView.this.wait2 = false;
			}
		});

		showResult(result);
		showMessages(result);
	}

	void showResult(final AnalysisResult result) {
		new Thread(new Runnable() {
			@Override
			public void run() {
				while (GUIView.this.wait1) {
					try {
						Thread.sleep(1000);
					} catch (final InterruptedException e) {
						e.printStackTrace();
					}
				}
				GUIView.this.wait1 = true;

				// Run on UI thread
				Platform.runLater(new Runnable() {
					@Override
					public void run() {
						setStatus(Model.STATUS_LOADING);
						GUIView.this.wait1 = false;
					}
				});

				while (GUIView.this.wait1) {
					try {
						Thread.sleep(1000);
					} catch (final InterruptedException e) {
						e.printStackTrace();
					}
				}
				try {
					GUIView.this.htmlTextualStr = result.getTextualResult(GUIView.this.selectedDetailLevel,
							GUIView.this.selectedFilters, GUIView.this.selectedShowStats);
				} catch (final Exception e) {
					log("An error accured while filtering the textual result.");
					LOGGER.error("An error accured while filtering the textual result: " + e.getMessage());
					e.printStackTrace();
				}
				try {
					GUIView.this.htmlGraphicalStr = result.getGraphicalResult(GUIView.this.selectedDetailLevel,
							GUIView.this.selectedFilters, GUIView.this.selectedShowStats);
				} catch (final Exception e) {
					log("An error accured while filtering the graphical result.");
					LOGGER.error("An error accured while filtering the graphical result: " + e.getMessage());
					e.printStackTrace();
				}

				// Run on UI thread
				Platform.runLater(new Runnable() {
					@Override
					public void run() {
						if (!result.getResultIsFile()) {
							GUIView.this.isFile = false;
							GUIView.this.htmlEngineTextual.loadContent(GUIView.this.htmlTextualStr);
							GUIView.this.htmlEngineGraphical.loadContent(GUIView.this.htmlGraphicalStr);
						} else {
							GUIView.this.isFile = true;
							GUIView.this.htmlEngineTextual
									.load("file:///" + new File(GUIView.this.htmlTextualStr).getAbsolutePath());
							GUIView.this.htmlEngineGraphical
									.load("file:///" + new File(GUIView.this.htmlGraphicalStr).getAbsolutePath());
						}
						GUIView.this.btnViewInBrowser.setDisable(false);

						setStatus(Model.STATUS_READY);
						log("Result filtered.");
					}
				});
			}
		}).start();
	}

	void showMessages(final AnalysisResult result) {
		new Thread(new Runnable() {
			@Override
			public void run() {
				while (GUIView.this.wait2) {
					try {
						Thread.sleep(1000);
					} catch (final InterruptedException e) {
						e.printStackTrace();
					}
				}

				// Clear
				for (int i = 0; i <= 3; i++) {
					GUIView.this.messageItems.get(i).clear();
					GUIView.this.messages[i] = 0;
					GUIView.this.loadAllMessages[i].setVisible(true);
				}

				// Add
				for (final Message msg : result.getMessages()) {
					if (msg.getType() == MessageType.SUGGESTION) {
						GUIView.this.messages[suggestions]++;
						GUIView.this.messageItems.get(suggestions)
								.add(addMessage(msg, GUIView.this.messages[suggestions]));
					} else if (msg.getType() == MessageType.ERROR) {
						GUIView.this.messages[errors]++;
						GUIView.this.messageItems.get(errors).add(addMessage(msg, GUIView.this.messages[errors]));
					} else if (msg.getType() == MessageType.WARNING) {
						GUIView.this.messages[warnings]++;
						GUIView.this.messageItems.get(warnings).add(addMessage(msg, GUIView.this.messages[warnings]));
					} else {
						GUIView.this.messages[infos]++;
						GUIView.this.messageItems.get(infos).add(addMessage(msg, GUIView.this.messages[infos]));
					}
				}

				// Run on UI thread
				Platform.runLater(new Runnable() {
					@Override
					public void run() {
						GUIView.this.messageBox.getChildren().clear();

						GUIView.this.msgPartBox = new ArrayList<>();
						for (int i = 0; i <= 3; i++) {
							GUIView.this.msgPartBox.add(new VBox(5));
							GUIView.this.msgPartBox.get(i).getChildren()
									.addAll(GUIView.this.messageItems.get(i).subList(0,
											GUIView.this.messageItems.get(i).size() < 100
													? GUIView.this.messageItems.get(i).size() : 100));
							if (GUIView.this.messageItems.get(i).size() >= 100) {
								GUIView.this.msgPartBox.get(i).getChildren().add(GUIView.this.loadAllMessages[i]);
							}
						}

						// Suggestions
						final TitledPane suggestionPane = new TitledPane(
								"Suggestions (" + GUIView.this.messages[suggestions] + ")",
								GUIView.this.msgPartBox.get(suggestions));
						suggestionPane.setStyle("-fx-background-color: white");
						if (GUIView.this.msgPartBox.get(suggestions).getChildren().size() == 0) {
							suggestionPane.setExpanded(false);
						}

						// Error
						final TitledPane errorPane = new TitledPane("Errors (" + GUIView.this.messages[errors] + ")",
								GUIView.this.msgPartBox.get(errors));
						errorPane.setStyle("-fx-background-color: white");
						if (GUIView.this.msgPartBox.get(errors).getChildren().size() == 0) {
							errorPane.setExpanded(false);
						}

						// Warning
						final TitledPane warningPane = new TitledPane(
								"Warnings (" + GUIView.this.messages[warnings] + ")",
								GUIView.this.msgPartBox.get(warnings));
						warningPane.setStyle("-fx-background-color: white");
						if (GUIView.this.msgPartBox.get(warnings).getChildren().size() == 0) {
							warningPane.setExpanded(false);
						}

						// Info
						final TitledPane infoPane = new TitledPane("Information (" + GUIView.this.messages[infos] + ")",
								GUIView.this.msgPartBox.get(infos));
						infoPane.setStyle("-fx-background-color: white");
						if (GUIView.this.msgPartBox.get(infos).getChildren().size() == 0) {
							infoPane.setExpanded(false);
						}

						GUIView.this.messageBox.getChildren().addAll(suggestionPane, errorPane, warningPane, infoPane);
					}
				});
			}
		}).start();
	}

	public void showNextMessages(final int current) {
		setStatus(Model.STATUS_LOADING);

		this.msgPartBox.get(current).getChildren().remove(this.loadAllMessages[current]);
		final int startIndex = this.msgPartBox.get(current).getChildren().size();
		this.msgPartBox.get(current).getChildren()
				.addAll(this.messageItems.get(current).subList(startIndex, startIndex + 500));
		if (startIndex + 500 < this.messageItems.get(current).size()) {
			this.msgPartBox.get(current).getChildren().add(this.loadAllMessages[current]);
		}

		setStatus(Model.STATUS_READY);
	}

	static VBox addMessage(final Message msg, final int number) {
		final VBox wholeBox = new VBox(5);

		String msgBodyStr;
		if (msg.getBody().contains("\n")) {
			msgBodyStr = msg.getBody().substring(0, msg.getBody().indexOf("\n"));
		} else {
			msgBodyStr = msg.getBody();
		}
		final Label msgBody = new Label(msgBodyStr);
		msgBody.setWrapText(true);
		final Separator separator = new Separator();

		final HBox msgBox = new HBox(10);
		final ImageView msgImage;
		if (msg.getType() == MessageType.WARNING) {
			msgImage = new ImageView(new Image("file:data/images/warning_16.png"));
		} else if (msg.getType() == MessageType.ERROR) {
			msgImage = new ImageView(new Image("file:data/images/delete_16.png"));
		} else if (msg.getType() == MessageType.SUGGESTION) {
			msgImage = new ImageView(new Image("file:data/images/flag_16.png"));
		} else {
			msgImage = new ImageView(new Image("file:data/images/info_16.png"));
		}
		final Text msgTitle = new Text(number + ". " + msg.getTitle());
		msgTitle.setFont(Font.font("Verdana", FontWeight.BOLD, 12));
		msgBox.getChildren().addAll(msgImage, msgTitle);

		wholeBox.getChildren().addAll(msgBox, msgBody, separator);
		wholeBox.setCache(true);
		wholeBox.setCacheHint(CacheHint.SPEED);

		return wholeBox;
	}

	void addActiveFilter(final String filterStr) {
		final HBox singleFilterBox = new HBox(1);
		singleFilterBox.setAlignment(Pos.CENTER_LEFT);
		final Label filterLabel = new Label(filterStr);
		final ImageView filterRemoveBtn = new ImageView(new Image("file:data/images/delete_16.png"));
		filterRemoveBtn.setScaleX(0.75);
		filterRemoveBtn.setScaleY(0.75);
		filterRemoveBtn.addEventHandler(MouseEvent.MOUSE_CLICKED, new EventHandler<MouseEvent>() {
			@Override
			public void handle(final MouseEvent event) {
				event.consume();
				GUIView.this.selectedFilters.remove(filterStr);
				GUIView.this.flowPaneActiveFilters.getChildren().remove(singleFilterBox);
				showResult(getModel().currentAnalysisResult);
			}
		});
		singleFilterBox.getChildren().addAll(filterRemoveBtn, filterLabel);

		GUIView.this.flowPaneActiveFilters.getChildren().add(singleFilterBox);
	}

	private class DebugChangeListener implements ChangeListener<Document> {

		private final WebEngine engine;

		public DebugChangeListener(final WebEngine engine) {
			this.engine = engine;
		}

		@Override
		public void changed(final ObservableValue<? extends Document> prop, final Document oldDoc,
				final Document newDoc) {
			this.engine.executeScript(JS_SCRIPT_ENABLE_FIREBUG);
		}
	}
}
