package de.upb.pga3.panda2.client.gui;

import javafx.scene.image.Image;
import javafx.stage.Stage;

/**
 * This class supports the GUI with some very basic functions which can be
 * called from everywhere.
 *
 * @author Felix
 */
public final class GUIHelper {
	private GUIHelper() {
	}

	/**
	 * Applying the PAndA2 icon in all sizes.
	 *
	 * @param stage
	 *            Stage to apply the icon
	 */
	public static void setPandaIcon(final Stage stage) {
		stage.getIcons().add(new Image("file:data/images/logo_panda_bg_16.png", 16, 16, false, true));
		stage.getIcons().add(new Image("file:data/images/logo_panda_bg_32.png", 32, 32, false, true));
		stage.getIcons().add(new Image("file:data/images/logo_panda_bg_64.png", 64, 64, false, true));
	}

	/**
	 * Turn a html body string into a full html document.
	 *
	 * @param body
	 *            String containing the html body
	 * @return
	 */
	public static String generateHTMLDocument(final String body) {
		return "<!DOCTYPE HTML>\n<html>\n\t<head>\n\t\t<title>Analysis Result</title>\n\t</head>\n\t<body bgcolor=\"#f4f4f4\">\n"
				+ body + "\n\t</body>\n</html>";
	}
}
