package de.upb.pga3.panda2.client.core.datastructures.validation;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;

import de.upb.pga3.panda2.client.core.datastructures.ResultView;

/**
 *
 * Class for validating the input value of the ResultView enumeration from
 * JCommander perspective for command line scenario.
 *
 * @author Sriram
 *
 */
public class ResultViewConverter implements IStringConverter<ResultView> {

	/**
	 * Default Constructor.
	 */
	public ResultViewConverter() {
	}

	/**
	 * Overriden method for converting the String path to ResultView enumeration
	 * instance.
	 *
	 * @return a instance of the ResultView enumeration.
	 */
	@Override
	public ResultView convert(final String value) {

		final ResultView convertedValue = ResultView.fromString(value);
		if (convertedValue == null) {
			throw new ParameterException("Value " + value + "can not be converted to ResultView. "
					+ "Please use the available values");
		}
		return convertedValue;
	}

}
