package de.upb.pga3.panda2.client.core.datastructures.validation;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;

import de.upb.pga3.panda2.client.core.datastructures.ResultRepresentation;

/**
 *
 * Class for validating the input value of the ResultRepresentation enumeration
 * from JCommander perspective for command line scenario.
 *
 * @author Sriram
 *
 */
public class ResultRepresentationConverter implements IStringConverter<ResultRepresentation> {

	/**
	 * Default Constructor.
	 */
	public ResultRepresentationConverter() {
	}

	/**
	 * Overriden method for converting the String path to ResultRepresentation
	 * enumeration instance.
	 *
	 * @return a instance of the ResultRepresentation enumeration.
	 */
	@Override
	public ResultRepresentation convert(final String value) {

		final ResultRepresentation convertedValue = ResultRepresentation.fromString(value);
		if (convertedValue == null) {
			throw new ParameterException("Value " + value + "can not be converted to ResultRepresentation. "
					+ "Please use the available values");
		}
		return convertedValue;
	}
}
