package de.upb.pga3.panda2.client.core.datastructures.validation;

import java.io.File;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;

import de.upb.pga3.panda2.utilities.Constants;

/**
 *
 * Class for validating the file extensions from JCommander perspective for
 * command line scenario.
 *
 * @author Sriram
 *
 */
@SuppressWarnings("unused")
public class FileConverter implements IStringConverter<File> {

	/**
	 * Default Constructor
	 */
	public FileConverter() {
	}

	/**
	 * Overriden method for converting the String path to file instance.
	 *
	 * @return a instance of the File.
	 */
	@Override
	public File convert(final String value) {
		if (!value.toLowerCase().endsWith(Constants.APK_EXTENSION)) {
			throw new ParameterException(Constants.FILE_CONVERTER_MESSAGE);
		} else {
			return new File(value);
		}
	}

}
