package de.upb.pga3.panda2.client.core.datastructures;

/**
 * Class for representing the message type and the actual messages for command
 * line and GUI.
 *
 * @author Sriram
 */
public class UIMessage {

	// Variable for persisting UIMessageType enumeration value
	private UIMessageType type;

	// Variable for persisting the message content
	private String body;

	/**
	 * Constructor with parameters.
	 *
	 * @param type
	 *            The type of the message.
	 * @param body
	 *            The actual message content.
	 */
	public UIMessage(final UIMessageType type, final String body) {
		super();
		this.type = type;
		this.body = body;
	}

	/**
	 * Get the UIMessageType enumeration.
	 *
	 * @return a instance of UIMessageType enumeration.
	 */
	public UIMessageType getType() {

		return this.type;
	}

	/**
	 * Get the actual message.
	 *
	 * @return a message as String value.
	 */
	public String getBody() {
		return this.body;
	}

	/**
	 * Set the message type.
	 *
	 * @param type
	 *            the type to set
	 */
	public void setType(final UIMessageType type) {
		this.type = type;
	}

	/**
	 * Set the message body.
	 *
	 * @param body
	 *            the body to set
	 */
	public void setBody(final String body) {
		this.body = body;
	}

}
