package de.upb.pga3.panda2.client.core.datastructures;

import java.util.Arrays;
import java.util.List;

/**
 * Class for providing the command line analysis tool options as enumeration.
 *
 * @author Sriram
 *
 */
public enum ToolSpecificOption {

	// Values of the enumeration.
	ANALYSIS("ANALYZE", "ANA", "ANALYSIS", "A"), LOAD("LOAD", "L"), HELP("HELP", "H", "-HELP", "-H", "MAN", "-MAN");

	// Variable for representing the values available for the selected enum
	private List<String> toolSpecificOptions;

	/**
	 * Constructor
	 *
	 * @param String
	 */
	private ToolSpecificOption(final String... toolSpecificOption) {
		this.toolSpecificOptions = Arrays.asList(toolSpecificOption);
	}

	/**
	 * Method for getting the values of single enumeration declared in this enum
	 * class
	 *
	 * @return toolSpecificOptions, list of String which represents the enum
	 *         value
	 */
	public List<String> getValues() {
		return this.toolSpecificOptions;
	}

	/**
	 * Method for getting the instance of the ToolSpecificOptions enumeration
	 * based on the passed String value.
	 *
	 * @param code
	 * @return toolSpecificOption, if the parameter code matches the value of
	 *         the enumeration. else, null value will be returned.
	 */
	public static ToolSpecificOption fromString(final String code) {
		for (final ToolSpecificOption toolSpecificOption : ToolSpecificOption.values()) {
			if (toolSpecificOption.getValues().contains(code.toUpperCase())) {
				return toolSpecificOption;
			}
		}
		return null;
	}
}
