package de.upb.pga3.panda2.client.core.datastructures;

import java.util.Arrays;
import java.util.List;

/**
 * Enumeration for showing the result for the command line mode.
 *
 * @author Sriram
 *
 */
public enum ResultView {

	// Values of this enumeration
	TEXTUAL("T", "TEXT", "TEXTUAL"), GRAPHICAL("G", "GRAPH", "GRAPHICAL"), MESSAGE("M", "MSG", "MESSAGE");

	// Variable for representing the values available for the selected enum
	private List<String> resultViews;

	/**
	 * Constructor
	 *
	 * @param resultView
	 */
	private ResultView(final String... resultView) {
		this.resultViews = Arrays.asList(resultView);
	}

	/**
	 * Method for getting the values of single enumeration declared in this enum
	 * class
	 *
	 * @return resultViews, list of String which represents the enum value
	 */
	public List<String> getValues() {
		return this.resultViews;
	}

	/**
	 * Method for getting the instance of the ResultView enumeration based on
	 * the passed String value.
	 *
	 * @param code
	 * @return resultView, if the parameter code matches the value of the
	 *         enumeration. else, null value will be returned.
	 */
	public static ResultView fromString(final String code) {
		for (final ResultView resultView : ResultView.values()) {
			if (resultView.getValues().contains(code.toUpperCase())) {
				return resultView;
			}
		}
		return null;
	}

}
