package de.upb.pga3.panda2.client.core.datastructures;

import java.util.Arrays;
import java.util.List;

/**
 *
 * Enumeration for representing the result for the command line mode.
 *
 * @author Sriram
 *
 */
public enum ResultRepresentation {

	// Values of this enumeration
	SAVE("S", "SAVE", "SA"), VIEW("V", "VIEW", "VI");

	// Variable for representing the values available for the selected enum
	private List<String> results;

	/**
	 * Constructor
	 *
	 * @param String
	 */
	private ResultRepresentation(final String... result) {
		this.results = Arrays.asList(result);
	}

	/**
	 * Method for getting the values of single enumeration declared in this enum
	 * class
	 *
	 * @return results, list of String which represents the enum value
	 */
	public List<String> getValues() {
		return this.results;
	}

	/**
	 * Method for getting the instance of the ResultRepresentation enumeration
	 * based on the passed String value.
	 *
	 * @param code
	 * @return resultRepresentation, if the parameter code matches the value of
	 *         the enumeration. else, null value will be returned.
	 */
	public static ResultRepresentation fromString(final String code) {
		for (final ResultRepresentation resultRepresentation : ResultRepresentation.values()) {
			if (resultRepresentation.getValues().contains(code.toUpperCase())) {
				return resultRepresentation;
			}
		}
		return null;
	}
}
