package de.upb.pga3.panda2.client.core.datastructures;

import java.util.List;

import de.upb.pga3.panda2.core.datastructures.IntentFilter;

/**
 *
 * Class for representing the manifest information.
 *
 * @author Sriram, nptsy
 *
 */
public class ManifestInfo {
	/*
	 * Version Code of the application mentioned in the manifest file.
	 */
	private String versionCode;
	/*
	 * Version Name of the application mentioned in the manifest file.
	 */
	private String versionName;

	// package name which is defined with attribute [package] in element
	// <\manifest>
	private String mStrPackage;

	private List<IntentFilter> intentFilters;

	/**
	 * Constructor with parameters.
	 *
	 * @param versionCode
	 *            Application Version Code.
	 * @param versionName
	 *            Application Version Name.
	 * @param inPackage
	 *            Package name present in the manifest file.
	 */
	public ManifestInfo(final String versionCode, final String versionName, final String inPackage) {
		super();
		this.versionCode = versionCode;
		this.versionName = versionName;
		this.mStrPackage = inPackage;

	}

	/**
	 * Get the version code
	 *
	 * @return a String value of version code.
	 */
	public String getVersionCode() {
		return this.versionCode;
	}

	/**
	 * Set the version code
	 *
	 * @param versionCode
	 *            Version code of the application
	 */
	public void setVersionCode(final String versionCode) {
		this.versionCode = versionCode;
	}

	/**
	 * Get the version name
	 *
	 * @return a String value of version name
	 */
	public String getVersionName() {
		return this.versionName;
	}

	/**
	 * Set the version name
	 *
	 * @param versionName
	 *            Version name of the application
	 */
	public void setVersionName(final String versionName) {
		this.versionName = versionName;
	}

	/**
	 * set package name
	 *
	 * @param inPackage
	 *            the package name
	 */
	public void setPackage(final String inPackage) {
		this.mStrPackage = inPackage;
	}

	/**
	 * get package name which is defined with attribute [package]
	 *
	 * @return a string value of package name
	 */
	public String getPackage() {
		return this.mStrPackage;
	}

	/**
	 * get the list of IntentFilter
	 *
	 * @return list of IntentFilters
	 */
	public List<IntentFilter> getIntentFilters() {
		return this.intentFilters;
	}

	/**
	 * @param intentFilters
	 *            the intentFilters to set
	 */
	public void setIntentFilters(final List<IntentFilter> intentFilters) {
		this.intentFilters = intentFilters;
	}

}
