package de.upb.pga3.panda2.client.core;

import java.io.IOException;

import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.utilities.Constants;
import de.upb.pga3.panda2.utilities.CustomSerializer;

/**
 * Class for loading the analysis result
 *
 * @author Sriram
 *
 */
public class ResultLoader {

	/**
	 * Method for loading the previous analysis result.
	 *
	 * @param resultPath
	 *            String value which contains the absolute path of the previous
	 *            analysis result file location
	 * @return analysisResult, the instance of the {@code AnalysisResult} class.
	 */
	public static AnalysisResult loadPreviousAnalysisResult(final String resultPath) {
		AnalysisResult analysisResult = null;
		try {
			analysisResult = CustomSerializer.readObject(resultPath);
			// analysisResult = DefaultJavaSerializer.readObject(resultPath);
		} catch (final IOException i) {
			i.printStackTrace();
			return null;
		} catch (final Exception c) {
			Client.print(Constants.RESULT_CLASS_NOT_FOUND);
			c.printStackTrace();
			return null;
		}
		Client.print(Constants.DESERIALIZED_MESSAGE);
		return analysisResult;
	}
}
