package de.upb.pga3.panda2.client.core;

import java.io.File;
import java.util.List;

import de.upb.pga3.panda2.client.core.datastructures.Mode;
import de.upb.pga3.panda2.client.core.datastructures.UIMessage;
import de.upb.pga3.panda2.client.core.datastructures.UIMessageType;

/**
 * Class for configuring as well as validating the user input.
 *
 * @author Sriram
 */
public class ConfigManager {

	/**
	 * Method for validating the user input.
	 *
	 * @param userInput
	 *            Instance of the UserInput class.
	 * @return uiMessage, which returns the instance of {@code UIMessage} class.
	 */
	public static UIMessage validateInput(final UserInput userInput) {
		UIMessage uiMessage = null;
		File previousAnalysisResult = null;
		try {
			final boolean isComparisonMode = userInput.getMode().equals(Mode.COMPARISON);
			final List<File> inputAPKFiles = userInput.getInitialInputAPKFiles();
			if (!AnalysisRegistry.getInstance().getName(userInput.getLevel()).equals(AnalysisRegistry.LEVEL2B)) {
				final File apkFile = inputAPKFiles.get(0);
				if (!apkFile.exists() || apkFile.isDirectory()) {
					uiMessage = new UIMessage(UIMessageType.ERROR, "Input APK File doesn't exist");
				}
			} else {

				final List<File> nonNativeAPKFiles = userInput.getNonNativeAPKFiles();
				for (final File inputAPKFile : inputAPKFiles) {
					if (!inputAPKFile.exists() || inputAPKFile.isDirectory()) {
						uiMessage = new UIMessage(UIMessageType.ERROR, "One of the Input APK File doesn't exist");
						break;
					}

					if (uiMessage == null) {
						if (nonNativeAPKFiles != null) {
							for (final File nonNativeAPKFile : nonNativeAPKFiles) {
								if (!nonNativeAPKFile.exists() || nonNativeAPKFile.isDirectory()) {
									uiMessage = new UIMessage(UIMessageType.ERROR,
											"One of the Non Native APK File doesn't exist");
									break;
								}
							}
						}
					}
				}
			}
			if (isComparisonMode && uiMessage == null) {
				previousAnalysisResult = userInput.getPreviousAnalysisResultFile();
				if (!previousAnalysisResult.exists() || previousAnalysisResult.isDirectory()) {
					uiMessage = new UIMessage(UIMessageType.ERROR,
							"Previous Analysis APK/Result File doesn't exist for Comparison Mode");
				}
			}
			if (uiMessage == null) {
				uiMessage = new UIMessage(UIMessageType.INFO, "Provided Inputs are Valid");
			}
		} catch (final Exception ex) {
			uiMessage = new UIMessage(UIMessageType.ERROR,
					"Exception in the application configuration. Please correct your inputs.");
		}
		return uiMessage;
	}

	/**
	 * Method for configuring the analysis.
	 *
	 * @param userInput
	 */
	/*
	 * Not implemented as this method is not required now
	 *
	 * public void configureAnalysisSetting(final UserInput userInput) {
	 *
	 * }
	 */

}
