package de.upb.pga3.ate;

import java.util.ArrayList;
import java.util.List;

/**
 * TextReader
 *
 * @author Abhinav This class will format the output into comparable form, later
 *         used in PermissionChecker
 */
public class TextReader {
	List<String> getExpResults = new ArrayList<String>();
	final List<String> getExpResultsM = new ArrayList<String>();
	final List<String> getExpResultsR = new ArrayList<String>();
	final List<String> getExpResultsO = new ArrayList<String>();
	final List<String> getExpResultsU = new ArrayList<String>();
	final List<String> getExpResultsG = new ArrayList<String>();

	final List<String> getExpResultsSource = new ArrayList<String>();
	final List<String> getExpResultsSink = new ArrayList<String>();
	final List<String> getExpResultsD = new ArrayList<String>();
	final List<String> getExpResultsI = new ArrayList<String>();
	final List<String> getExpResultsDI = new ArrayList<String>();

	/**
	 * Constructor for parsing the expected result list provided by user into
	 * their respective groups.
	 *
	 * @param getExpResults
	 *            Expected results as a list of strings provided by user
	 *
	 */
	public TextReader(final List<String> getExpResults) {
		this.getExpResults = getExpResults;
		if (!(getExpResults == null)) {
			for (int i = 0; i < getExpResults.size(); i++) {
				final String rtStr = getExpResults.get(i);
				final boolean checkM = rtStr.endsWith(":M");
				final boolean checkR = rtStr.endsWith(":R");
				final boolean checkO = rtStr.endsWith(":O");
				final boolean checkU = rtStr.endsWith(":U");
				final boolean checkG = rtStr.endsWith(":G");

				final boolean checkSource = rtStr.endsWith(":A");
				final boolean checkSink = rtStr.endsWith(":B");

				final boolean checkD = rtStr.endsWith(":D");
				final boolean checkI = rtStr.endsWith(":I");
				final boolean checkDI = rtStr.endsWith(":T");
				if (checkM) {
					this.getExpResultsM.add(rtStr.substring(0, rtStr.length() - 2));
				} else if (checkR) {
					this.getExpResultsR.add(rtStr.substring(0, rtStr.length() - 2));
				} else if (checkO) {
					this.getExpResultsO.add(rtStr.substring(0, rtStr.length() - 2));
				} else if (checkU) {
					this.getExpResultsU.add(rtStr.substring(0, rtStr.length() - 2));
				} else if (checkG) {
					this.getExpResultsG.add(rtStr.substring(0, rtStr.length() - 2));
				} else if (checkSource) {
					this.getExpResultsSource.add(rtStr.substring(0, rtStr.length() - 2));
				} else if (checkSink) {
					this.getExpResultsSink.add(rtStr.substring(0, rtStr.length() - 2));
				} else if (checkD) {
					this.getExpResultsD.add(rtStr.substring(0, rtStr.length() - 2));
				} else if (checkI) {
					this.getExpResultsI.add(rtStr.substring(0, rtStr.length() - 2));
				} else if (checkDI) {
					this.getExpResultsDI.add(rtStr.substring(0, rtStr.length() - 2));
				}

			}

		}

	}

	public List<String> getterExpResultsM() {
		return this.getExpResultsM;
	}

	public List<String> getterExpResultsR() {
		return this.getExpResultsR;
	}

	public List<String> getterExpResultsO() {
		return this.getExpResultsO;
	}

	public List<String> getterExpResultsU() {
		return this.getExpResultsU;
	}

	public List<String> getterExpResultsG() {
		return this.getExpResultsG;
	}

	public List<String> getterExpResultsSource() {
		return this.getExpResultsSource;
	}

	public List<String> getterExpResultsSink() {
		return this.getExpResultsSink;
	}

	public List<String> getterExpResultsD() {
		return this.getExpResultsD;
	}

	public List<String> getterExpResultsI() {
		return this.getExpResultsI;
	}

	public List<String> getterExpResultsDI() {
		return this.getExpResultsDI;
	}
}
