package de.upb.pga3.ate;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import de.upb.pga3.panda2.client.core.ClientGUI;

/**
 *
 * This class is used to create a command line input for every test case
 *
 * @author Arjya
 */
public class TestCase {
	String level;
	boolean isComparison = false;
	boolean isAllMode = false;
	File analyzedApp;
	File result = null;
	String nonNative;
	List<String> expResult;
	String req = "app";

	ClientGUI clientGUI = new ClientGUI();

	/**
	 * Constructor for initializing parameters provided by Generator
	 * {@link Generator}.
	 *
	 *
	 */
	public TestCase(final String lvl, final boolean comp, final boolean all, final File anaApp, final File res,
			final String nn, final List<String> expResult) {
		this.level = lvl;
		this.isComparison = comp;
		this.isAllMode = all;
		this.analyzedApp = anaApp;
		if (res != null) {
			this.result = res;
		}
		if (nn == null) {
			this.nonNative = "";
		} else {
			this.nonNative = nn;
		}
		this.expResult = expResult;
	}

	/**
	 * This method returns list of expected results. {@link TestCase}.
	 *
	 * @return The created list of Expected results provided by user.
	 */
	public List<String> getExpResults() {
		return this.expResult;
	}

	/**
	 * This method generates command line arguments for every test case.
	 * {@link TestCase}.
	 *
	 * @return cmdLine This method returns command line arguments for every test
	 *         case.
	 */
	public String[] getExec() {

		final List<String> cmdString = new ArrayList<String>();

		if (this.level.equalsIgnoreCase("1") || this.level.equalsIgnoreCase("2a")) {
			if (this.result == null) {
				cmdString.add("-l");
				cmdString.add(this.level);
				cmdString.add("-i");
				cmdString.add(this.analyzedApp.getAbsolutePath());
				cmdString.add("-ts");
				cmdString.add("true");
			} else {
				cmdString.add("-l");
				cmdString.add(this.level);
				cmdString.add("-i");
				cmdString.add(this.analyzedApp.getAbsolutePath());
				cmdString.add("-ci");
				cmdString.add(this.result.getAbsolutePath());
				cmdString.add("-ts");
				cmdString.add("true");
			}

		} else {
			if (this.result != null) {

				cmdString.add("-l");
				cmdString.add(this.level);
				cmdString.add("-i");
				cmdString.add(this.analyzedApp.getAbsolutePath());
				cmdString.add("-lm");
				cmdString.add(this.isAllMode != true ? "app" : "all");
				cmdString.add("-nn");
				final String[] splitString = this.nonNative.split("-");

				for (int i = 1; i < splitString.length; i++) {

					cmdString.add(splitString[i]);
				}
				cmdString.add("-ci");
				cmdString.add(this.result.getAbsolutePath());
				cmdString.add("-ts");
				cmdString.add("true");

			} else {
				cmdString.add("-l");
				cmdString.add(this.level);
				cmdString.add("-i");
				cmdString.add(this.analyzedApp.getAbsolutePath());
				cmdString.add("-lm");
				cmdString.add(this.isAllMode != true ? "app" : "all");
				cmdString.add("-nn");

				final String[] splitString = this.nonNative.split("-");

				for (int i = 1; i < splitString.length; i++) {

					cmdString.add(splitString[i]);
				}
				cmdString.add("-ts");
				cmdString.add("true");

			}
		}

		final String[] cmdline = cmdString.toArray(new String[cmdString.size()]);

		return cmdline;

	}

	/**
	 * This method generates the absolute path for the application to be
	 * analysed.
	 *
	 * @return The absolute path of the application to be analysed.
	 */
	public String getTestName() {
		return this.analyzedApp.getAbsolutePath();
	}

}
