package de.upb.pga3.ate;

import java.io.File;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import de.upb.pga3.panda2.client.cmdline.CommandLine;
import de.upb.pga3.panda2.client.core.ClientGUI;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2b.AnalysisResultLvl2b;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

/**
 *
 * This class is used to create a GUI using JavaFX, trigger test cases threads
 * and then check for expected result
 *
 * @author Abhinav
 * @author Arjya
 */
public class AutomatedTestGUI extends Application {

	private ClientGUI clientGUI;
	private static CommandLine commandLine;
	Button jar;
	Button path;
	Button run;
	TextArea ta;
	static File jarFile;
	static File pathFile;

	TextField jarField = new TextField();
	TextField pathField = new TextField("");
	String text1 = "START ";
	int counter = 0;
	Generator gen = new Generator();
	private static final Logger LOGGER = LogManager.getLogger(AutomatedTestGUI.class);

	@Override

	/**
	 * This method generates a graphical user interface for Automated Test
	 * Executor. Technology used is JavaFx. {@link AutomatedTestGUI}.
	 *
	 *
	 */
	public void start(final Stage inStage) {

		inStage.setTitle("Automated Test Runner");

		inStage.setOnCloseRequest(new EventHandler<WindowEvent>() {
			@Override
			public void handle(final WindowEvent we) {
				we.consume();
				System.exit(0);
			}
		});

		final HBox sampleBox = new HBox();
		final HBox sampleBox2 = new HBox();
		this.jar = new Button("Select Jar");
		this.path = new Button("Select Root Path");
		this.path.setMinWidth(100);
		this.run = new Button("Run Automated Tests");
		this.jar.setPrefWidth(125);
		this.path.setPrefWidth(125);
		this.run.setPrefWidth(200);

		this.jarField.setMinWidth(400);
		this.jarField.setPrefWidth(400);
		this.jarField.setMaxWidth(400);
		this.jarField.textProperty().addListener(new ChangeListener<String>() {
			@Override
			public void changed(final ObservableValue<? extends String> observable, final String oldValue,
					final String newValue) {
				AutomatedTestGUI.this.jarField.setPrefWidth(AutomatedTestGUI.this.jarField.getText().length() * 7);
			}
		});

		this.pathField.setMinWidth(400);
		this.pathField.setPrefWidth(400);
		this.pathField.setMaxWidth(400);

		this.pathField.textProperty().addListener(new ChangeListener<String>() {
			@Override
			public void changed(final ObservableValue<? extends String> observable, final String oldValue,
					final String newValue) {
				AutomatedTestGUI.this.pathField.setPrefWidth(AutomatedTestGUI.this.pathField.getText().length() * 7);
			}
		});

		final Image image = new Image("file:data/images/right_16.png");
		final ImageView iv1 = new ImageView();
		iv1.setImage(image);
		final ImageView iv2 = new ImageView();
		iv2.setImage(image);

		final FileChooser chooserDialog1 = new FileChooser();
		final FileChooser.ExtensionFilter apkFilter1 = new FileChooser.ExtensionFilter(
				"*.jar - java executable archieve", "*.jar");
		chooserDialog1.getExtensionFilters().add(apkFilter1);

		this.jar.setOnAction(new EventHandler<ActionEvent>() {

			@Override
			public void handle(final ActionEvent event) {
				jarFile = chooserDialog1.showOpenDialog(inStage);
				AutomatedTestGUI.this.jarField.setText(jarFile.toString());
			}
		});

		final DirectoryChooser chooserDialog2 = new DirectoryChooser();

		this.path.setOnAction(new EventHandler<ActionEvent>() {

			@Override
			public void handle(final ActionEvent event) {
				pathFile = chooserDialog2.showDialog(inStage);
				AutomatedTestGUI.this.pathField.setText(pathFile.toString());
			}
		});

		this.run.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(final ActionEvent event) {

				proceed();
			}
		});

		sampleBox2.getChildren().addAll(this.path, this.pathField);
		sampleBox.setAlignment(Pos.BASELINE_CENTER);
		sampleBox.setSpacing(35);
		sampleBox2.setAlignment(Pos.BASELINE_CENTER);
		sampleBox2.setSpacing(35);

		this.ta = new TextArea();
		this.ta.setPrefHeight(500);

		final VBox displayBox = new VBox();
		displayBox.getChildren().addAll(sampleBox, sampleBox2, this.run, this.ta);
		displayBox.setAlignment(Pos.CENTER);
		displayBox.setSpacing(15);

		final Scene scene = new Scene(displayBox, 700, 700, Color.BROWN);
		inStage.setScene(scene);
		inStage.getIcons().add(new Image("file:data/images/document_16.png"));
		inStage.show();

	};

	/**
	 * This method triggers the test case generation using threads. Pass
	 * parameters to tool and then analyse the result comparing it with expected
	 * results, if any. Later it presents output to user in a text field.
	 * {@link AutomatedTestGUI}.
	 *
	 * @param testcase
	 *            for each test case, there is test case object which will be
	 *            transformed into a array list and then passed to command line.
	 *
	 * @param getExpResults
	 *            This is the expected result from the user.
	 * @return TextField presenting result.
	 */
	public void proceed() {
		new Thread(new Runnable() {

			@Override
			public void run() {

				AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);

			}
		}).start();

		this.ta.setText(this.text1);

		final Thread t = new Thread() {
			@Override
			public void run() {
				for (final TestCase testCase : AutomatedTestGUI.this.gen.generateTestCases()) {
					AutomatedTestGUI.this.counter++;

					try {

						commandLine = new CommandLine();

						if (commandLine.validateInitialInput(testCase.getExec())) {
							LOGGER.info("Command Line string validated");
						}
						commandLine.saveOrShowResult();
						final AnalysisResult analysisResult = commandLine.getClientCommandLine().getAnalysisResult();

						if (analysisResult instanceof AnalysisResultLvl1)

						{
							AutomatedTestGUI.this.text1 += "\n\nTest " + AutomatedTestGUI.this.counter
									+ "-Stored at path" + " (" + testCase.getTestName() + ")"
									+ "\nLevel 1 ran Successfully ";
							AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);

							final List<String> getExpResults = testCase.getExpResults();

							if (!getExpResults.isEmpty()) {
								final Level1Exp level1exp = new Level1Exp(getExpResults, analysisResult);
								final String level1Appender = level1exp.getterDisplayString();
								AutomatedTestGUI.this.text1 += level1Appender;
								AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);
							}

						} else if (analysisResult instanceof AnalysisResultLvl2a)

						{
							AutomatedTestGUI.this.text1 += "\n\nTest " + AutomatedTestGUI.this.counter
									+ "-Stored at path" + " (" + testCase.getTestName() + ")"
									+ "\nLevel 2a ran Successfully ";
							AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);

							final List<String> getExpResults = testCase.getExpResults();

							if (!getExpResults.isEmpty()) {

								final Level2aExp level2aexp = new Level2aExp(getExpResults, analysisResult);
								final String level2aAppender = level2aexp.getterDisplayString();
								AutomatedTestGUI.this.text1 += level2aAppender;
								AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);
							}
						} else if (analysisResult instanceof AnalysisResultLvl2b)

						{
							AutomatedTestGUI.this.text1 += "\n\nTest " + AutomatedTestGUI.this.counter
									+ "-Stored at path" + " (" + testCase.getTestName() + ")"
									+ "\nLevel 2b ran Successfully ";
							AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);

							final List<String> getExpResults = testCase.getExpResults();

							if (!getExpResults.isEmpty()) {

								final Level2bExp level2bexp = new Level2bExp(getExpResults, analysisResult);
								final String level2bAppender = level2bexp.getterDisplayString();
								AutomatedTestGUI.this.text1 += level2bAppender;
								AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);

							}

						} else {
							AutomatedTestGUI.this.text1 += "\n\nTest " + AutomatedTestGUI.this.counter
									+ "-Stored at path" + " (" + testCase.getTestName() + ")" + "\n"
									+ commandLine.getClientCommandLine().getMessages();
							AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);

						}

					} catch (final Exception e) {

						AutomatedTestGUI.this.text1 += "\n\nTest " + AutomatedTestGUI.this.counter + "-Stored at path"
								+ " (" + testCase.getTestName() + ")" + "\n" + " Test has thrown an exception:";
						AutomatedTestGUI.this.ta.setText(AutomatedTestGUI.this.text1);
						e.printStackTrace();
					}

				}
			}
		};
		t.start();
		this.ta.setText(this.text1);

	}
}
