package de.upb.pga3.panda2.demos;

import java.util.List;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import soot.Body;
import soot.PatchingChain;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;

/**
 *
 * @author Fabian
 *
 */
public class InputDemo {

	public static void main(final String[] args) {

		final EnhancedInput ei = null;

		final SootClass[] classes = ei.getAppClasses();

		final SootClass myClass = classes[0];
		final SootField f = myClass.getFieldByName("myField");
		final List<SootMethod> methods = myClass.getMethods();

		final SootMethod m = methods.get(0);
		final Body b = m.getActiveBody();
		final PatchingChain<Unit> units = b.getUnits();
		final Unit u = units.getFirst();
		u.getBoxesPointingToThis();
		u.getUseBoxes();

		ei.getPermissionsFor(myClass);
		ei.getPermissionsFor(f);
		ei.getPermissionsFor(m);
		ei.getPermissionsFor(u);

		ei.getBodyForUnit(u);

	}

}
