package de.upb.pga3.panda2.demos;

import java.util.List;

import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.core.services.DataStorage;

/**
 *
 * @author Felix
 *
 */
public class DataStorageDemo {
	public static void main(final String[] args) {
		final DataStorage dataStorage = CoreServices.getDataStorageInstance();

		// <android.widget.Chronometer: boolean performLongClick()>
		//
		// android.permission.CHANGE_WIFI_STATE,
		// android.permission.RECEIVE_BOOT_COMPLETED,
		// android.permission.SEND_SMS,
		// android.permission.ACCESS_COARSE_LOCATION,
		// android.permission.WRITE_SETTINGS,
		// android.permission.BROADCAST_STICKY,
		// android.permission.READ_PHONE_STATE

		String pkgClass = "android.widget.Chronometer";
		String method = "performLongClick()";

		System.out.println("Test1:");
		List<Permission> listPerm = dataStorage.mapAPICall(pkgClass, method);
		if (listPerm != null) {
			for (final Permission item : listPerm) {
				System.out.println(item.getName());
			}
		}

		// <android.net.wifi.IWifiManager$Stub$Proxy: android.os.Messenger
		// getWifiServiceMessenger()>
		//
		// android.permission.CHANGE_WIFI_STATE,
		// android.permission.ACCESS_WIFI_STATE

		pkgClass = "android.net.wifi.IWifiManager$Stub$Proxy";
		method = "getWifiServiceMessenger()";

		System.out.println("\nTest2:");
		listPerm = dataStorage.mapAPICall(pkgClass, method);
		if (listPerm != null) {
			for (final Permission item : listPerm) {
				System.out.println(item.getName());
			}
		}

		// android.intent.action.MAIN android.permission.BIND_PRINT_SERVICE S

		final String actionName = "android.intent.action.MAIN";

		System.out.println("\nTest3:");
		listPerm = dataStorage.mapImplicitIntent(actionName);
		if (listPerm != null) {
			for (final Permission item : listPerm) {
				System.out.println(item.getName());
			}
		}
	}

}
