/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.util.List;
import soot.Body;
import soot.PatchingChain;
import soot.Trap;
import soot.Unit;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum TrapsValidator implements BodyValidator
{
    INSTANCE;


    public static TrapsValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        PatchingChain<Unit> units = body.getUnits();
        for (Trap t : body.getTraps()) {
            if (!units.contains(t.getBeginUnit())) {
                exception.add(new ValidationException(t.getBeginUnit(), "begin not in chain in " + body.getMethod()));
            }
            if (!units.contains(t.getEndUnit())) {
                exception.add(new ValidationException(t.getEndUnit(), "end not in chain in " + body.getMethod()));
            }
            if (units.contains(t.getHandlerUnit())) continue;
            exception.add(new ValidationException(t.getHandlerUnit(), "handler not in chain in " + body.getMethod()));
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

