/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Scene;
import soot.Singletons;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.NumberedSet;

public class LocalSplitter
extends BodyTransformer {
    protected ThrowAnalysis throwAnalysis;
    protected boolean omitExceptingUnitEdges;

    public LocalSplitter(Singletons.Global g) {
    }

    public LocalSplitter(ThrowAnalysis ta) {
        this(ta, false);
    }

    public LocalSplitter(ThrowAnalysis ta, boolean omitExceptingUnitEdges) {
        this.throwAnalysis = ta;
        this.omitExceptingUnitEdges = omitExceptingUnitEdges;
    }

    public static LocalSplitter v() {
        return G.v().soot_toolkits_scalar_LocalSplitter();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Splitting locals...");
        }
        if (Options.v().time()) {
            Timers.v().splitTimer.start();
        }
        if (Options.v().time()) {
            Timers.v().splitPhase1Timer.start();
        }
        if (this.throwAnalysis == null) {
            this.throwAnalysis = Scene.v().getDefaultThrowAnalysis();
        }
        if (!this.omitExceptingUnitEdges) {
            this.omitExceptingUnitEdges = Options.v().omit_excepting_unit_edges();
        }
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(body, this.throwAnalysis, this.omitExceptingUnitEdges);
        LocalDefs defs = LocalDefs.Factory.newLocalDefs(graph, true);
        LocalUses uses = LocalUses.Factory.newLocalUses(graph, defs);
        if (Options.v().time()) {
            Timers.v().splitPhase1Timer.end();
        }
        if (Options.v().time()) {
            Timers.v().splitPhase2Timer.start();
        }
        HashSet<Unit> visited = new HashSet<Unit>();
        NumberedSet<Local> localsToSplit = new NumberedSet<Local>(Scene.v().getLocalNumberer());
        NumberedSet<Local> localsVisited = new NumberedSet<Local>(Scene.v().getLocalNumberer());
        for (Unit s : body.getUnits()) {
            Local l;
            if (s.getDefBoxes().isEmpty() || !(s.getDefBoxes().get(0).getValue() instanceof Local) || localsVisited.add(l = (Local)s.getDefBoxes().get(0).getValue())) continue;
            localsToSplit.add(l);
        }
        int w = 0;
        for (Unit s : body.getUnits()) {
            Local oldLocal;
            if (s.getDefBoxes().isEmpty()) continue;
            if (s.getDefBoxes().size() > 1) {
                throw new RuntimeException("stmt with more than 1 defbox!");
            }
            if (!(s.getDefBoxes().get(0).getValue() instanceof Local) || visited.remove(s) || !localsToSplit.contains(oldLocal = (Local)s.getDefBoxes().get(0).getValue())) continue;
            Local newLocal = (Local)oldLocal.clone();
            newLocal.setName(newLocal.getName() + '#' + ++w);
            body.getLocals().add(newLocal);
            ArrayDeque<Unit> queue = new ArrayDeque<Unit>();
            queue.addFirst(s);
            do {
                Unit head;
                if (!visited.add(head = (Unit)queue.removeFirst())) continue;
                for (UnitValueBoxPair use : uses.getUsesOf(head)) {
                    ValueBox vb = use.valueBox;
                    Value v = vb.getValue();
                    if (v == newLocal || !(v instanceof Local)) continue;
                    Local l = (Local)v;
                    queue.addAll(defs.getDefsOfAt(l, use.unit));
                    vb.setValue(newLocal);
                }
                for (ValueBox vb : head.getDefBoxes()) {
                    Value v = vb.getValue();
                    if (!(v instanceof Local)) continue;
                    vb.setValue(newLocal);
                }
            } while (!queue.isEmpty());
            visited.remove(s);
        }
        if (Options.v().time()) {
            Timers.v().splitPhase2Timer.end();
        }
        if (Options.v().time()) {
            Timers.v().splitTimer.end();
        }
    }
}

