/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.exceptions.PedanticThrowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.LiveLocals;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.StringGroupPair;
import soot.util.ArraySet;

public class FastColorer {
    public static void unsplitAssignColorsToLocals(Body unitBody, Map<Local, Object> localToGroup, Map<Local, Integer> localToColor, Map<Object, Integer> groupToColorCount) {
        ExceptionalUnitGraph unitGraph = new ExceptionalUnitGraph(unitBody, PedanticThrowAnalysis.v(), Options.v().omit_excepting_unit_edges());
        SimpleLiveLocals liveLocals = new SimpleLiveLocals(unitGraph);
        UnitInterferenceGraph intGraph = new UnitInterferenceGraph(unitBody, localToGroup, liveLocals, unitGraph);
        HashMap<Local, String> localToOriginalName = new HashMap<Local, String>();
        for (Local local : intGraph.getLocals()) {
            int signIndex = local.getName().indexOf("#");
            if (signIndex != -1) {
                localToOriginalName.put(local, local.getName().substring(0, signIndex));
                continue;
            }
            localToOriginalName.put(local, local.getName());
        }
        HashMap originalNameAndGroupToColors = new HashMap();
        int[] freeColors = new int[10];
        for (Local local : intGraph.getLocals()) {
            String originalName;
            ArrayList<Integer> originalNameColors;
            if (localToColor.containsKey(local)) continue;
            Object group = localToGroup.get(local);
            int colorCount = groupToColorCount.get(group);
            if (freeColors.length < colorCount) {
                freeColors = new int[Math.max(freeColors.length * 2, colorCount)];
            }
            for (int i = 0; i < colorCount; ++i) {
                freeColors[i] = 1;
            }
            Local[] interferences = intGraph.getInterferencesOf(local);
            if (interferences != null) {
                for (Local element : interferences) {
                    if (!localToColor.containsKey(element)) continue;
                    int usedColor = localToColor.get(element);
                    freeColors[usedColor] = 0;
                }
            }
            if ((originalNameColors = (ArrayList<Integer>)originalNameAndGroupToColors.get(new StringGroupPair(originalName = (String)localToOriginalName.get(local), group))) == null) {
                originalNameColors = new ArrayList<Integer>();
                originalNameAndGroupToColors.put(new StringGroupPair(originalName, group), originalNameColors);
            }
            boolean found = false;
            int assignedColor = 0;
            for (Integer color : originalNameColors) {
                if (freeColors[color] != 1) continue;
                found = true;
                assignedColor = color;
            }
            if (!found) {
                assignedColor = colorCount++;
                groupToColorCount.put(group, new Integer(colorCount));
                originalNameColors.add(new Integer(assignedColor));
            }
            localToColor.put(local, new Integer(assignedColor));
        }
    }

    public static void assignColorsToLocals(Body unitBody, Map<Local, Object> localToGroup, Map<Local, Integer> localToColor, Map<Object, Integer> groupToColorCount) {
        ExceptionalUnitGraph unitGraph = new ExceptionalUnitGraph(unitBody, PedanticThrowAnalysis.v(), Options.v().omit_excepting_unit_edges());
        SimpleLiveLocals liveLocals = new SimpleLiveLocals(unitGraph);
        final UnitInterferenceGraph intGraph = new UnitInterferenceGraph(unitBody, localToGroup, liveLocals, unitGraph);
        ArrayList<Local> sortedLocals = new ArrayList<Local>(intGraph.getLocals());
        Collections.sort(sortedLocals, new Comparator<Local>(){

            @Override
            public int compare(Local o1, Local o2) {
                int interferences1 = intGraph.getInterferenceCount(o1);
                int interferences2 = intGraph.getInterferenceCount(o2);
                return interferences2 - interferences1;
            }
        });
        for (Local local : sortedLocals) {
            if (localToColor.containsKey(local)) continue;
            Object group = localToGroup.get(local);
            int colorCount = groupToColorCount.get(group);
            BitSet blockedColors = new BitSet(colorCount);
            Local[] interferences = intGraph.getInterferencesOf(local);
            if (interferences != null) {
                for (Local element : interferences) {
                    if (!localToColor.containsKey(element)) continue;
                    int usedColor = localToColor.get(element);
                    blockedColors.set(usedColor);
                }
            }
            int assignedColor = -1;
            for (int i = 0; i < colorCount; ++i) {
                if (blockedColors.get(i)) continue;
                assignedColor = i;
                break;
            }
            if (assignedColor < 0) {
                assignedColor = colorCount++;
                groupToColorCount.put(group, new Integer(colorCount));
            }
            localToColor.put(local, new Integer(assignedColor));
        }
    }

    private static class UnitInterferenceGraph {
        Map<Local, Set<Local>> localToLocals;
        List<Local> locals = new ArrayList<Local>();

        public List<Local> getLocals() {
            return this.locals;
        }

        public UnitInterferenceGraph(Body body, Map<Local, Object> localToGroup, LiveLocals liveLocals, ExceptionalUnitGraph unitGraph) {
            this.locals.addAll(body.getLocals());
            this.localToLocals = new HashMap<Local, Set<Local>>(body.getLocalCount() * 2 + 1, 0.7f);
            for (Unit unit : body.getUnits()) {
                List<ValueBox> defBoxes = unit.getDefBoxes();
                if (defBoxes.isEmpty()) continue;
                if (defBoxes.size() != 1) {
                    throw new RuntimeException("invalid number of def boxes");
                }
                HashSet<Local> liveLocalsAtUnit = new HashSet<Local>();
                for (Unit succ : unitGraph.getUnexceptionalSuccsOf(unit)) {
                    List<Local> beforeSucc = liveLocals.getLiveLocalsBefore(succ);
                    liveLocalsAtUnit.addAll(beforeSucc);
                }
                Value defValue = defBoxes.get(0).getValue();
                if (!(defValue instanceof Local)) continue;
                Local defLocal = (Local)defValue;
                for (Local otherLocal : liveLocalsAtUnit) {
                    if (!localToGroup.get(otherLocal).equals(localToGroup.get(defLocal))) continue;
                    this.setInterference(defLocal, otherLocal);
                }
            }
        }

        public void setInterference(Local l1, Local l2) {
            Set<Local> locals = this.localToLocals.get(l1);
            if (locals == null) {
                locals = new ArraySet<Local>();
                this.localToLocals.put(l1, locals);
            }
            locals.add(l2);
            locals = this.localToLocals.get(l2);
            if (locals == null) {
                locals = new ArraySet<Local>();
                this.localToLocals.put(l2, locals);
            }
            locals.add(l1);
        }

        int getInterferenceCount(Local l) {
            Set<Local> localSet = this.localToLocals.get(l);
            return localSet == null ? 0 : localSet.size();
        }

        Local[] getInterferencesOf(Local l) {
            Set<Local> localSet = this.localToLocals.get(l);
            if (localSet == null) {
                return null;
            }
            return localSet.toArray(new Local[localSet.size()]);
        }
    }
}

