/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import soot.G;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.DoubleConstant;
import soot.jimple.FieldRef;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.StaticFieldRef;
import soot.jimple.StringConstant;
import soot.tagkit.ConstantValueTag;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.Tag;

public class ConstantInitializerToTagTransformer
extends SceneTransformer {
    public static ConstantInitializerToTagTransformer v() {
        return new ConstantInitializerToTagTransformer();
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        for (SootClass sc : Scene.v().getClasses()) {
            this.transformClass(sc, false);
        }
    }

    public void transformClass(SootClass sc, boolean removeAssignments) {
        AssignStmt assign;
        Unit u;
        SootMethod smInit = sc.getMethodByNameUnsafe("<clinit>");
        if (smInit == null) {
            return;
        }
        HashSet<SootField> nonConstantFields = new HashSet<SootField>();
        HashMap<SootField, ConstantValueTag> newTags = new HashMap<SootField, ConstantValueTag>();
        HashSet<SootField> removeTagList = new HashSet<SootField>();
        Iterator<Unit> itU = smInit.getActiveBody().getUnits().snapshotIterator();
        while (itU.hasNext()) {
            u = itU.next();
            if (!(u instanceof AssignStmt)) continue;
            assign = (AssignStmt)u;
            if (assign.getLeftOp() instanceof StaticFieldRef && assign.getRightOp() instanceof Constant) {
                SootField field = ((StaticFieldRef)assign.getLeftOp()).getField();
                if (nonConstantFields.contains(field) || !field.getDeclaringClass().equals(sc) || !field.isStatic() || !field.isFinal()) continue;
                boolean found = false;
                for (Tag t : field.getTags()) {
                    if (!(t instanceof ConstantValueTag)) continue;
                    if (this.checkConstantValue((ConstantValueTag)t, (Constant)assign.getRightOp())) {
                        if (removeAssignments) {
                            itU.remove();
                        }
                    } else {
                        G.v().out.println("WARNING: Constant value for field '" + field + "' mismatch between code (" + (Constant)assign.getRightOp() + ") and constant table (" + t + ")");
                        removeTagList.add(field);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                if (!this.checkConstantValue((ConstantValueTag)newTags.get(field), (Constant)assign.getRightOp())) {
                    nonConstantFields.add(field);
                    newTags.remove(field);
                    removeTagList.add(field);
                    continue;
                }
                ConstantValueTag newTag = this.createConstantTagFromValue((Constant)assign.getRightOp());
                if (newTag == null) continue;
                newTags.put(field, newTag);
                continue;
            }
            if (!(assign.getLeftOp() instanceof StaticFieldRef)) continue;
            SootField sf = ((StaticFieldRef)assign.getLeftOp()).getField();
            removeTagList.add(sf);
        }
        for (Map.Entry entry : newTags.entrySet()) {
            SootField field = (SootField)entry.getKey();
            if (removeTagList.contains(field)) continue;
            field.addTag((Tag)entry.getValue());
        }
        if (removeAssignments && !newTags.isEmpty()) {
            itU = smInit.getActiveBody().getUnits().snapshotIterator();
            while (itU.hasNext()) {
                u = itU.next();
                if (!(u instanceof AssignStmt) || !((assign = (AssignStmt)u).getLeftOp() instanceof FieldRef) || !newTags.containsKey(((FieldRef)assign.getLeftOp()).getField())) continue;
                itU.remove();
            }
        }
        for (SootField sf : removeTagList) {
            if (!removeTagList.contains(sf)) continue;
            ArrayList<Tag> toRemoveTagList = new ArrayList<Tag>();
            for (Tag t : sf.getTags()) {
                if (!(t instanceof ConstantValueTag)) continue;
                toRemoveTagList.add(t);
            }
            for (Tag t : toRemoveTagList) {
                sf.getTags().remove(t);
            }
        }
    }

    private ConstantValueTag createConstantTagFromValue(Constant rightOp) {
        if (rightOp instanceof DoubleConstant) {
            return new DoubleConstantValueTag(((DoubleConstant)rightOp).value);
        }
        if (rightOp instanceof FloatConstant) {
            return new FloatConstantValueTag(((FloatConstant)rightOp).value);
        }
        if (rightOp instanceof IntConstant) {
            return new IntegerConstantValueTag(((IntConstant)rightOp).value);
        }
        if (rightOp instanceof LongConstant) {
            return new LongConstantValueTag(((LongConstant)rightOp).value);
        }
        if (rightOp instanceof StringConstant) {
            return new StringConstantValueTag(((StringConstant)rightOp).value);
        }
        return null;
    }

    private boolean checkConstantValue(ConstantValueTag t, Constant rightOp) {
        if (t == null || rightOp == null) {
            return true;
        }
        if (t instanceof DoubleConstantValueTag) {
            if (!(rightOp instanceof DoubleConstant)) {
                return false;
            }
            return ((DoubleConstantValueTag)t).getDoubleValue() == ((DoubleConstant)rightOp).value;
        }
        if (t instanceof FloatConstantValueTag) {
            if (!(rightOp instanceof FloatConstant)) {
                return false;
            }
            return ((FloatConstantValueTag)t).getFloatValue() == ((FloatConstant)rightOp).value;
        }
        if (t instanceof IntegerConstantValueTag) {
            if (!(rightOp instanceof IntConstant)) {
                return false;
            }
            return ((IntegerConstantValueTag)t).getIntValue() == ((IntConstant)rightOp).value;
        }
        if (t instanceof LongConstantValueTag) {
            if (!(rightOp instanceof LongConstant)) {
                return false;
            }
            return ((LongConstantValueTag)t).getLongValue() == ((LongConstant)rightOp).value;
        }
        if (t instanceof StringConstantValueTag) {
            if (!(rightOp instanceof StringConstant)) {
                return false;
            }
            return ((StringConstantValueTag)t).getStringValue().equals(((StringConstant)rightOp).value);
        }
        return true;
    }
}

