/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.validation;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import soot.Body;
import soot.Local;
import soot.RefType;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.internal.JInvokeStmt;
import soot.jimple.internal.JNewExpr;
import soot.jimple.internal.JSpecialInvokeExpr;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum NewValidator implements BodyValidator
{
    INSTANCE;


    public static NewValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        BriefUnitGraph g = new BriefUnitGraph(body);
        for (Unit u : body.getUnits()) {
            AssignStmt assign;
            Stmt s;
            if (!(u instanceof Stmt) || !((s = (Stmt)u) instanceof AssignStmt) || !((assign = (AssignStmt)s).getRightOp() instanceof JNewExpr)) continue;
            if (!(assign.getLeftOp().getType() instanceof RefType)) {
                exception.add(new ValidationException(u, "A new-expression must be used on reference type locals", "Body of method " + body.getMethod().getSignature() + " contains a new-expression, which is assigned to a non-reference local"));
                return;
            }
            LinkedHashSet<Local> locals = new LinkedHashSet<Local>();
            locals.add((Local)assign.getLeftOp());
            this.checkForInitializerOnPath(g, assign, assign, locals, new HashSet<Unit>(), exception);
        }
    }

    private boolean checkForInitializerOnPath(UnitGraph g, Unit start, Unit currentUnit, LinkedHashSet<Local> aliasingLocals, HashSet<Unit> seen, List<ValidationException> exception) {
        boolean hasSeen;
        String errorMsg = "There is a path to " + currentUnit + " where <init> does not get called in between.";
        boolean bl = hasSeen = !seen.add(currentUnit);
        if (hasSeen) {
            return true;
        }
        boolean creatingAlias = false;
        Unit check = currentUnit;
        if (check instanceof Stmt && currentUnit != start) {
            InvokeExpr expr;
            if (check instanceof AssignStmt) {
                Local originalLocal;
                AssignStmt assignCheck = (AssignStmt)check;
                if (aliasingLocals.contains(assignCheck.getRightOp()) && assignCheck.getLeftOp() instanceof Local) {
                    aliasingLocals = (LinkedHashSet)aliasingLocals.clone();
                    aliasingLocals.add((Local)assignCheck.getLeftOp());
                    creatingAlias = true;
                }
                if ((originalLocal = (Local)aliasingLocals.iterator().next()).equals(assignCheck.getLeftOp())) {
                    return true;
                }
                aliasingLocals.remove(assignCheck.getLeftOp());
            }
            if (((Stmt)check).containsInvokeExpr() && (expr = ((Stmt)check).getInvokeExpr()).getMethod().isConstructor()) {
                if (!(expr instanceof JSpecialInvokeExpr)) {
                    exception.add(new ValidationException(check, "<init> method calls may only be used with specialinvoke."));
                    return true;
                }
                if (!(check instanceof JInvokeStmt)) {
                    exception.add(new ValidationException(check, "<init> methods may only be called with invoke statements."));
                    return true;
                }
                JSpecialInvokeExpr invoke = (JSpecialInvokeExpr)expr;
                if (aliasingLocals.contains(invoke.getBase())) {
                    return true;
                }
            }
        }
        if (!creatingAlias) {
            for (ValueBox box : currentUnit.getUseBoxes()) {
                Value used = box.getValue();
                if (!aliasingLocals.contains(used)) continue;
                exception.add(new ValidationException(start, errorMsg));
                return false;
            }
        }
        List<Unit> successors = g.getSuccsOf(currentUnit);
        for (Unit succ : successors) {
            if (this.checkForInitializerOnPath(g, start, succ, aliasingLocals, (HashSet)seen.clone(), exception)) continue;
            return false;
        }
        if (successors.isEmpty()) {
            exception.add(new ValidationException(start, errorMsg));
            return false;
        }
        return true;
    }

    @Override
    public boolean isBasicValidator() {
        return false;
    }
}

