/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import java.util.Iterator;
import java.util.Set;
import soot.Body;
import soot.Hierarchy;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Trap;
import soot.TrapManager;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.util.Chain;

public class ThrowManager {
    public static Stmt getNullPointerExceptionThrower(JimpleBody b) {
        PatchingChain<Unit> units = b.getUnits();
        Set<Unit> trappedUnits = TrapManager.getTrappedUnitsOf(b);
        Stmt s = (Stmt)units.getLast();
        while (s != units.getFirst()) {
            Value throwee;
            if (!trappedUnits.contains(s) && s instanceof ThrowStmt && !((throwee = ((ThrowStmt)s).getOp()) instanceof Constant)) {
                if (s == units.getFirst()) break;
                Stmt prosInvoke = (Stmt)units.getPredOf(s);
                if (prosInvoke instanceof InvokeStmt) {
                    InvokeExpr ie;
                    if (prosInvoke == units.getFirst()) break;
                    Stmt prosNew = (Stmt)units.getPredOf(prosInvoke);
                    if (prosNew instanceof AssignStmt && (ie = ((InvokeStmt)prosInvoke).getInvokeExpr()) instanceof SpecialInvokeExpr && ((SpecialInvokeExpr)ie).getBase() == throwee && ie.getMethodRef().name().equals("<init>")) {
                        RefType newType;
                        Value lo = ((AssignStmt)prosNew).getLeftOp();
                        Value ro = ((AssignStmt)prosNew).getRightOp();
                        if (lo == throwee && ro instanceof NewExpr && ((Object)(newType = ((NewExpr)ro).getBaseType())).equals(RefType.v("java.lang.NullPointerException"))) {
                            return prosNew;
                        }
                    }
                }
            }
            s = (Stmt)units.getPredOf(s);
        }
        Stmt last = (Stmt)units.getLast();
        return ThrowManager.addThrowAfter(b, last);
    }

    static Stmt addThrowAfter(JimpleBody b, Stmt target) {
        PatchingChain<Unit> units = b.getUnits();
        Chain<Local> locals = b.getLocals();
        int i = 0;
        boolean canAddI = false;
        do {
            canAddI = true;
            for (Local l : locals) {
                if (!l.getName().equals("__throwee" + i)) continue;
                canAddI = false;
            }
            if (canAddI) continue;
            ++i;
        } while (!canAddI);
        Local l = Jimple.v().newLocal("__throwee" + i, RefType.v("java.lang.NullPointerException"));
        b.getLocals().add(l);
        AssignStmt newStmt = Jimple.v().newAssignStmt(l, Jimple.v().newNewExpr(RefType.v("java.lang.NullPointerException")));
        InvokeStmt invStmt = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(l, Scene.v().getMethod("<java.lang.NullPointerException: void <init>()>").makeRef()));
        ThrowStmt throwStmt = Jimple.v().newThrowStmt(l);
        units.insertAfter(newStmt, (Unit)target);
        units.insertAfter(invStmt, (Unit)newStmt);
        units.insertAfter(throwStmt, (Unit)invStmt);
        return newStmt;
    }

    static boolean isExceptionCaughtAt(SootClass e, Stmt stmt, Body b) {
        Hierarchy h = new Hierarchy();
        for (Trap t : b.getTraps()) {
            if (!h.isClassSubclassOfIncluding(e, t.getException())) continue;
            Iterator<Unit> it = b.getUnits().iterator(t.getBeginUnit(), t.getEndUnit());
            while (it.hasNext()) {
                if (!stmt.equals(it.next())) continue;
                return true;
            }
        }
        return false;
    }
}

