/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.ArrayType;
import soot.Body;
import soot.FastHierarchy;
import soot.G;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;
import soot.jimple.Ref;

public class ClassRenamer
extends SceneTransformer
implements IJbcoTransform {
    public static String[] dependancies = new String[]{"wjtp.jbco_cr"};
    public static String name = "wjtp.jbco_cr";
    private static final char[][] stringChars = new char[][]{{'S', '5', '$'}, {'l', '1', 'I'}, {'_'}};
    public static HashMap<String, String> oldToNewClassNames = new HashMap();
    public static HashMap<String, SootClass> newNameToClass = new HashMap();

    @Override
    public void outputSummary() {
    }

    @Override
    public String[] getDependancies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        if (output) {
            G.v().out.println("Transforming Class Names...");
        }
        BodyBuilder.retrieveAllBodies();
        BodyBuilder.retrieveAllNames();
        Scene scene = G.v().soot_Scene();
        for (SootClass c : scene.getApplicationClasses()) {
            if (scene.getMainClass() == c || oldToNewClassNames.containsValue(c.getName()) || Main.getWeight(phaseName, c.getName()) == 0) continue;
            String oldName = c.getName();
            String newName = oldToNewClassNames.get(oldName);
            if (newName == null) {
                newName = ClassRenamer.getNewName(ClassRenamer.getNamePrefix(oldName));
                oldToNewClassNames.put(oldName, newName);
            }
            c.setName(newName);
            RefType crt = RefType.v(newName);
            crt.setSootClass(c);
            c.setRefType(crt);
            c.setResolvingLevel(3);
            newNameToClass.put(newName, c);
            if (!output) continue;
            out.println("\tRenaming " + oldName + " to " + newName);
        }
        scene.releaseActiveHierarchy();
        scene.getActiveHierarchy();
        scene.setFastHierarchy(new FastHierarchy());
        if (output) {
            out.println("\r\tUpdating bytecode class references");
        }
        for (SootClass c : scene.getApplicationClasses()) {
            for (SootMethod m : c.getMethods()) {
                if (!m.isConcrete()) continue;
                if (output) {
                    out.println("\t\t" + m.getSignature());
                }
                Body aBody = null;
                try {
                    aBody = m.getActiveBody();
                }
                catch (Exception exc) {
                    continue;
                }
                for (Unit u : aBody.getUnits()) {
                    Iterator<ValueBox> udbIt = u.getUseAndDefBoxes().iterator();
                    while (udbIt.hasNext()) {
                        RefType rt;
                        Value v = udbIt.next().getValue();
                        if (!(v instanceof Ref)) continue;
                        if (v.getType() instanceof RefType) {
                            RefType rt2 = (RefType)v.getType();
                            if (rt2.getSootClass().isLibraryClass() || !oldToNewClassNames.containsKey(rt2.getClassName())) continue;
                            rt2.setSootClass(newNameToClass.get(oldToNewClassNames.get(rt2.getClassName())));
                            rt2.setClassName(oldToNewClassNames.get(rt2.getClassName()));
                            continue;
                        }
                        if (!(v.getType() instanceof ArrayType)) continue;
                        ArrayType at = (ArrayType)v.getType();
                        if (!(at.baseType instanceof RefType) || (rt = (RefType)at.baseType).getSootClass().isLibraryClass() || !oldToNewClassNames.containsKey(rt.getClassName())) continue;
                        rt.setSootClass(newNameToClass.get(oldToNewClassNames.get(rt.getClassName())));
                    }
                }
            }
        }
        scene.releaseActiveHierarchy();
        scene.getActiveHierarchy();
        scene.setFastHierarchy(new FastHierarchy());
    }

    public static String getNewName(String prefix) {
        int size = 5;
        int tries = 0;
        int index = Rand.getInt(stringChars.length);
        int length = stringChars[index].length;
        String result = null;
        char[] cNewName = new char[size];
        do {
            if (tries == size) {
                cNewName = new char[++size];
                tries = 0;
            }
            do {
                cNewName[0] = stringChars[index][Rand.getInt(length)];
            } while (!Character.isJavaIdentifierStart(cNewName[0]));
            for (int i = 1; i < cNewName.length; ++i) {
                int rand = Rand.getInt(length);
                cNewName[i] = stringChars[index][rand];
            }
            result = prefix + String.copyValueOf(cNewName);
            ++tries;
        } while (oldToNewClassNames.containsValue(result) || BodyBuilder.nameList.contains(result));
        BodyBuilder.nameList.add(result);
        return result;
    }

    public static String getNamePrefix(String fullName) {
        int idx = fullName.lastIndexOf(46);
        if (idx >= 0) {
            return fullName.substring(0, idx + 1);
        }
        return "";
    }
}

