/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.immutable.reference.ImmutableTypeReference;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.RefType;
import soot.ShortType;
import soot.Type;
import soot.UnknownType;
import soot.VoidType;
import soot.dexpler.Util;

public class DexType {
    protected String name;
    protected TypeReference type;

    public DexType(TypeReference type) {
        if (type == null) {
            throw new RuntimeException("error: type ref is null!");
        }
        this.type = type;
        this.name = type.getType();
    }

    public DexType(String type) {
        if (type == null) {
            throw new RuntimeException("error: type is null!");
        }
        this.type = new ImmutableTypeReference(type);
        this.name = type;
    }

    public String getName() {
        return this.name;
    }

    public boolean overwriteEquivalent(DexType field) {
        return this.name.equals(field.getName());
    }

    public TypeReference getType() {
        return this.type;
    }

    public Type toSoot() {
        return DexType.toSoot(this.type.getType(), 0);
    }

    public static Type toSoot(TypeReference type) {
        return DexType.toSoot(type.getType(), 0);
    }

    public static Type toSoot(String type) {
        return DexType.toSoot(type, 0);
    }

    public static boolean isWide(TypeReference typeReference) {
        String t = typeReference.getType();
        return DexType.isWide(t);
    }

    public static boolean isWide(String type) {
        return type.startsWith("J") || type.startsWith("D");
    }

    private static Type toSoot(String typeDescriptor, int pos) {
        Type type;
        char typeDesignator = typeDescriptor.charAt(pos);
        switch (typeDesignator) {
            case 'Z': {
                type = BooleanType.v();
                break;
            }
            case 'B': {
                type = ByteType.v();
                break;
            }
            case 'S': {
                type = ShortType.v();
                break;
            }
            case 'C': {
                type = CharType.v();
                break;
            }
            case 'I': {
                type = IntType.v();
                break;
            }
            case 'J': {
                type = LongType.v();
                break;
            }
            case 'F': {
                type = FloatType.v();
                break;
            }
            case 'D': {
                type = DoubleType.v();
                break;
            }
            case 'L': {
                type = RefType.v(Util.dottedClassName(typeDescriptor));
                break;
            }
            case 'V': {
                type = VoidType.v();
                break;
            }
            case '[': {
                type = DexType.toSoot(typeDescriptor, pos + 1).makeArrayType();
                break;
            }
            default: {
                type = UnknownType.v();
            }
        }
        return type;
    }

    public static String toSootICAT(String type) {
        String[] split1;
        String r = "";
        for (String s : split1 = type.split(";")) {
            if (s.startsWith("L")) {
                s = s.replaceFirst("L", "");
            }
            if (s.startsWith("<L")) {
                s = s.replaceFirst("<L", "<");
            }
            r = r + s;
        }
        return r;
    }

    public static String toDalvikICAT(String type) {
        type = type.replaceAll("<", "<L");
        type = type.replaceAll(">", ">;");
        type = "L" + type;
        if (!(type = type.replaceAll("L\\*;", "*")).endsWith(";")) {
            type = type + ";";
        }
        return type;
    }

    public static String toSootAT(String type) {
        return type;
    }

    public String toString() {
        return this.name;
    }
}

