/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.dexpler.DalvikThrowAnalysis;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.ReturnStmt;
import soot.jimple.toolkits.scalar.LocalCreation;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;

public class DexReturnValuePropagator
extends BodyTransformer {
    public static DexReturnValuePropagator v() {
        return new DexReturnValuePropagator();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(body, DalvikThrowAnalysis.v(), true);
        LocalDefs localDefs = LocalDefs.Factory.newLocalDefs(graph);
        LocalUses localUses = null;
        LocalCreation localCreation = null;
        for (Unit u : body.getUnits()) {
            List<Unit> defs;
            ReturnStmt retStmt;
            if (!(u instanceof ReturnStmt) || !((retStmt = (ReturnStmt)u).getOp() instanceof Local) || (defs = localDefs.getDefsOfAt((Local)retStmt.getOp(), retStmt)).size() != 1 || !(defs.get(0) instanceof AssignStmt)) continue;
            AssignStmt assign = (AssignStmt)defs.get(0);
            Value rightOp = assign.getRightOp();
            Value leftOp = assign.getLeftOp();
            if (rightOp instanceof Local) {
                if (this.isRedefined((Local)rightOp, u, assign, graph)) continue;
                retStmt.setOp(rightOp);
                continue;
            }
            if (rightOp instanceof Constant) {
                retStmt.setOp(rightOp);
                continue;
            }
            if (!(rightOp instanceof FieldRef)) continue;
            if (localUses == null) {
                localUses = LocalUses.Factory.newLocalUses(body, localDefs);
            }
            if (localUses.getUsesOf(assign).size() != 1) continue;
            if (localCreation == null) {
                localCreation = new LocalCreation(body.getLocals(), "ret");
            }
            Local newLocal = localCreation.newLocal(leftOp.getType());
            assign.setLeftOp(newLocal);
            retStmt.setOp(newLocal);
        }
    }

    private boolean isRedefined(Local l, Unit unitUse, AssignStmt unitDef, UnitGraph graph) {
        ArrayList<Unit> workList = new ArrayList<Unit>();
        workList.add(unitUse);
        HashSet<Unit> doneSet = new HashSet<Unit>();
        while (!workList.isEmpty()) {
            Unit curStmt = (Unit)workList.remove(0);
            if (!doneSet.add(curStmt)) continue;
            for (Unit u : graph.getPredsOf(curStmt)) {
                DefinitionStmt defStmt;
                if (u == unitDef) continue;
                if (u instanceof DefinitionStmt && (defStmt = (DefinitionStmt)u).getLeftOp() == l) {
                    return true;
                }
                workList.add(u);
            }
        }
        return false;
    }
}

