/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.structuredAnalysis;

import java.util.HashMap;
import soot.dava.DecompilationException;
import soot.dava.toolkits.base.AST.structuredAnalysis.CPTuple;
import soot.dava.toolkits.base.AST.structuredAnalysis.CPVariable;
import soot.dava.toolkits.base.AST.structuredAnalysis.DavaFlowSet;
import soot.toolkits.scalar.FlowSet;

public class CPFlowSet
extends DavaFlowSet<CPTuple> {
    public CPFlowSet() {
    }

    public CPFlowSet(CPFlowSet other) {
        this.numElements = other.numElements;
        this.maxElements = other.maxElements;
        this.elements = new CPTuple[((CPTuple[])other.elements).length];
        for (int i = 0; i < ((CPTuple[])other.elements).length; ++i) {
            ((CPTuple[])this.elements)[i] = ((CPTuple[])other.elements)[i] != null ? ((CPTuple[])other.elements)[i].clone() : null;
        }
        this.breakList = (HashMap)other.breakList.clone();
        this.continueList = (HashMap)other.continueList.clone();
        this.implicitBreaks = (HashMap)other.implicitBreaks.clone();
        this.implicitContinues = (HashMap)other.implicitContinues.clone();
    }

    public Object contains(String className, String localOrField) {
        for (int i = 0; i < this.numElements; ++i) {
            CPTuple current = ((CPTuple[])this.elements)[i];
            if (!current.getSootClassName().equals(className)) continue;
            if (current.containsField()) {
                if (!current.getVariable().getSootField().getName().equals(localOrField)) continue;
                return current.getValue();
            }
            if (!current.containsLocal() || !current.getVariable().getLocal().getName().equals(localOrField)) continue;
            return current.getValue();
        }
        return null;
    }

    public void addIfNotPresent(CPTuple newTuple) {
        for (int i = 0; i < this.numElements; ++i) {
            CPVariable newTupleVar;
            CPVariable curVar;
            CPTuple current = ((CPTuple[])this.elements)[i];
            if (!current.getSootClassName().equals(newTuple.getSootClassName()) || !(curVar = current.getVariable()).equals(newTupleVar = newTuple.getVariable())) continue;
            current.setValue(newTuple.getValue());
            return;
        }
        this.add(newTuple);
    }

    public void addIfNotPresentButDontUpdate(CPTuple newTuple) {
        for (int i = 0; i < this.numElements; ++i) {
            CPVariable newTupleVar;
            CPVariable curVar;
            CPTuple current = ((CPTuple[])this.elements)[i];
            if (!current.getSootClassName().equals(newTuple.getSootClassName()) || !(curVar = current.getVariable()).equals(newTupleVar = newTuple.getVariable())) continue;
            if (current.isTop()) {
                current.setValue(newTuple.getValue());
            }
            return;
        }
    }

    @Override
    public void intersection(FlowSet otherFlow, FlowSet destFlow) {
        int i;
        CPFlowSet workingSet;
        if (!(otherFlow instanceof CPFlowSet) || !(destFlow instanceof CPFlowSet)) {
            super.intersection(otherFlow, destFlow);
            return;
        }
        CPFlowSet dest = (CPFlowSet)destFlow;
        CPFlowSet other = (CPFlowSet)otherFlow;
        if (dest == other || dest == this) {
            workingSet = new CPFlowSet();
        } else {
            workingSet = dest;
            workingSet.clear();
        }
        for (i = 0; i < this.numElements; ++i) {
            CPTuple thisTuple = ((CPTuple[])this.elements)[i];
            String className = thisTuple.getSootClassName();
            CPVariable thisVar = thisTuple.getVariable();
            CPTuple matchFound = null;
            CPTuple otherTuple = null;
            for (int j = 0; j < other.numElements; ++j) {
                otherTuple = ((CPTuple[])other.elements)[j];
                String tempClass = otherTuple.getSootClassName();
                if (!tempClass.equals(className) || !otherTuple.getVariable().equals(thisVar)) continue;
                matchFound = otherTuple;
                break;
            }
            if (matchFound != null) {
                if (thisTuple.isTop()) {
                    workingSet.add(thisTuple.clone());
                    continue;
                }
                if (matchFound.isTop()) {
                    workingSet.add(matchFound.clone());
                    continue;
                }
                if (!matchFound.isTop() && !thisTuple.isTop()) {
                    Object thisValue;
                    Object matchedValue = matchFound.getValue();
                    if (matchedValue.equals(thisValue = thisTuple.getValue())) {
                        workingSet.add(thisTuple.clone());
                        continue;
                    }
                    workingSet.add(new CPTuple(className, thisVar, true));
                    continue;
                }
                throw new DecompilationException("Ran out of cases in CPVariable values...report bug to developer");
            }
            workingSet.add(thisTuple.clone());
        }
        for (i = 0; i < other.numElements; ++i) {
            CPTuple otherTuple = ((CPTuple[])other.elements)[i];
            String otherClassName = otherTuple.getSootClassName();
            CPVariable otherVar = otherTuple.getVariable();
            boolean inBoth = false;
            for (int j = 0; j < this.numElements; ++j) {
                CPTuple thisTuple = ((CPTuple[])this.elements)[j];
                String thisClassName = thisTuple.getSootClassName();
                CPVariable thisVar = thisTuple.getVariable();
                if (!otherClassName.equals(thisClassName) || !thisVar.equals(otherVar)) continue;
                inBoth = true;
                break;
            }
            if (inBoth) continue;
            workingSet.add(otherTuple.clone());
        }
    }

    @Override
    public CPFlowSet clone() {
        return new CPFlowSet(this);
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Printing CPFlowSet: ");
        for (int i = 0; i < this.numElements; ++i) {
            b.append("\n" + ((CPTuple[])this.elements)[i].toString());
        }
        b.append("\n");
        return b.toString();
    }
}

