/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Access;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.NameType;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.Value;
import soot.jimple.NullConstant;

public class CastExpr
extends Expr
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public CastExpr clone() throws CloneNotSupportedException {
        CastExpr node = (CastExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public CastExpr copy() {
        try {
            CastExpr node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public CastExpr fullCopy() {
        CastExpr tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append("(");
        this.getTypeAccess().toString(s);
        s.append(")");
        this.getExpr().toString(s);
    }

    @Override
    public void typeCheck() {
        TypeDecl expr = this.getExpr().type();
        TypeDecl type = this.getTypeAccess().type();
        if (!expr.isUnknown()) {
            if (!expr.castingConversionTo(type)) {
                this.error(expr.typeName() + " can not be cast into " + type.typeName());
            }
            if (!this.getTypeAccess().isTypeAccess()) {
                this.error("" + this.getTypeAccess() + " is not a type access in cast expression");
            }
        }
    }

    @Override
    public Value eval(Body b) {
        if (this.isConstant()) {
            return CastExpr.emitConstant(this.constant());
        }
        Value operand = this.getExpr().eval(b);
        if (operand == NullConstant.v()) {
            return this.getExpr().type().emitCastTo(b, operand, this.type(), this);
        }
        return this.getExpr().type().emitCastTo(b, this.asLocal(b, operand), this.type(), this);
    }

    @Override
    public void checkWarnings() {
        if (!this.withinSuppressWarnings("unchecked")) {
            this.checkUncheckedConversion(this.getExpr().type(), this.getTypeAccess().type());
        }
    }

    public CastExpr() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[2];
    }

    public CastExpr(Access p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setTypeAccess(Access node) {
        this.setChild(node, 0);
    }

    public Access getTypeAccess() {
        return (Access)this.getChild(0);
    }

    public Access getTypeAccessNoTransform() {
        return (Access)this.getChildNoTransform(0);
    }

    public void setExpr(Expr node) {
        this.setChild(node, 1);
    }

    public Expr getExpr() {
        return (Expr)this.getChild(1);
    }

    public Expr getExprNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constant constant() {
        ASTNode$State state = this.state();
        Constant constant = this.type().cast(this.getExpr().constant());
        return constant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConstant() {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isConstant() && (this.getTypeAccess().type().isPrimitive() || this.getTypeAccess().type().isString());
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isDAafter(v);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isDUafter(v);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuperAccess() {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isSuperAccess();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isThisAccess() {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().isThisAccess();
        return bl;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.getTypeAccess().type();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean staticContextQualifier() {
        ASTNode$State state = this.state();
        boolean bl = this.getExpr().staticContextQualifier();
        return bl;
    }

    public boolean withinSuppressWarnings(String s) {
        ASTNode$State state = this.state();
        boolean withinSuppressWarnings_String_value = this.getParent().Define_boolean_withinSuppressWarnings(this, null, s);
        return withinSuppressWarnings_String_value;
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getTypeAccessNoTransform()) {
            return NameType.TYPE_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

