/*
 * Decompiled with CFR 0.152.
 */
package ppg.parse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import ppg.lex.Lexer;
import ppg.parse.Parser;
import ppg.spec.Spec;
import ppg.util.CodeWriter;

public class ParseTest {
    private static final String HEADER = "ppg [parsetest]: ";

    private ParseTest() {
    }

    public static void main(String[] args) {
        FileInputStream fileInput;
        String filename = null;
        try {
            filename = args[0];
            fileInput = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            System.out.println("Error: " + filename + " is not found.");
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("ppg [parsetest]: Error: No file name given.");
            return;
        }
        File f = new File(filename);
        String simpleName = f.getName();
        Lexer lex = new Lexer(fileInput, simpleName);
        Parser parser2 = new Parser(filename, lex);
        try {
            parser2.parse();
        }
        catch (Exception e) {
            System.out.println("ppg [parsetest]: Exception: " + e.getMessage());
            return;
        }
        Spec spec = (Spec)parser2.getProgramNode();
        CodeWriter cw = new CodeWriter(System.out, 72);
        try {
            spec.unparse(cw);
            cw.flush();
            fileInput.close();
        }
        catch (IOException e) {
            System.out.println("ppg [parsetest]: exception: " + e.getMessage());
            return;
        }
    }
}

