/*
 * Decompiled with CFR 0.152.
 */
package heros.solver;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountLatch {
    private final Sync sync;

    public CountLatch(int count) {
        this.sync = new Sync(count);
    }

    public void awaitZero() throws InterruptedException {
        this.sync.acquireShared(1);
    }

    public boolean awaitZero(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public void increment() {
        this.sync.acquireNonBlocking(1);
    }

    public void decrement() {
        this.sync.releaseShared(1);
    }

    public void resetAndInterrupt() {
        this.sync.reset();
        for (int i = 0; i < 3; ++i) {
            for (Thread t : this.sync.getQueuedThreads()) {
                t.interrupt();
            }
        }
        this.sync.reset();
    }

    public String toString() {
        return super.toString() + "[Count = " + this.sync.getCount() + "]";
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        Sync(int count) {
            this.setState(count);
        }

        int getCount() {
            return this.getState();
        }

        void reset() {
            this.setState(0);
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        protected int acquireNonBlocking(int acquires) {
            int nextc;
            int c;
            while (!this.compareAndSetState(c = this.getState(), nextc = c + 1)) {
            }
            return 1;
        }

        @Override
        protected boolean tryReleaseShared(int releases) {
            int nextc;
            int c;
            do {
                if ((c = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(c, nextc = c - 1));
            return nextc == 0;
        }
    }
}

