/*
 * Decompiled with CFR 0.152.
 */
package com.asus.cta;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemProperties;
import android.provider.Settings;
import android.view.ContextThemeWrapper;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;

public class MobileDataChecker {
    private static final String AUTHORITY = "com.asus.CTA_PROVIDER";
    private static final String COL_ACCEPT = "accept";
    private static final String COL_ACTION = "action";
    private static final String COL_CALLER = "caller";
    private static final String TABLE_PERMISSION = "permissions";
    public static final String TAG = "Checker";
    private static final Uri URI_PERMISSION = Uri.parse("content://com.asus.CTA_PROVIDER/permissions");
    private static AlertDialog dialog;
    private static boolean mbPass;
    private Context mContext;
    private DialogInterface.OnDismissListener mDismissListener = new DialogInterface.OnDismissListener(){

        @Override
        public void onDismiss(DialogInterface dialogInterface) {
            MobileDataChecker.this.release();
            MobileDataChecker.access$002(MobileDataChecker.this, null);
            MobileDataChecker.access$302(MobileDataChecker.this, null);
        }
    };
    private Handler mHandler;
    private Context mThemeContext;
    PermissionChecker permissionChecker;
    HandlerThread thread;

    static {
        mbPass = false;
    }

    public MobileDataChecker(Context context) {
        this.mContext = context;
        this.thread = new HandlerThread(TAG);
        this.thread.start();
        this.mHandler = new Handler(this.thread.getLooper());
    }

    static /* synthetic */ Context access$002(MobileDataChecker mobileDataChecker, Context context) {
        mobileDataChecker.mContext = context;
        return context;
    }

    static /* synthetic */ boolean access$102(boolean bl) {
        mbPass = bl;
        return bl;
    }

    static /* synthetic */ AlertDialog access$202(AlertDialog alertDialog) {
        dialog = alertDialog;
        return alertDialog;
    }

    static /* synthetic */ Context access$302(MobileDataChecker mobileDataChecker, Context context) {
        mobileDataChecker.mThemeContext = context;
        return context;
    }

    private String getAppName(String string2) {
        PackageManager packageManager = this.mContext.getPackageManager();
        try {
            String string3 = packageManager.getApplicationInfo(string2, 1).loadLabel(packageManager).toString();
            return string3;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return string2;
        }
    }

    private String getMessage() {
        return "Enable mobile data? Additional fee may incur depending on your mobile network plan. You can disable mobile data to avoid additional charges when finished.";
    }

    private String getTitle() {
        return "Enable mobile data";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkPermission(int n, String string2) {
        this.permissionChecker = new PermissionChecker(n, string2);
        Object object = this.permissionChecker.checkLock;
        synchronized (object) {
            this.mHandler.post(this.permissionChecker);
            try {
                this.permissionChecker.checkLock.wait();
                return this.permissionChecker.getResult();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return false;
            }
        }
    }

    public void release() {
        this.mHandler.removeCallbacksAndMessages(this.permissionChecker);
        this.permissionChecker = null;
        if (this.thread != null) {
            this.thread.quitSafely();
            HandlerThread handlerThread = this.thread;
            this.thread = null;
            handlerThread.interrupt();
        }
        this.mContext = null;
        dialog = null;
        this.mThemeContext = null;
    }

    private class PermissionChecker
    implements Runnable {
        Object checkLock = new Object();
        int mAction;
        String mCaller;
        boolean result = false;

        PermissionChecker(int n, String string2) {
            this.mAction = n;
            this.mCaller = string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addPermission(int n) {
            if (MobileDataChecker.this.mContext == null) return;
            MobileDataChecker.access$102(true);
            try {
                Settings.System.putInt(MobileDataChecker.this.mContext.getContentResolver(), "MobileDataCheckerPass", 1);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        private boolean queryPermission() {
            boolean bl;
            block2: {
                block3: {
                    Context context = MobileDataChecker.this.mContext;
                    bl = false;
                    if (context == null) break block2;
                    if (Settings.System.getInt(MobileDataChecker.this.mContext.getContentResolver(), "MobileDataCheckerPass", 0) == 1) break block3;
                    boolean bl2 = mbPass;
                    bl = false;
                    if (!bl2) break block2;
                }
                bl = true;
                this.result = true;
            }
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void showDialog() {
            System.out.println("mContext = " + MobileDataChecker.this.mContext);
            System.out.println("dialog = " + dialog);
            if (MobileDataChecker.this.mContext == null || dialog != null) {
                return;
            }
            MobileDataChecker mobileDataChecker = MobileDataChecker.this;
            ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(MobileDataChecker.this.mContext, 16974123);
            MobileDataChecker.access$302(mobileDataChecker, contextThemeWrapper);
            LinearLayout linearLayout = new LinearLayout(MobileDataChecker.this.mThemeContext);
            linearLayout.setOrientation(1);
            float f = ((MobileDataChecker)MobileDataChecker.this).mContext.getResources().getDisplayMetrics().density;
            int n = (int)(0.5f + f * (float)13);
            int n2 = (int)(0.5f + f * (float)15);
            linearLayout.setPadding(n, n2, n, n2);
            TextView textView = new TextView(MobileDataChecker.this.mThemeContext);
            MobileDataChecker.this.getMessage();
            if ("dsda".equals(SystemProperties.get("persist.radio.multisim.config"))) {
                textView.setText(MobileDataChecker.this.mContext.getString(17039387) + "\n" + MobileDataChecker.this.mContext.getString(17039385));
            } else {
                textView.setText(MobileDataChecker.this.mContext.getString(17039385));
            }
            textView.setTextSize(18.0f);
            textView.setTextColor(-16777216);
            linearLayout.addView(textView);
            final CheckBox checkBox = new CheckBox(MobileDataChecker.this.mThemeContext);
            checkBox.setText(MobileDataChecker.this.mContext.getString(17039386));
            checkBox.setTextSize(15.0f);
            checkBox.setTextColor(-16777216);
            linearLayout.addView(checkBox);
            ScrollView scrollView = new ScrollView(MobileDataChecker.this.mThemeContext);
            scrollView.addView(linearLayout);
            AlertDialog.Builder builder = new AlertDialog.Builder(MobileDataChecker.this.mThemeContext);
            builder.setTitle(MobileDataChecker.this.mContext.getString(17039384));
            builder.setView(scrollView);
            builder.setCancelable(false);
            String string2 = MobileDataChecker.this.mContext.getString(17039379);
            DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void onClick(DialogInterface dialogInterface, int n) {
                    Object object = PermissionChecker.this.checkLock;
                    // MONITORENTER : object
                    PermissionChecker.this.result = true;
                    PermissionChecker.this.checkLock.notifyAll();
                    // MONITOREXIT : object
                    if (!checkBox.isChecked()) return;
                    PermissionChecker.this.addPermission(1);
                }
            };
            builder.setPositiveButton(string2, onClickListener);
            String string3 = MobileDataChecker.this.mContext.getString(0x1040000);
            DialogInterface.OnClickListener onClickListener2 = new DialogInterface.OnClickListener(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void onClick(DialogInterface dialogInterface, int n) {
                    Object object = PermissionChecker.this.checkLock;
                    synchronized (object) {
                        PermissionChecker.this.result = false;
                        PermissionChecker.this.checkLock.notifyAll();
                        return;
                    }
                }
            };
            builder.setNegativeButton(string3, onClickListener2);
            MobileDataChecker.access$202(builder.create());
            dialog.setOnDismissListener(MobileDataChecker.this.mDismissListener);
            dialog.getWindow().setType(2010);
            dialog.show();
        }

        public boolean getResult() {
            return this.result;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object = this.checkLock;
            synchronized (object) {
                if (this.queryPermission()) {
                    this.checkLock.notifyAll();
                } else {
                    try {
                        this.showDialog();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.result = true;
                        this.checkLock.notifyAll();
                    }
                }
                return;
            }
        }
    }
}

