/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.net.LinkProperties;
import com.android.server.net.DnsServerEntry;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class DnsServerRepository {
    public static final int NUM_CURRENT_SERVERS = 3;
    public static final int NUM_SERVERS = 12;
    public static final String TAG = "DnsServerRepository";
    private ArrayList<DnsServerEntry> mAllServers;
    private Set<InetAddress> mCurrentServers = new HashSet<InetAddress>();
    private HashMap<InetAddress, DnsServerEntry> mIndex;

    public DnsServerRepository() {
        this.mAllServers = new ArrayList(12);
        this.mIndex = new HashMap(12);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateCurrentServers() {
        synchronized (this) {
            DnsServerEntry dnsServerEntry;
            long l = System.currentTimeMillis();
            boolean bl = false;
            for (int i = -1 + this.mAllServers.size(); i >= 0 && (i >= 12 || this.mAllServers.get((int)i).expiry < l); bl |= this.mCurrentServers.remove(dnsServerEntry.address), --i) {
                dnsServerEntry = this.mAllServers.remove(i);
                this.mIndex.remove(dnsServerEntry.address);
            }
            for (DnsServerEntry dnsServerEntry2 : this.mAllServers) {
                if (this.mCurrentServers.size() >= 3) break;
                boolean bl2 = this.mCurrentServers.add(dnsServerEntry2.address);
                bl |= bl2;
            }
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean updateExistingEntry(InetAddress inetAddress, long l) {
        synchronized (this) {
            DnsServerEntry dnsServerEntry = this.mIndex.get(inetAddress);
            if (dnsServerEntry == null) return false;
            dnsServerEntry.expiry = l;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addServers(long l, String[] stringArray) {
        synchronized (this) {
            long l2 = System.currentTimeMillis();
            long l3 = l2 + 1000L * l;
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                block8: {
                    InetAddress inetAddress;
                    if (n2 >= n) {
                        Collections.sort(this.mAllServers);
                        return this.updateCurrentServers();
                    }
                    String string2 = stringArray[n2];
                    try {
                        inetAddress = InetAddress.parseNumericAddress((String)string2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        break block8;
                    }
                    if (!this.updateExistingEntry(inetAddress, l3) && l3 > l2) {
                        DnsServerEntry dnsServerEntry = new DnsServerEntry(inetAddress, l3);
                        this.mAllServers.add(dnsServerEntry);
                        this.mIndex.put(inetAddress, dnsServerEntry);
                    }
                }
                ++n2;
            }
        }
    }

    public void setDnsServersOn(LinkProperties linkProperties) {
        synchronized (this) {
            linkProperties.setDnsServers(this.mCurrentServers);
            return;
        }
    }
}

