/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Chronometer;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.RemoteViews;

@RemoteViews.RemoteView
public class TextProgressBar
extends RelativeLayout
implements Chronometer.OnChronometerTickListener {
    static final int CHRONOMETER_ID = 16908308;
    static final int PROGRESSBAR_ID = 16908301;
    public static final String TAG = "TextProgressBar";
    Chronometer mChronometer = null;
    boolean mChronometerFollow = false;
    int mChronometerGravity = 0;
    int mDuration = -1;
    long mDurationBase = -1L;
    ProgressBar mProgressBar = null;

    public TextProgressBar(Context context) {
        super(context);
    }

    public TextProgressBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public TextProgressBar(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    public TextProgressBar(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        int n2 = view.getId();
        if (n2 == 16908308 && view instanceof Chronometer) {
            this.mChronometer = (Chronometer)view;
            this.mChronometer.setOnChronometerTickListener(this);
            boolean bl = layoutParams.width == -2;
            this.mChronometerFollow = bl;
            this.mChronometerGravity = 0x800007 & this.mChronometer.getGravity();
            return;
        } else {
            if (n2 != 16908301 || !(view instanceof ProgressBar)) return;
            this.mProgressBar = (ProgressBar)view;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onChronometerTick(Chronometer chronometer) {
        if (this.mProgressBar == null) {
            throw new RuntimeException("Expecting child ProgressBar with id 'android.R.id.progress'");
        }
        long l = SystemClock.elapsedRealtime();
        if (l >= this.mDurationBase) {
            this.mChronometer.stop();
        }
        int n = (int)(this.mDurationBase - l);
        this.mProgressBar.setProgress(this.mDuration - n);
        if (this.mChronometerFollow) {
            int n2;
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mProgressBar.getLayoutParams();
            int n3 = this.mProgressBar.getWidth() - (layoutParams.leftMargin + layoutParams.rightMargin);
            int n4 = n3 * this.mProgressBar.getProgress() / this.mProgressBar.getMax() + layoutParams.leftMargin;
            int n5 = this.mChronometer.getWidth();
            if (this.mChronometerGravity == 0x800005) {
                n2 = -n5;
            } else {
                int n6 = this.mChronometerGravity;
                n2 = 0;
                if (n6 == 1) {
                    n2 = -(n5 / 2);
                }
            }
            int n7 = n4 + n2;
            int n8 = n3 - layoutParams.rightMargin - n5;
            if (n7 < layoutParams.leftMargin) {
                n7 = layoutParams.leftMargin;
            } else if (n7 > n8) {
                n7 = n8;
            }
            ((RelativeLayout.LayoutParams)this.mChronometer.getLayoutParams()).leftMargin = n7;
            this.mChronometer.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setDurationBase(long l) {
        this.mDurationBase = l;
        if (this.mProgressBar == null || this.mChronometer == null) {
            throw new RuntimeException("Expecting child ProgressBar with id 'android.R.id.progress' and Chronometer id 'android.R.id.text1'");
        }
        this.mDuration = (int)(l - this.mChronometer.getBase());
        if (this.mDuration <= 0) {
            this.mDuration = 1;
        }
        this.mProgressBar.setMax(this.mDuration);
    }
}

