/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.AnimationUtils;
import android.widget.AbsListView;
import android.widget.OverScroller;
import com.android.internal.R;

public class ResolverDrawerLayout
extends ViewGroup {
    private static final String TAG = "ResolverDrawerLayout";
    private int mActivePointerId = -1;
    private View.OnClickListener mClickOutsideListener;
    private float mCollapseOffset;
    private int mCollapsibleHeight;
    private float mInitialTouchX;
    private float mInitialTouchY;
    private boolean mIsDragging;
    private float mLastTouchY;
    private int mMaxCollapsedHeight;
    private int mMaxCollapsedHeightSmall;
    private int mMaxWidth;
    private final float mMinFlingVelocity;
    private boolean mOpenOnClick;
    private boolean mOpenOnLayout;
    private final OverScroller mScroller;
    private boolean mSmallCollapsed;
    private final Rect mTempRect = new Rect();
    private int mTopOffset;
    private final ViewTreeObserver.OnTouchModeChangeListener mTouchModeChangeListener = new ViewTreeObserver.OnTouchModeChangeListener(){

        @Override
        public void onTouchModeChanged(boolean bl) {
            if (!bl && ResolverDrawerLayout.this.hasFocus() && ResolverDrawerLayout.this.isDescendantClipped(ResolverDrawerLayout.this.getFocusedChild())) {
                ResolverDrawerLayout.this.smoothScrollTo(0, 0.0f);
            }
        }
    };
    private final int mTouchSlop;
    private final VelocityTracker mVelocityTracker;

    public ResolverDrawerLayout(Context context) {
        this(context, null);
    }

    public ResolverDrawerLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ResolverDrawerLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ResolverDrawerLayout, n, 0);
        this.mMaxWidth = typedArray.getDimensionPixelSize(0, -1);
        this.mMaxCollapsedHeight = typedArray.getDimensionPixelSize(1, 0);
        this.mMaxCollapsedHeightSmall = typedArray.getDimensionPixelSize(2, this.mMaxCollapsedHeight);
        typedArray.recycle();
        this.mScroller = new OverScroller(context, AnimationUtils.loadInterpolator(context, 17563653));
        this.mVelocityTracker = VelocityTracker.obtain();
        ViewConfiguration viewConfiguration = ViewConfiguration.get(context);
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mMinFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
    }

    private float distanceInfluenceForSnapDuration(float f) {
        return (float)Math.sin((float)(0.4712389167638204 * (double)(f - 0.5f)));
    }

    private View findChildUnder(float f, float f2) {
        return ResolverDrawerLayout.findChildUnder(this, f, f2);
    }

    private static View findChildUnder(ViewGroup viewGroup, float f, float f2) {
        for (int i = -1 + viewGroup.getChildCount(); i >= 0; --i) {
            View view = viewGroup.getChildAt(i);
            if (!ResolverDrawerLayout.isChildUnder(view, f, f2)) continue;
            return view;
        }
        return null;
    }

    private View findListChildUnder(float f, float f2) {
        View view = this.findChildUnder(f, f2);
        while (true) {
            block6: {
                block5: {
                    if (view == null) break block5;
                    f -= view.getX();
                    f2 -= view.getY();
                    if (!(view instanceof AbsListView)) break block6;
                    view = ResolverDrawerLayout.findChildUnder((ViewGroup)view, f, f2);
                }
                return view;
            }
            if (view instanceof ViewGroup) {
                view = ResolverDrawerLayout.findChildUnder((ViewGroup)view, f, f2);
                continue;
            }
            view = null;
        }
    }

    private int getMaxCollapsedHeight() {
        if (this.isSmallCollapsed()) {
            return this.mMaxCollapsedHeightSmall;
        }
        return this.mMaxCollapsedHeight;
    }

    private static boolean isChildUnder(View view, float f, float f2) {
        float f3 = view.getX();
        float f4 = view.getY();
        float f5 = f3 + (float)view.getWidth();
        float f6 = f4 + (float)view.getHeight();
        return f >= f3 && f2 >= f4 && f < f5 && f2 < f6;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isDescendantClipped(View view) {
        View view2;
        this.mTempRect.set(0, 0, view.getWidth(), view.getHeight());
        this.offsetDescendantRectToMyCoords(view, this.mTempRect);
        if (view.getParent() == this) {
            view2 = view;
        } else {
            View view3 = view;
            ViewParent viewParent = view.getParent();
            while (viewParent != this) {
                view3 = (View)((Object)viewParent);
                viewParent = view3.getParent();
            }
            view2 = view3;
        }
        int n = this.getHeight() - this.getPaddingBottom();
        int n2 = this.getChildCount();
        for (int i = 1 + this.indexOfChild(view2); i < n2; ++i) {
            View view4 = this.getChildAt(i);
            if (view4.getVisibility() == 8) continue;
            n = Math.min(n, view4.getTop());
        }
        int n3 = this.mTempRect.bottom;
        boolean bl = false;
        if (n3 <= n) return bl;
        return true;
    }

    private boolean isListChildUnderClipped(float f, float f2) {
        View view = this.findListChildUnder(f, f2);
        return view != null && this.isDescendantClipped(view);
    }

    private boolean isMoving() {
        return this.mIsDragging || !this.mScroller.isFinished();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        int n = motionEvent.getActionIndex();
        if (motionEvent.getPointerId(n) == this.mActivePointerId) {
            float f;
            int n2 = n == 0 ? 1 : 0;
            this.mInitialTouchX = motionEvent.getX(n2);
            this.mLastTouchY = f = motionEvent.getY(n2);
            this.mInitialTouchY = f;
            this.mActivePointerId = motionEvent.getPointerId(n2);
        }
    }

    private float performDrag(float f) {
        float f2 = Math.max(0.0f, Math.min(f + this.mCollapseOffset, (float)this.mCollapsibleHeight));
        float f3 = f2 - this.mCollapseOffset;
        float f4 = f3 == 0.0f ? 0 : (f3 > 0.0f ? 1 : -1);
        float f5 = 0.0f;
        if (f4 != false) {
            float f6 = f2 - this.mCollapseOffset;
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = this.getChildAt(i);
                if (((LayoutParams)view.getLayoutParams()).ignoreOffset) continue;
                view.offsetTopAndBottom((int)f6);
            }
            this.mCollapseOffset = f2;
            this.mTopOffset = (int)(f6 + (float)this.mTopOffset);
            this.postInvalidateOnAnimation();
            f5 = f6;
        }
        return f5;
    }

    private void resetTouch() {
        this.mActivePointerId = -1;
        this.mIsDragging = false;
        this.mOpenOnClick = false;
        this.mLastTouchY = 0.0f;
        this.mInitialTouchY = 0.0f;
        this.mInitialTouchX = 0.0f;
        this.mVelocityTracker.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void smoothScrollTo(int n, float f) {
        int n2;
        int n3;
        block3: {
            block2: {
                if (this.getMaxCollapsedHeight() == 0) break block2;
                this.mScroller.abortAnimation();
                n3 = (int)this.mCollapseOffset;
                n2 = n - n3;
                if (n2 != 0) break block3;
            }
            return;
        }
        int n4 = this.getHeight();
        int n5 = n4 / 2;
        float f2 = Math.min(1.0f, 1.0f * (float)Math.abs(n2) / (float)n4);
        float f3 = (float)n5 + (float)n5 * this.distanceInfluenceForSnapDuration(f2);
        float f4 = Math.abs(f);
        int n6 = f4 > 0.0f ? 4 * Math.round(1000.0f * Math.abs(f3 / f4)) : (int)(100.0f * (1.0f + (float)Math.abs(n2) / (float)n4));
        int n7 = Math.min(n6, 300);
        this.mScroller.startScroll(0, n3, 0, n2, n7);
        this.postInvalidateOnAnimation();
    }

    @Override
    public void computeScroll() {
        super.computeScroll();
        if (!this.mScroller.isFinished()) {
            boolean bl = this.mScroller.computeScrollOffset();
            this.performDrag((float)this.mScroller.getCurrY() - this.mCollapseOffset);
            if (bl) {
                this.postInvalidateOnAnimation();
            }
        }
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)layoutParams);
        }
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)layoutParams);
        }
        return new LayoutParams(layoutParams);
    }

    public boolean isCollapsed() {
        return this.mCollapseOffset > 0.0f;
    }

    public boolean isSmallCollapsed() {
        return this.mSmallCollapsed;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnTouchModeChangeListener(this.mTouchModeChangeListener);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getViewTreeObserver().removeOnTouchModeChangeListener(this.mTouchModeChangeListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.mVelocityTracker.clear();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        switch (n) {
            case 0: {
                float f = motionEvent.getX();
                float f2 = motionEvent.getY();
                this.mInitialTouchX = f;
                this.mLastTouchY = f2;
                this.mInitialTouchY = f2;
                boolean bl = this.isListChildUnderClipped(f, f2) && this.mCollapsibleHeight > 0;
                this.mOpenOnClick = bl;
                break;
            }
            case 2: {
                float f = motionEvent.getX();
                float f3 = motionEvent.getY();
                float f4 = f3 - this.mInitialTouchY;
                if (!(Math.abs(f4) > (float)this.mTouchSlop) || this.findChildUnder(f, f3) == null || (2 & this.getNestedScrollAxes()) != 0) break;
                this.mActivePointerId = motionEvent.getPointerId(0);
                this.mIsDragging = true;
                this.mLastTouchY = Math.max(this.mLastTouchY - (float)this.mTouchSlop, Math.min(f4 + this.mLastTouchY, this.mLastTouchY + (float)this.mTouchSlop));
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                break;
            }
            case 1: 
            case 3: {
                this.resetTouch();
                break;
            }
        }
        if (this.mIsDragging) {
            this.mScroller.abortAnimation();
        }
        if (this.mIsDragging) return true;
        boolean bl = this.mOpenOnClick;
        boolean bl2 = false;
        if (!bl) return bl2;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getWidth();
        int n6 = this.mTopOffset;
        int n7 = this.getPaddingLeft();
        int n8 = n5 - this.getPaddingRight();
        int n9 = this.getChildCount();
        int n10 = 0;
        while (n10 < n9) {
            View view = this.getChildAt(n10);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (view.getVisibility() != 8) {
                int n11 = n6 + layoutParams.topMargin;
                if (layoutParams.ignoreOffset) {
                    n11 = (int)((float)n11 - this.mCollapseOffset);
                }
                int n12 = n11 + view.getMeasuredHeight();
                int n13 = view.getMeasuredWidth();
                int n14 = n7 + (n8 - n7 - n13) / 2;
                view.layout(n14, n11, n14 + n13, n12);
                n6 = n12 + layoutParams.bottomMargin;
            }
            ++n10;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4 = n3 = View.MeasureSpec.getSize(n);
        int n5 = View.MeasureSpec.getSize(n2);
        if (this.mMaxWidth >= 0) {
            n4 = Math.min(n4, this.mMaxWidth);
        }
        int n6 = View.MeasureSpec.makeMeasureSpec(n4, 0x40000000);
        int n7 = View.MeasureSpec.makeMeasureSpec(n5, 0x40000000);
        int n8 = this.getPaddingLeft() + this.getPaddingRight();
        int n9 = this.getPaddingTop() + this.getPaddingBottom();
        int n10 = this.getChildCount();
        for (int i = 0; i < n10; ++i) {
            View view = this.getChildAt(i);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (!layoutParams.alwaysShow || view.getVisibility() == 8) continue;
            this.measureChildWithMargins(view, n6, n8, n7, n9);
            n9 += layoutParams.topMargin + view.getMeasuredHeight() + layoutParams.bottomMargin;
        }
        int n11 = n9;
        for (int i = 0; i < n10; ++i) {
            View view = this.getChildAt(i);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.alwaysShow || view.getVisibility() == 8) continue;
            this.measureChildWithMargins(view, n6, n8, n7, n9);
            n9 += layoutParams.topMargin + view.getMeasuredHeight() + layoutParams.bottomMargin;
        }
        this.mCollapsibleHeight = Math.max(0, n9 - n11 - this.getMaxCollapsedHeight());
        if (this.isLaidOut()) {
            this.mCollapseOffset = Math.min(this.mCollapseOffset, (float)this.mCollapsibleHeight);
        } else {
            float f = this.mOpenOnLayout ? 0.0f : (float)this.mCollapsibleHeight;
            this.mCollapseOffset = f;
        }
        this.mTopOffset = Math.max(0, n5 - n9) + (int)this.mCollapseOffset;
        this.setMeasuredDimension(n3, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        boolean bl2 = false;
        if (bl) return bl2;
        float f3 = Math.abs(f2) - this.mMinFlingVelocity;
        float f4 = f3 == 0.0f ? 0 : (f3 > 0.0f ? 1 : -1);
        bl2 = false;
        if (f4 <= 0) return bl2;
        float f5 = f2 - 0.0f;
        float f6 = f5 == 0.0f ? 0 : (f5 > 0.0f ? 1 : -1);
        int n = 0;
        if (f6 <= 0) {
            n = this.mCollapsibleHeight;
        }
        this.smoothScrollTo(n, f2);
        return true;
    }

    @Override
    public boolean onNestedPreFling(View view, float f, float f2) {
        float f3 = f2 - this.mMinFlingVelocity;
        float f4 = f3 == 0.0f ? 0 : (f3 > 0.0f ? 1 : -1);
        boolean bl = false;
        if (f4 > 0) {
            float f5 = this.mCollapseOffset - 0.0f;
            float f6 = f5 == 0.0f ? 0 : (f5 > 0.0f ? 1 : -1);
            bl = false;
            if (f6 != false) {
                this.smoothScrollTo(0, f2);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void onNestedPreScroll(View view, int n, int n2, int[] nArray) {
        if (n2 > 0) {
            nArray[1] = (int)(-this.performDrag(-n2));
        }
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4) {
        if (n4 < 0) {
            this.performDrag(-n4);
        }
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n) {
        super.onNestedScrollAccepted(view, view2, n);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mOpenOnLayout = savedState.open;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        boolean bl = this.mCollapsibleHeight > 0 && this.mCollapseOffset == 0.0f;
        savedState.open = bl;
        return savedState;
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n) {
        return (n & 2) != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onStopNestedScroll(View view) {
        super.onStopNestedScroll(view);
        if (this.mScroller.isFinished()) {
            int n = this.mCollapseOffset < (float)(this.mCollapsibleHeight / 2) ? 0 : this.mCollapsibleHeight;
            this.smoothScrollTo(n, 0.0f);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean onTouchEvent(MotionEvent var1_1) {
        block27: {
            var2_2 = true;
            var3_3 = var1_1.getActionMasked();
            this.mVelocityTracker.addMovement(var1_1);
            var4_4 = false;
            switch (var3_3) lbl-1000:
            // 6 sources

            {
                default: {
                    return var4_4;
                }
                case 0: {
                    var24_5 = var1_1.getX();
                    var25_6 = var1_1.getY();
                    this.mInitialTouchX = var24_5;
                    this.mLastTouchY = var25_6;
                    this.mInitialTouchY = var25_6;
                    this.mActivePointerId = var1_1.getPointerId(0);
                    var26_7 = this.findChildUnder(this.mInitialTouchX, this.mInitialTouchY);
                    var27_8 = false;
                    if (var26_7 == null) {
                        var28_9 = this.mClickOutsideListener;
                        var27_8 = false;
                        if (var28_9 != null) {
                            this.mIsDragging = var27_8 = true;
                        }
                    }
                    if (this.mCollapsibleHeight <= 0) ** GOTO lbl27
lbl23:
                    // 2 sources

                    while (true) {
                        var4_4 = var27_8 | var2_2;
                        this.mScroller.abortAnimation();
                        ** GOTO lbl-1000
                        break;
                    }
lbl27:
                    // 1 sources

                    var2_2 = false;
                    ** continue;
                }
                case 2: {
                    var14_10 = var1_1.findPointerIndex(this.mActivePointerId);
                    if (var14_10 < 0) {
                        Log.e("ResolverDrawerLayout", "Bad pointer id " + this.mActivePointerId + ", resetting");
                        var14_10 = 0;
                        this.mActivePointerId = var1_1.getPointerId(0);
                        this.mInitialTouchX = var1_1.getX();
                        this.mLastTouchY = var23_11 = var1_1.getY();
                        this.mInitialTouchY = var23_11;
                    }
                    var15_12 = var1_1.getX(var14_10);
                    var16_13 = var1_1.getY(var14_10);
                    var17_14 = this.mIsDragging;
                    var4_4 = false;
                    if (!var17_14) {
                        var19_15 = var16_13 - this.mInitialTouchY;
                        cfr_temp_0 = Math.abs(var19_15) - (float)this.mTouchSlop;
                        var20_16 = cfr_temp_0 == 0.0f ? 0 : (cfr_temp_0 > 0.0f ? 1 : -1);
                        var4_4 = false;
                        if (var20_16 > 0) {
                            var21_17 = this.findChildUnder(var15_12, var16_13);
                            var4_4 = false;
                            if (var21_17 != null) {
                                this.mIsDragging = var4_4 = true;
                                this.mLastTouchY = Math.max(this.mLastTouchY - (float)this.mTouchSlop, Math.min(var19_15 + this.mLastTouchY, this.mLastTouchY + (float)this.mTouchSlop));
                            }
                        }
                    }
                    if (this.mIsDragging) {
                        this.performDrag(var16_13 - this.mLastTouchY);
                    }
                    this.mLastTouchY = var16_13;
                    ** GOTO lbl-1000
                }
                case 5: {
                    var12_18 = var1_1.getActionIndex();
                    this.mActivePointerId = var1_1.getPointerId(var12_18);
                    this.mInitialTouchX = var1_1.getX(var12_18);
                    this.mLastTouchY = var13_19 = var1_1.getY(var12_18);
                    this.mInitialTouchY = var13_19;
                    var4_4 = false;
                    ** GOTO lbl-1000
                }
                case 6: {
                    this.onSecondaryPointerUp(var1_1);
                    var4_4 = false;
                    ** GOTO lbl-1000
                }
                case 1: {
                    this.mIsDragging = false;
                    if (!this.mIsDragging && this.findChildUnder(this.mInitialTouchX, this.mInitialTouchY) == null && this.findChildUnder(var1_1.getX(), var1_1.getY()) == null && this.mClickOutsideListener != null) {
                        this.mClickOutsideListener.onClick(this);
                        this.resetTouch();
                        return var2_2;
                    }
                    if (this.mOpenOnClick && Math.abs(var1_1.getX() - this.mInitialTouchX) < (float)this.mTouchSlop && Math.abs(var1_1.getY() - this.mInitialTouchY) < (float)this.mTouchSlop) {
                        this.smoothScrollTo(0, 0.0f);
                        return var2_2;
                    }
                    this.mVelocityTracker.computeCurrentVelocity(1000);
                    var7_20 = this.mVelocityTracker.getYVelocity(this.mActivePointerId);
                    if (!(Math.abs(var7_20) > this.mMinFlingVelocity)) ** GOTO lbl95
                    cfr_temp_1 = var7_20 - 0.0f;
                    var10_21 = cfr_temp_1 == 0.0f ? 0 : (cfr_temp_1 < 0.0f ? -1 : 1);
                    var11_22 = 0;
                    if (var10_21 >= 0) ** GOTO lbl93
lbl87:
                    // 2 sources

                    while (true) {
                        this.smoothScrollTo(var11_22, var7_20);
lbl89:
                        // 2 sources

                        while (true) {
                            this.resetTouch();
                            var4_4 = false;
                            ** GOTO lbl-1000
                            break;
                        }
                        break;
                    }
lbl93:
                    // 1 sources

                    var11_22 = this.mCollapsibleHeight;
                    ** continue;
lbl95:
                    // 1 sources

                    cfr_temp_2 = this.mCollapseOffset - (float)(this.mCollapsibleHeight / 2);
                    var8_23 = cfr_temp_2 == 0.0f ? 0 : (cfr_temp_2 < 0.0f ? -1 : 1);
                    var9_24 = 0;
                    if (var8_23 < 0) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            this.smoothScrollTo(var9_24, 0.0f);
                            ** continue;
                            break;
                        }
                    }
                    var9_24 = this.mCollapsibleHeight;
                    ** continue;
                }
                case 3: 
            }
            if (!this.mIsDragging) ** GOTO lbl112
            cfr_temp_3 = this.mCollapseOffset - (float)(this.mCollapsibleHeight / 2);
            var5_25 = cfr_temp_3 == 0.0f ? 0 : (cfr_temp_3 < 0.0f ? -1 : 1);
            var6_26 = 0;
            if (var5_25 >= 0) break block27;
lbl110:
            // 2 sources

            while (true) {
                this.smoothScrollTo(var6_26, 0.0f);
lbl112:
                // 2 sources

                this.resetTouch();
                return var2_2;
            }
        }
        var6_26 = this.mCollapsibleHeight;
        ** while (true)
    }

    @Override
    public void requestChildFocus(View view, View view2) {
        super.requestChildFocus(view, view2);
        if (!this.isInTouchMode() && this.isDescendantClipped(view2)) {
            this.smoothScrollTo(0, 0.0f);
        }
    }

    public void setOnClickOutsideListener(View.OnClickListener onClickListener) {
        this.mClickOutsideListener = onClickListener;
    }

    public void setSmallCollapsed(boolean bl) {
        this.mSmallCollapsed = bl;
        this.requestLayout();
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public boolean alwaysShow;
        public boolean ignoreOffset;

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ResolverDrawerLayout_LayoutParams);
            this.alwaysShow = typedArray.getBoolean(1, false);
            this.ignoreOffset = typedArray.getBoolean(2, false);
            typedArray.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.alwaysShow = layoutParams.alwaysShow;
            this.ignoreOffset = layoutParams.ignoreOffset;
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        boolean open;

        /*
         * Enabled aggressive block sorting
         */
        private SavedState(Parcel parcel) {
            super(parcel);
            boolean bl = parcel.readInt() != 0;
            this.open = bl;
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            int n2 = this.open ? 1 : 0;
            parcel.writeInt(n2);
        }
    }
}

