/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.IntProperty;
import android.util.Log;
import android.util.Property;
import android.util.SparseArray;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.view.Window;
import android.view.WindowInsets;
import android.widget.OverScroller;
import android.widget.Toolbar;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.widget.ActionBarContainer;
import com.android.internal.widget.ActionBarContextView;
import com.android.internal.widget.DecorContentParent;
import com.android.internal.widget.DecorToolbar;

public class ActionBarOverlayLayout
extends ViewGroup
implements DecorContentParent {
    public static final Property<ActionBarOverlayLayout, Integer> ACTION_BAR_HIDE_OFFSET = new IntProperty<ActionBarOverlayLayout>("actionBarHideOffset"){

        @Override
        public Integer get(ActionBarOverlayLayout actionBarOverlayLayout) {
            return actionBarOverlayLayout.getActionBarHideOffset();
        }

        @Override
        public void setValue(ActionBarOverlayLayout actionBarOverlayLayout, int n) {
            actionBarOverlayLayout.setActionBarHideOffset(n);
        }
    };
    static final int[] ATTRS = new int[]{16843499, 16842841};
    private static final String TAG = "ActionBarOverlayLayout";
    private final int ACTION_BAR_ANIMATE_DELAY;
    private ActionBarContainer mActionBarBottom;
    private int mActionBarHeight;
    private ActionBarContainer mActionBarTop;
    private ActionBarVisibilityCallback mActionBarVisibilityCallback;
    private final Runnable mAddActionBarHideOffset;
    private boolean mAnimatingForFling;
    private final Rect mBaseContentInsets = new Rect();
    private final Rect mBaseInnerInsets;
    private final Animator.AnimatorListener mBottomAnimatorListener;
    private View mContent;
    private final Rect mContentInsets;
    private ViewPropertyAnimator mCurrentActionBarBottomAnimator;
    private ViewPropertyAnimator mCurrentActionBarTopAnimator;
    private DecorToolbar mDecorToolbar;
    private OverScroller mFlingEstimator;
    private boolean mHasNonEmbeddedTabs;
    private boolean mHideOnContentScroll;
    private int mHideOnContentScrollReference;
    private boolean mIgnoreWindowContentOverlay;
    private final Rect mInnerInsets;
    private final Rect mLastBaseContentInsets = new Rect();
    private final Rect mLastInnerInsets;
    private int mLastSystemUiVisibility;
    private boolean mOverlayMode;
    private final Runnable mRemoveActionBarHideOffset;
    private final Animator.AnimatorListener mTopAnimatorListener;
    private Drawable mWindowContentOverlay;
    private int mWindowVisibility = 0;

    public ActionBarOverlayLayout(Context context) {
        super(context);
        this.mContentInsets = new Rect();
        this.mBaseInnerInsets = new Rect();
        this.mInnerInsets = new Rect();
        this.mLastInnerInsets = new Rect();
        this.ACTION_BAR_ANIMATE_DELAY = 600;
        this.mTopAnimatorListener = new AnimatorListenerAdapter(){

            @Override
            public void onAnimationCancel(Animator animator2) {
                ActionBarOverlayLayout.access$002(ActionBarOverlayLayout.this, null);
                ActionBarOverlayLayout.access$102(ActionBarOverlayLayout.this, false);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                ActionBarOverlayLayout.access$002(ActionBarOverlayLayout.this, null);
                ActionBarOverlayLayout.access$102(ActionBarOverlayLayout.this, false);
            }
        };
        this.mBottomAnimatorListener = new AnimatorListenerAdapter(){

            @Override
            public void onAnimationCancel(Animator animator2) {
                ActionBarOverlayLayout.access$202(ActionBarOverlayLayout.this, null);
                ActionBarOverlayLayout.access$102(ActionBarOverlayLayout.this, false);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                ActionBarOverlayLayout.access$202(ActionBarOverlayLayout.this, null);
                ActionBarOverlayLayout.access$102(ActionBarOverlayLayout.this, false);
            }
        };
        this.mRemoveActionBarHideOffset = new Runnable(){

            @Override
            public void run() {
                ActionBarOverlayLayout.this.haltActionBarHideOffsetAnimations();
                ActionBarOverlayLayout.access$002(ActionBarOverlayLayout.this, ActionBarOverlayLayout.this.mActionBarTop.animate().translationY(0.0f).setListener(ActionBarOverlayLayout.this.mTopAnimatorListener));
                if (ActionBarOverlayLayout.this.mActionBarBottom != null && ActionBarOverlayLayout.this.mActionBarBottom.getVisibility() != 8) {
                    ActionBarOverlayLayout.access$202(ActionBarOverlayLayout.this, ActionBarOverlayLayout.this.mActionBarBottom.animate().translationY(0.0f).setListener(ActionBarOverlayLayout.this.mBottomAnimatorListener));
                }
            }
        };
        this.mAddActionBarHideOffset = new Runnable(){

            @Override
            public void run() {
                ActionBarOverlayLayout.this.haltActionBarHideOffsetAnimations();
                ActionBarOverlayLayout.access$002(ActionBarOverlayLayout.this, ActionBarOverlayLayout.this.mActionBarTop.animate().translationY(-ActionBarOverlayLayout.this.mActionBarTop.getHeight()).setListener(ActionBarOverlayLayout.this.mTopAnimatorListener));
                if (ActionBarOverlayLayout.this.mActionBarBottom != null && ActionBarOverlayLayout.this.mActionBarBottom.getVisibility() != 8) {
                    ActionBarOverlayLayout.access$202(ActionBarOverlayLayout.this, ActionBarOverlayLayout.this.mActionBarBottom.animate().translationY(ActionBarOverlayLayout.this.mActionBarBottom.getHeight()).setListener(ActionBarOverlayLayout.this.mBottomAnimatorListener));
                }
            }
        };
        this.init(context);
    }

    public ActionBarOverlayLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContentInsets = new Rect();
        this.mBaseInnerInsets = new Rect();
        this.mInnerInsets = new Rect();
        this.mLastInnerInsets = new Rect();
        this.ACTION_BAR_ANIMATE_DELAY = 600;
        this.mTopAnimatorListener = new /* invalid duplicate definition of identical inner class */;
        this.mBottomAnimatorListener = new /* invalid duplicate definition of identical inner class */;
        this.mRemoveActionBarHideOffset = new /* invalid duplicate definition of identical inner class */;
        this.mAddActionBarHideOffset = new /* invalid duplicate definition of identical inner class */;
        this.init(context);
    }

    static /* synthetic */ ViewPropertyAnimator access$002(ActionBarOverlayLayout actionBarOverlayLayout, ViewPropertyAnimator viewPropertyAnimator) {
        actionBarOverlayLayout.mCurrentActionBarTopAnimator = viewPropertyAnimator;
        return viewPropertyAnimator;
    }

    static /* synthetic */ boolean access$102(ActionBarOverlayLayout actionBarOverlayLayout, boolean bl) {
        actionBarOverlayLayout.mAnimatingForFling = bl;
        return bl;
    }

    static /* synthetic */ ViewPropertyAnimator access$202(ActionBarOverlayLayout actionBarOverlayLayout, ViewPropertyAnimator viewPropertyAnimator) {
        actionBarOverlayLayout.mCurrentActionBarBottomAnimator = viewPropertyAnimator;
        return viewPropertyAnimator;
    }

    private void addActionBarHideOffset() {
        this.haltActionBarHideOffsetAnimations();
        this.mAddActionBarHideOffset.run();
    }

    private boolean applyInsets(View view, Rect rect, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        boolean bl5 = false;
        if (bl) {
            int n = layoutParams.leftMargin;
            int n2 = rect.left;
            bl5 = false;
            if (n != n2) {
                bl5 = true;
                layoutParams.leftMargin = rect.left;
            }
        }
        if (bl2 && layoutParams.topMargin != rect.top) {
            bl5 = true;
            layoutParams.topMargin = rect.top;
        }
        if (bl4 && layoutParams.rightMargin != rect.right) {
            bl5 = true;
            layoutParams.rightMargin = rect.right;
        }
        if (bl3 && layoutParams.bottomMargin != rect.bottom) {
            bl5 = true;
            layoutParams.bottomMargin = rect.bottom;
        }
        return bl5;
    }

    private DecorToolbar getDecorToolbar(View view) {
        if (view instanceof DecorToolbar) {
            return (DecorToolbar)((Object)view);
        }
        if (view instanceof Toolbar) {
            return ((Toolbar)view).getWrapper();
        }
        throw new IllegalStateException("Can't make a decor toolbar out of " + view.getClass().getSimpleName());
    }

    private void haltActionBarHideOffsetAnimations() {
        this.removeCallbacks(this.mRemoveActionBarHideOffset);
        this.removeCallbacks(this.mAddActionBarHideOffset);
        if (this.mCurrentActionBarTopAnimator != null) {
            this.mCurrentActionBarTopAnimator.cancel();
        }
        if (this.mCurrentActionBarBottomAnimator != null) {
            this.mCurrentActionBarBottomAnimator.cancel();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void init(Context context) {
        boolean bl = true;
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(ATTRS);
        this.mActionBarHeight = typedArray.getDimensionPixelSize(0, 0);
        this.mWindowContentOverlay = typedArray.getDrawable(bl ? 1 : 0);
        boolean bl2 = this.mWindowContentOverlay == null ? bl : false;
        this.setWillNotDraw(bl2);
        typedArray.recycle();
        if (context.getApplicationInfo().targetSdkVersion >= 19) {
            bl = false;
        }
        this.mIgnoreWindowContentOverlay = bl;
        this.mFlingEstimator = new OverScroller(context);
    }

    private void postAddActionBarHideOffset() {
        this.haltActionBarHideOffsetAnimations();
        this.postDelayed(this.mAddActionBarHideOffset, 600L);
    }

    private void postRemoveActionBarHideOffset() {
        this.haltActionBarHideOffsetAnimations();
        this.postDelayed(this.mRemoveActionBarHideOffset, 600L);
    }

    private void removeActionBarHideOffset() {
        this.haltActionBarHideOffsetAnimations();
        this.mRemoveActionBarHideOffset.run();
    }

    private boolean shouldHideActionBarOnFling(float f, float f2) {
        this.mFlingEstimator.fling(0, 0, 0, (int)f2, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        int n = this.mFlingEstimator.getFinalY();
        int n2 = this.mActionBarTop.getHeight();
        boolean bl = false;
        if (n > n2) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean canShowOverflowMenu() {
        this.pullChildren();
        return this.mDecorToolbar.canShowOverflowMenu();
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    @Override
    public void dismissPopups() {
        this.pullChildren();
        this.mDecorToolbar.dismissPopupMenus();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mWindowContentOverlay != null && !this.mIgnoreWindowContentOverlay) {
            int n = this.mActionBarTop.getVisibility() == 0 ? (int)(0.5f + ((float)this.mActionBarTop.getBottom() + this.mActionBarTop.getTranslationY())) : 0;
            this.mWindowContentOverlay.setBounds(0, n, this.getWidth(), n + this.mWindowContentOverlay.getIntrinsicHeight());
            this.mWindowContentOverlay.draw(canvas);
        }
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    public int getActionBarHideOffset() {
        if (this.mActionBarTop != null) {
            return -((int)this.mActionBarTop.getTranslationY());
        }
        return 0;
    }

    @Override
    public CharSequence getTitle() {
        this.pullChildren();
        return this.mDecorToolbar.getTitle();
    }

    @Override
    public boolean hasIcon() {
        this.pullChildren();
        return this.mDecorToolbar.hasIcon();
    }

    @Override
    public boolean hasLogo() {
        this.pullChildren();
        return this.mDecorToolbar.hasLogo();
    }

    @Override
    public boolean hideOverflowMenu() {
        this.pullChildren();
        return this.mDecorToolbar.hideOverflowMenu();
    }

    @Override
    public void initFeature(int n) {
        this.pullChildren();
        switch (n) {
            default: {
                return;
            }
            case 2: {
                this.mDecorToolbar.initProgress();
                return;
            }
            case 5: {
                this.mDecorToolbar.initIndeterminateProgress();
                return;
            }
            case 9: 
        }
        this.setOverlayMode(true);
    }

    public boolean isHideOnContentScrollEnabled() {
        return this.mHideOnContentScroll;
    }

    public boolean isInOverlayMode() {
        return this.mOverlayMode;
    }

    @Override
    public boolean isOverflowMenuShowPending() {
        this.pullChildren();
        return this.mDecorToolbar.isOverflowMenuShowPending();
    }

    @Override
    public boolean isOverflowMenuShowing() {
        this.pullChildren();
        return this.mDecorToolbar.isOverflowMenuShowing();
    }

    @Override
    public WindowInsets onApplyWindowInsets(WindowInsets windowInsets) {
        this.pullChildren();
        if ((0x100 & this.getWindowSystemUiVisibility()) != 0) {
            // empty if block
        }
        Rect rect = windowInsets.getSystemWindowInsets();
        boolean bl = this.applyInsets(this.mActionBarTop, rect, true, true, false, true);
        if (this.mActionBarBottom != null) {
            bl |= this.applyInsets(this.mActionBarBottom, rect, true, false, true, true);
        }
        this.mBaseInnerInsets.set(rect);
        this.computeFitSystemWindows(this.mBaseInnerInsets, this.mBaseContentInsets);
        if (!this.mLastBaseContentInsets.equals(this.mBaseContentInsets)) {
            bl = true;
            this.mLastBaseContentInsets.set(this.mBaseContentInsets);
        }
        if (bl) {
            this.requestLayout();
        }
        return WindowInsets.CONSUMED;
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.init(this.getContext());
        this.requestApplyInsets();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.haltActionBarHideOffsetAnimations();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getChildCount();
        int n6 = this.getPaddingLeft();
        int cfr_ignored_0 = n3 - n - this.getPaddingRight();
        int n7 = this.getPaddingTop();
        int n8 = n4 - n2 - this.getPaddingBottom();
        int n9 = 0;
        while (n9 < n5) {
            View view = this.getChildAt(n9);
            if (view.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                int n10 = view.getMeasuredWidth();
                int n11 = view.getMeasuredHeight();
                int n12 = n6 + layoutParams.leftMargin;
                int n13 = view == this.mActionBarBottom ? n8 - n11 - layoutParams.bottomMargin : n7 + layoutParams.topMargin;
                view.layout(n12, n13, n12 + n10, n13 + n11);
            }
            ++n9;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        boolean bl;
        this.pullChildren();
        this.measureChildWithMargins(this.mActionBarTop, n, 0, n2, 0);
        LayoutParams layoutParams = (LayoutParams)this.mActionBarTop.getLayoutParams();
        int n4 = Math.max(0, this.mActionBarTop.getMeasuredWidth() + layoutParams.leftMargin + layoutParams.rightMargin);
        int n5 = Math.max(0, this.mActionBarTop.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin);
        int n6 = ActionBarOverlayLayout.combineMeasuredStates(0, this.mActionBarTop.getMeasuredState());
        if (this.mActionBarBottom != null) {
            this.measureChildWithMargins(this.mActionBarBottom, n, 0, n2, 0);
            LayoutParams layoutParams2 = (LayoutParams)this.mActionBarBottom.getLayoutParams();
            n4 = Math.max(n4, this.mActionBarBottom.getMeasuredWidth() + layoutParams2.leftMargin + layoutParams2.rightMargin);
            n5 = Math.max(n5, this.mActionBarBottom.getMeasuredHeight() + layoutParams2.topMargin + layoutParams2.bottomMargin);
            n6 = ActionBarOverlayLayout.combineMeasuredStates(n6, this.mActionBarBottom.getMeasuredState());
        }
        if (bl = (0x100 & this.getWindowSystemUiVisibility()) != 0) {
            n3 = this.mActionBarHeight;
            if (this.mHasNonEmbeddedTabs && this.mActionBarTop.getTabContainer() != null) {
                n3 += this.mActionBarHeight;
            }
        } else {
            int n7 = this.mActionBarTop.getVisibility();
            n3 = 0;
            if (n7 != 8) {
                n3 = this.mActionBarTop.getMeasuredHeight();
            }
        }
        boolean bl2 = this.mDecorToolbar.isSplit();
        int n8 = 0;
        if (bl2) {
            ActionBarContainer actionBarContainer = this.mActionBarBottom;
            n8 = 0;
            if (actionBarContainer != null) {
                n8 = bl ? this.mActionBarHeight : this.mActionBarBottom.getMeasuredHeight();
            }
        }
        this.mContentInsets.set(this.mBaseContentInsets);
        this.mInnerInsets.set(this.mBaseInnerInsets);
        if (!this.mOverlayMode && !bl) {
            Rect rect = this.mContentInsets;
            rect.top = n3 + rect.top;
            Rect rect2 = this.mContentInsets;
            rect2.bottom = n8 + rect2.bottom;
        } else {
            Rect rect = this.mInnerInsets;
            rect.top = n3 + rect.top;
            Rect rect3 = this.mInnerInsets;
            rect3.bottom = n8 + rect3.bottom;
        }
        this.applyInsets(this.mContent, this.mContentInsets, true, true, true, true);
        if (!this.mLastInnerInsets.equals(this.mInnerInsets)) {
            this.mLastInnerInsets.set(this.mInnerInsets);
            this.mContent.dispatchApplyWindowInsets(new WindowInsets(this.mInnerInsets));
        }
        this.measureChildWithMargins(this.mContent, n, 0, n2, 0);
        LayoutParams layoutParams3 = (LayoutParams)this.mContent.getLayoutParams();
        int n9 = Math.max(n4, this.mContent.getMeasuredWidth() + layoutParams3.leftMargin + layoutParams3.rightMargin);
        int n10 = Math.max(n5, this.mContent.getMeasuredHeight() + layoutParams3.topMargin + layoutParams3.bottomMargin);
        int n11 = ActionBarOverlayLayout.combineMeasuredStates(n6, this.mContent.getMeasuredState());
        int n12 = n9 + (this.getPaddingLeft() + this.getPaddingRight());
        int n13 = Math.max(n10 + (this.getPaddingTop() + this.getPaddingBottom()), this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(ActionBarOverlayLayout.resolveSizeAndState(Math.max(n12, this.getSuggestedMinimumWidth()), n, n11), ActionBarOverlayLayout.resolveSizeAndState(n13, n2, n11 << 16));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        if (!this.mHideOnContentScroll || !bl) {
            return false;
        }
        if (this.shouldHideActionBarOnFling(f, f2)) {
            this.addActionBarHideOffset();
        } else {
            this.removeActionBarHideOffset();
        }
        this.mAnimatingForFling = true;
        return true;
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4) {
        this.mHideOnContentScrollReference = n2 + this.mHideOnContentScrollReference;
        this.setActionBarHideOffset(this.mHideOnContentScrollReference);
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n) {
        super.onNestedScrollAccepted(view, view2, n);
        this.mHideOnContentScrollReference = this.getActionBarHideOffset();
        this.haltActionBarHideOffsetAnimations();
        if (this.mActionBarVisibilityCallback != null) {
            this.mActionBarVisibilityCallback.onContentScrollStarted();
        }
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n) {
        if ((n & 2) == 0 || this.mActionBarTop.getVisibility() != 0) {
            return false;
        }
        return this.mHideOnContentScroll;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onStopNestedScroll(View view) {
        super.onStopNestedScroll(view);
        if (this.mHideOnContentScroll && !this.mAnimatingForFling) {
            if (this.mHideOnContentScrollReference <= this.mActionBarTop.getHeight()) {
                this.postRemoveActionBarHideOffset();
            } else {
                this.postAddActionBarHideOffset();
            }
        }
        if (this.mActionBarVisibilityCallback != null) {
            this.mActionBarVisibilityCallback.onContentScrollStopped();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onWindowSystemUiVisibilityChanged(int n) {
        boolean bl = true;
        super.onWindowSystemUiVisibilityChanged(n);
        this.pullChildren();
        int n2 = n ^ this.mLastSystemUiVisibility;
        this.mLastSystemUiVisibility = n;
        boolean bl2 = (n & 4) == 0 ? bl : false;
        boolean bl3 = (n & 0x100) != 0 ? bl : false;
        if (this.mActionBarVisibilityCallback != null) {
            ActionBarVisibilityCallback actionBarVisibilityCallback = this.mActionBarVisibilityCallback;
            if (bl3) {
                bl = false;
            }
            actionBarVisibilityCallback.enableContentAnimations(bl);
            if (bl2 || !bl3) {
                this.mActionBarVisibilityCallback.showForSystem();
            } else {
                this.mActionBarVisibilityCallback.hideForSystem();
            }
        }
        if ((n2 & 0x100) != 0 && this.mActionBarVisibilityCallback != null) {
            this.requestApplyInsets();
        }
    }

    @Override
    protected void onWindowVisibilityChanged(int n) {
        super.onWindowVisibilityChanged(n);
        this.mWindowVisibility = n;
        if (this.mActionBarVisibilityCallback != null) {
            this.mActionBarVisibilityCallback.onWindowVisibilityChanged(n);
        }
    }

    void pullChildren() {
        if (this.mContent == null) {
            this.mContent = this.findViewById(0x1020002);
            this.mActionBarTop = (ActionBarContainer)this.findViewById(16909234);
            this.mDecorToolbar = this.getDecorToolbar(this.findViewById(16909235));
            this.mActionBarBottom = (ActionBarContainer)this.findViewById(16909237);
        }
    }

    @Override
    public void restoreToolbarHierarchyState(SparseArray<Parcelable> sparseArray) {
        this.pullChildren();
        this.mDecorToolbar.restoreHierarchyState(sparseArray);
    }

    @Override
    public void saveToolbarHierarchyState(SparseArray<Parcelable> sparseArray) {
        this.pullChildren();
        this.mDecorToolbar.saveHierarchyState(sparseArray);
    }

    public void setActionBarHideOffset(int n) {
        this.haltActionBarHideOffsetAnimations();
        int n2 = this.mActionBarTop.getHeight();
        int n3 = Math.max(0, Math.min(n, n2));
        this.mActionBarTop.setTranslationY(-n3);
        if (this.mActionBarBottom != null && this.mActionBarBottom.getVisibility() != 8) {
            int n4 = (int)((float)n3 / (float)n2 * (float)this.mActionBarBottom.getHeight());
            this.mActionBarBottom.setTranslationY(n4);
        }
    }

    public void setActionBarVisibilityCallback(ActionBarVisibilityCallback actionBarVisibilityCallback) {
        this.mActionBarVisibilityCallback = actionBarVisibilityCallback;
        if (this.getWindowToken() != null) {
            this.mActionBarVisibilityCallback.onWindowVisibilityChanged(this.mWindowVisibility);
            if (this.mLastSystemUiVisibility != 0) {
                this.onWindowSystemUiVisibilityChanged(this.mLastSystemUiVisibility);
                this.requestApplyInsets();
            }
        }
    }

    public void setHasNonEmbeddedTabs(boolean bl) {
        this.mHasNonEmbeddedTabs = bl;
    }

    public void setHideOnContentScrollEnabled(boolean bl) {
        if (bl != this.mHideOnContentScroll) {
            this.mHideOnContentScroll = bl;
            if (!bl) {
                this.stopNestedScroll();
                this.haltActionBarHideOffsetAnimations();
                this.setActionBarHideOffset(0);
            }
        }
    }

    @Override
    public void setIcon(int n) {
        this.pullChildren();
        this.mDecorToolbar.setIcon(n);
    }

    @Override
    public void setIcon(Drawable drawable2) {
        this.pullChildren();
        this.mDecorToolbar.setIcon(drawable2);
    }

    @Override
    public void setLogo(int n) {
        this.pullChildren();
        this.mDecorToolbar.setLogo(n);
    }

    @Override
    public void setMenu(Menu menu2, MenuPresenter.Callback callback) {
        this.pullChildren();
        this.mDecorToolbar.setMenu(menu2, callback);
    }

    @Override
    public void setMenuPrepared() {
        this.pullChildren();
        this.mDecorToolbar.setMenuPrepared();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setOverlayMode(boolean bl) {
        this.mOverlayMode = bl;
        boolean bl2 = bl && this.getContext().getApplicationInfo().targetSdkVersion < 19;
        this.mIgnoreWindowContentOverlay = bl2;
    }

    public void setShowingForActionMode(boolean bl) {
        if (bl) {
            if ((0x500 & this.getWindowSystemUiVisibility()) == 1280) {
                this.setDisabledSystemUiVisibility(4);
            }
            return;
        }
        this.setDisabledSystemUiVisibility(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setUiOptions(int n) {
        if ((n & 1) == 0) return;
        boolean bl = true;
        boolean bl2 = false;
        if (bl) {
            bl2 = this.getContext().getResources().getBoolean(17956870);
        }
        if (!bl2) return;
        this.pullChildren();
        if (this.mActionBarBottom != null && this.mDecorToolbar.canSplit()) {
            this.mDecorToolbar.setSplitView(this.mActionBarBottom);
            this.mDecorToolbar.setSplitToolbar(bl2);
            this.mDecorToolbar.setSplitWhenNarrow(bl);
            ActionBarContextView actionBarContextView = (ActionBarContextView)this.findViewById(16909236);
            actionBarContextView.setSplitView(this.mActionBarBottom);
            actionBarContextView.setSplitToolbar(bl2);
            actionBarContextView.setSplitWhenNarrow(bl);
            return;
        }
        if (!bl2) return;
        Log.e(TAG, "Requested split action bar with incompatible window decor! Ignoring request.");
    }

    @Override
    public void setWindowCallback(Window.Callback callback) {
        this.pullChildren();
        this.mDecorToolbar.setWindowCallback(callback);
    }

    @Override
    public void setWindowTitle(CharSequence charSequence) {
        this.pullChildren();
        this.mDecorToolbar.setWindowTitle(charSequence);
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return false;
    }

    @Override
    public boolean showOverflowMenu() {
        this.pullChildren();
        return this.mDecorToolbar.showOverflowMenu();
    }

    public static interface ActionBarVisibilityCallback {
        public void enableContentAnimations(boolean var1);

        public void hideForSystem();

        public void onContentScrollStarted();

        public void onContentScrollStopped();

        public void onWindowVisibilityChanged(int var1);

        public void showForSystem();
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }
    }
}

