/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.DecelerateInterpolator;
import android.widget.ActionMenuPresenter;
import android.widget.ActionMenuView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.widget.AbsActionBarView;

public class ActionBarContextView
extends AbsActionBarView
implements Animator.AnimatorListener {
    private static final int ANIMATE_IDLE = 0;
    private static final int ANIMATE_IN = 1;
    private static final int ANIMATE_OUT = 2;
    private static final String TAG = "ActionBarContextView";
    private boolean mAnimateInOnLayout;
    private int mAnimationMode;
    private View mClose;
    private int mCloseItemLayout;
    private Animator mCurrentAnimation;
    private View mCustomView;
    private Drawable mSplitBackground;
    private CharSequence mSubtitle;
    private int mSubtitleStyleRes;
    private TextView mSubtitleView;
    private CharSequence mTitle;
    private LinearLayout mTitleLayout;
    private boolean mTitleOptional;
    private int mTitleStyleRes;
    private TextView mTitleView;

    public ActionBarContextView(Context context) {
        this(context, null);
    }

    public ActionBarContextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843668);
    }

    public ActionBarContextView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public ActionBarContextView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ActionMode, n, n2);
        this.setBackground(typedArray.getDrawable(0));
        this.mTitleStyleRes = typedArray.getResourceId(2, 0);
        this.mSubtitleStyleRes = typedArray.getResourceId(3, 0);
        this.mContentHeight = typedArray.getLayoutDimension(1, 0);
        this.mSplitBackground = typedArray.getDrawable(4);
        this.mCloseItemLayout = typedArray.getResourceId(5, 17367071);
        typedArray.recycle();
    }

    private void finishAnimation() {
        Animator animator2 = this.mCurrentAnimation;
        if (animator2 != null) {
            this.mCurrentAnimation = null;
            animator2.end();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initTitle() {
        int n = 8;
        if (this.mTitleLayout == null) {
            LayoutInflater.from(this.getContext()).inflate(17367066, (ViewGroup)this);
            this.mTitleLayout = (LinearLayout)this.getChildAt(-1 + this.getChildCount());
            this.mTitleView = (TextView)this.mTitleLayout.findViewById(16909001);
            this.mSubtitleView = (TextView)this.mTitleLayout.findViewById(16909002);
            if (this.mTitleStyleRes != 0) {
                this.mTitleView.setTextAppearance(this.mContext, this.mTitleStyleRes);
            }
            if (this.mSubtitleStyleRes != 0) {
                this.mSubtitleView.setTextAppearance(this.mContext, this.mSubtitleStyleRes);
            }
        }
        this.mTitleView.setText(this.mTitle);
        this.mSubtitleView.setText(this.mSubtitle);
        boolean bl = !TextUtils.isEmpty(this.mTitle);
        boolean bl2 = !TextUtils.isEmpty(this.mSubtitle);
        TextView textView = this.mSubtitleView;
        int n2 = bl2 ? 0 : n;
        textView.setVisibility(n2);
        LinearLayout linearLayout = this.mTitleLayout;
        if (bl || bl2) {
            n = 0;
        }
        linearLayout.setVisibility(n);
        if (this.mTitleLayout.getParent() == null) {
            this.addView(this.mTitleLayout);
        }
    }

    private Animator makeInAnimation() {
        int n;
        this.mClose.setTranslationX(-this.mClose.getWidth() - ((ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams()).leftMargin);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.mClose, "translationX", 0.0f);
        objectAnimator.setDuration(200L);
        objectAnimator.addListener(this);
        objectAnimator.setInterpolator(new DecelerateInterpolator());
        AnimatorSet animatorSet = new AnimatorSet();
        AnimatorSet.Builder builder = animatorSet.play(objectAnimator);
        if (this.mMenuView != null && (n = this.mMenuView.getChildCount()) > 0) {
            int n2 = n - 1;
            int n3 = 0;
            while (n2 >= 0) {
                View view = this.mMenuView.getChildAt(n2);
                view.setScaleY(0.0f);
                ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)view, "scaleY", 0.0f, 1.0f);
                objectAnimator2.setDuration(300L);
                builder.with(objectAnimator2);
                --n2;
                ++n3;
            }
        }
        return animatorSet;
    }

    private Animator makeOutAnimation() {
        View view = this.mClose;
        float[] fArray = new float[]{-this.mClose.getWidth() - ((ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams()).leftMargin};
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, "translationX", fArray);
        objectAnimator.setDuration(200L);
        objectAnimator.addListener(this);
        objectAnimator.setInterpolator(new DecelerateInterpolator());
        AnimatorSet animatorSet = new AnimatorSet();
        AnimatorSet.Builder builder = animatorSet.play(objectAnimator);
        if (this.mMenuView != null && this.mMenuView.getChildCount() > 0) {
            for (int i = 0; i < 0; ++i) {
                View view2 = this.mMenuView.getChildAt(i);
                view2.setScaleY(0.0f);
                ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)view2, "scaleY", 0.0f);
                objectAnimator2.setDuration(300L);
                builder.with(objectAnimator2);
            }
        }
        return animatorSet;
    }

    public void closeMode() {
        if (this.mAnimationMode == 2) {
            return;
        }
        if (this.mClose == null) {
            this.killMode();
            return;
        }
        this.finishAnimation();
        this.mAnimationMode = 2;
        this.mCurrentAnimation = this.makeOutAnimation();
        this.mCurrentAnimation.start();
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-1, -2);
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attributeSet);
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Override
    public boolean hideOverflowMenu() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.hideOverflowMenu();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void initForMode(final ActionMode actionMode) {
        if (this.mClose == null) {
            this.mClose = LayoutInflater.from(this.mContext).inflate(this.mCloseItemLayout, (ViewGroup)this, false);
            this.addView(this.mClose);
        } else if (this.mClose.getParent() == null) {
            this.addView(this.mClose);
        }
        this.mClose.findViewById(16909003).setOnClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                actionMode.finish();
            }
        });
        MenuBuilder menuBuilder = (MenuBuilder)actionMode.getMenu();
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.dismissPopupMenus();
        }
        this.mActionMenuPresenter = new ActionMenuPresenter(this.mContext);
        this.mActionMenuPresenter.setReserveOverflow(true);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
        if (!this.mSplitActionBar) {
            menuBuilder.addMenuPresenter(this.mActionMenuPresenter, this.mPopupContext);
            this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            this.mMenuView.setBackgroundDrawable(null);
            this.addView((View)this.mMenuView, layoutParams);
        } else {
            this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
            this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
            layoutParams.width = -1;
            layoutParams.height = this.mContentHeight;
            menuBuilder.addMenuPresenter(this.mActionMenuPresenter, this.mPopupContext);
            this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            this.mMenuView.setBackgroundDrawable(this.mSplitBackground);
            this.mSplitView.addView((View)this.mMenuView, layoutParams);
        }
        this.mAnimateInOnLayout = true;
    }

    @Override
    public boolean isOverflowMenuShowing() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.isOverflowMenuShowing();
        }
        return false;
    }

    public boolean isTitleOptional() {
        return this.mTitleOptional;
    }

    public void killMode() {
        this.finishAnimation();
        this.removeAllViews();
        if (this.mSplitView != null) {
            this.mSplitView.removeView(this.mMenuView);
        }
        this.mCustomView = null;
        this.mMenuView = null;
        this.mAnimateInOnLayout = false;
    }

    @Override
    public void onAnimationCancel(Animator animator2) {
    }

    @Override
    public void onAnimationEnd(Animator animator2) {
        if (this.mAnimationMode == 2) {
            this.killMode();
        }
        this.mAnimationMode = 0;
    }

    @Override
    public void onAnimationRepeat(Animator animator2) {
    }

    @Override
    public void onAnimationStart(Animator animator2) {
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.hideOverflowMenu();
            this.mActionMenuPresenter.hideSubMenus();
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (accessibilityEvent.getEventType() == 32) {
            accessibilityEvent.setSource(this);
            accessibilityEvent.setClassName(this.getClass().getName());
            accessibilityEvent.setPackageName(this.getContext().getPackageName());
            accessibilityEvent.setContentDescription(this.mTitle);
            return;
        }
        super.onInitializeAccessibilityEvent(accessibilityEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        boolean bl2 = this.isLayoutRtl();
        int n5 = bl2 ? n3 - n - this.getPaddingRight() : this.getPaddingLeft();
        int n6 = this.getPaddingTop();
        int n7 = n4 - n2 - this.getPaddingTop() - this.getPaddingBottom();
        if (this.mClose != null && this.mClose.getVisibility() != 8) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams();
            int n8 = bl2 ? marginLayoutParams.rightMargin : marginLayoutParams.leftMargin;
            int n9 = bl2 ? marginLayoutParams.leftMargin : marginLayoutParams.rightMargin;
            int n10 = ActionBarContextView.next(n5, n8, bl2);
            n5 = ActionBarContextView.next(n10 + this.positionChild(this.mClose, n10, n6, n7, bl2), n9, bl2);
            if (this.mAnimateInOnLayout) {
                this.mAnimationMode = 1;
                this.mCurrentAnimation = this.makeInAnimation();
                this.mCurrentAnimation.start();
                this.mAnimateInOnLayout = false;
            }
        }
        if (this.mTitleLayout != null && this.mCustomView == null && this.mTitleLayout.getVisibility() != 8) {
            n5 += this.positionChild(this.mTitleLayout, n5, n6, n7, bl2);
        }
        if (this.mCustomView != null) {
            int cfr_ignored_0 = n5 + this.positionChild(this.mCustomView, n5, n6, n7, bl2);
        }
        int n11 = bl2 ? this.getPaddingLeft() : n3 - n - this.getPaddingRight();
        if (this.mMenuView != null) {
            ActionMenuView actionMenuView = this.mMenuView;
            boolean bl3 = !bl2;
            int cfr_ignored_1 = n11 + this.positionChild(actionMenuView, n11, n6, n7, bl3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        if (View.MeasureSpec.getMode(n) != 0x40000000) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with android:layout_width=\"match_parent\" (or fill_parent)");
        }
        if (View.MeasureSpec.getMode(n2) == 0) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with android:layout_height=\"wrap_content\"");
        }
        int n3 = View.MeasureSpec.getSize(n);
        int n4 = this.mContentHeight > 0 ? this.mContentHeight : View.MeasureSpec.getSize(n2);
        int n5 = this.getPaddingTop() + this.getPaddingBottom();
        int n6 = n3 - this.getPaddingLeft() - this.getPaddingRight();
        int n7 = n4 - n5;
        int n8 = View.MeasureSpec.makeMeasureSpec(n7, Integer.MIN_VALUE);
        if (this.mClose != null) {
            int n9 = this.measureChildView(this.mClose, n6, n8, 0);
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams();
            n6 = n9 - (marginLayoutParams.leftMargin + marginLayoutParams.rightMargin);
        }
        if (this.mMenuView != null && this.mMenuView.getParent() == this) {
            n6 = this.measureChildView(this.mMenuView, n6, n8, 0);
        }
        if (this.mTitleLayout != null && this.mCustomView == null) {
            if (this.mTitleOptional) {
                int n10 = View.MeasureSpec.makeMeasureSpec(0, 0);
                this.mTitleLayout.measure(n10, n8);
                int n11 = this.mTitleLayout.getMeasuredWidth();
                boolean bl = n11 <= n6;
                if (bl) {
                    n6 -= n11;
                }
                LinearLayout linearLayout = this.mTitleLayout;
                int n12 = bl ? 0 : 8;
                linearLayout.setVisibility(n12);
            } else {
                n6 = this.measureChildView(this.mTitleLayout, n6, n8, 0);
            }
        }
        if (this.mCustomView != null) {
            ViewGroup.LayoutParams layoutParams = this.mCustomView.getLayoutParams();
            int n13 = layoutParams.width != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int n14 = layoutParams.width >= 0 ? Math.min(layoutParams.width, n6) : n6;
            int n15 = layoutParams.height != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int n16 = layoutParams.height >= 0 ? Math.min(layoutParams.height, n7) : n7;
            this.mCustomView.measure(View.MeasureSpec.makeMeasureSpec(n14, n13), View.MeasureSpec.makeMeasureSpec(n16, n15));
        }
        if (this.mContentHeight > 0) {
            this.setMeasuredDimension(n3, n4);
            return;
        }
        int n17 = 0;
        int n18 = this.getChildCount();
        int n19 = 0;
        while (true) {
            if (n19 >= n18) {
                this.setMeasuredDimension(n3, n17);
                return;
            }
            int n20 = n5 + this.getChildAt(n19).getMeasuredHeight();
            if (n20 > n17) {
                n17 = n20;
            }
            ++n19;
        }
    }

    @Override
    public void setContentHeight(int n) {
        this.mContentHeight = n;
    }

    public void setCustomView(View view) {
        if (this.mCustomView != null) {
            this.removeView(this.mCustomView);
        }
        this.mCustomView = view;
        if (this.mTitleLayout != null) {
            this.removeView(this.mTitleLayout);
            this.mTitleLayout = null;
        }
        if (view != null) {
            this.addView(view);
        }
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSplitToolbar(boolean bl) {
        if (this.mSplitActionBar != bl) {
            if (this.mActionMenuPresenter != null) {
                ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
                if (!bl) {
                    this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
                    this.mMenuView.setBackground(null);
                    ViewGroup viewGroup = (ViewGroup)this.mMenuView.getParent();
                    if (viewGroup != null) {
                        viewGroup.removeView(this.mMenuView);
                    }
                    this.addView((View)this.mMenuView, layoutParams);
                } else {
                    this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
                    this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
                    layoutParams.width = -1;
                    layoutParams.height = this.mContentHeight;
                    this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
                    this.mMenuView.setBackground(this.mSplitBackground);
                    ViewGroup viewGroup = (ViewGroup)this.mMenuView.getParent();
                    if (viewGroup != null) {
                        viewGroup.removeView(this.mMenuView);
                    }
                    this.mSplitView.addView((View)this.mMenuView, layoutParams);
                }
            }
            super.setSplitToolbar(bl);
        }
    }

    public void setSubtitle(CharSequence charSequence) {
        this.mSubtitle = charSequence;
        this.initTitle();
    }

    public void setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        this.initTitle();
    }

    public void setTitleOptional(boolean bl) {
        if (bl != this.mTitleOptional) {
            this.requestLayout();
        }
        this.mTitleOptional = bl;
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return false;
    }

    @Override
    public boolean showOverflowMenu() {
        if (this.mActionMenuPresenter != null) {
            return this.mActionMenuPresenter.showOverflowMenu();
        }
        return false;
    }
}

