/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedTextRequest;
import com.android.internal.view.IInputContextCallback;

public interface IInputContext
extends IInterface {
    public void beginBatchEdit() throws RemoteException;

    public void clearMetaKeyStates(int var1) throws RemoteException;

    public void commitCompletion(CompletionInfo var1) throws RemoteException;

    public void commitCorrection(CorrectionInfo var1) throws RemoteException;

    public void commitText(CharSequence var1, int var2) throws RemoteException;

    public void deleteSurroundingText(int var1, int var2) throws RemoteException;

    public void endBatchEdit() throws RemoteException;

    public void finishComposingText() throws RemoteException;

    public void getCursorCapsMode(int var1, int var2, IInputContextCallback var3) throws RemoteException;

    public void getExtractedText(ExtractedTextRequest var1, int var2, int var3, IInputContextCallback var4) throws RemoteException;

    public void getSelectedText(int var1, int var2, IInputContextCallback var3) throws RemoteException;

    public void getTextAfterCursor(int var1, int var2, int var3, IInputContextCallback var4) throws RemoteException;

    public void getTextBeforeCursor(int var1, int var2, int var3, IInputContextCallback var4) throws RemoteException;

    public void performContextMenuAction(int var1) throws RemoteException;

    public void performEditorAction(int var1) throws RemoteException;

    public void performPrivateCommand(String var1, Bundle var2) throws RemoteException;

    public void reportFullscreenMode(boolean var1) throws RemoteException;

    public void requestUpdateCursorAnchorInfo(int var1, int var2, IInputContextCallback var3) throws RemoteException;

    public void sendKeyEvent(KeyEvent var1) throws RemoteException;

    public void setComposingRegion(int var1, int var2) throws RemoteException;

    public void setComposingText(CharSequence var1, int var2) throws RemoteException;

    public void setSelection(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputContext {
        private static final String DESCRIPTOR = "com.android.internal.view.IInputContext";
        static final int TRANSACTION_beginBatchEdit = 14;
        static final int TRANSACTION_clearMetaKeyStates = 18;
        static final int TRANSACTION_commitCompletion = 9;
        static final int TRANSACTION_commitCorrection = 10;
        static final int TRANSACTION_commitText = 8;
        static final int TRANSACTION_deleteSurroundingText = 5;
        static final int TRANSACTION_endBatchEdit = 15;
        static final int TRANSACTION_finishComposingText = 7;
        static final int TRANSACTION_getCursorCapsMode = 3;
        static final int TRANSACTION_getExtractedText = 4;
        static final int TRANSACTION_getSelectedText = 21;
        static final int TRANSACTION_getTextAfterCursor = 2;
        static final int TRANSACTION_getTextBeforeCursor = 1;
        static final int TRANSACTION_performContextMenuAction = 13;
        static final int TRANSACTION_performEditorAction = 12;
        static final int TRANSACTION_performPrivateCommand = 19;
        static final int TRANSACTION_reportFullscreenMode = 16;
        static final int TRANSACTION_requestUpdateCursorAnchorInfo = 22;
        static final int TRANSACTION_sendKeyEvent = 17;
        static final int TRANSACTION_setComposingRegion = 20;
        static final int TRANSACTION_setComposingText = 6;
        static final int TRANSACTION_setSelection = 11;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInputContext asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IInputContext) {
                return (IInputContext)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.getTextBeforeCursor(parcel.readInt(), parcel.readInt(), parcel.readInt(), IInputContextCallback.Stub.asInterface(parcel.readStrongBinder()));
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.getTextAfterCursor(parcel.readInt(), parcel.readInt(), parcel.readInt(), IInputContextCallback.Stub.asInterface(parcel.readStrongBinder()));
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.getCursorCapsMode(parcel.readInt(), parcel.readInt(), IInputContextCallback.Stub.asInterface(parcel.readStrongBinder()));
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ExtractedTextRequest extractedTextRequest = parcel.readInt() != 0 ? ExtractedTextRequest.CREATOR.createFromParcel(parcel) : null;
                    this.getExtractedText(extractedTextRequest, parcel.readInt(), parcel.readInt(), IInputContextCallback.Stub.asInterface(parcel.readStrongBinder()));
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.deleteSurroundingText(parcel.readInt(), parcel.readInt());
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    CharSequence charSequence = parcel.readInt() != 0 ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel) : null;
                    this.setComposingText(charSequence, parcel.readInt());
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.finishComposingText();
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    CharSequence charSequence = parcel.readInt() != 0 ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel) : null;
                    this.commitText(charSequence, parcel.readInt());
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    CompletionInfo completionInfo = parcel.readInt() != 0 ? CompletionInfo.CREATOR.createFromParcel(parcel) : null;
                    this.commitCompletion(completionInfo);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    CorrectionInfo correctionInfo = parcel.readInt() != 0 ? CorrectionInfo.CREATOR.createFromParcel(parcel) : null;
                    this.commitCorrection(correctionInfo);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setSelection(parcel.readInt(), parcel.readInt());
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.performEditorAction(parcel.readInt());
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.performContextMenuAction(parcel.readInt());
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.beginBatchEdit();
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.endBatchEdit();
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.reportFullscreenMode(bl);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    KeyEvent keyEvent = parcel.readInt() != 0 ? KeyEvent.CREATOR.createFromParcel(parcel) : null;
                    this.sendKeyEvent(keyEvent);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearMetaKeyStates(parcel.readInt());
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.performPrivateCommand(string2, bundle);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setComposingRegion(parcel.readInt(), parcel.readInt());
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.getSelectedText(parcel.readInt(), parcel.readInt(), IInputContextCallback.Stub.asInterface(parcel.readStrongBinder()));
                    return true;
                }
                case 22: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.requestUpdateCursorAnchorInfo(parcel.readInt(), parcel.readInt(), IInputContextCallback.Stub.asInterface(parcel.readStrongBinder()));
            return true;
        }

        private static class Proxy
        implements IInputContext {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void beginBatchEdit() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(14, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void clearMetaKeyStates(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(18, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void commitCompletion(CompletionInfo completionInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (completionInfo != null) {
                        parcel.writeInt(1);
                        completionInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(9, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void commitCorrection(CorrectionInfo correctionInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (correctionInfo != null) {
                        parcel.writeInt(1);
                        correctionInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(10, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void commitText(CharSequence charSequence, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (charSequence != null) {
                        parcel.writeInt(1);
                        TextUtils.writeToParcel(charSequence, parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(8, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void deleteSurroundingText(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void endBatchEdit() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(15, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void finishComposingText() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void getCursorCapsMode(int n, int n2, IInputContextCallback iInputContextCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    IBinder iBinder = null;
                    if (iInputContextCallback != null) {
                        iBinder = iInputContextCallback.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void getExtractedText(ExtractedTextRequest extractedTextRequest, int n, int n2, IInputContextCallback iInputContextCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (extractedTextRequest != null) {
                        parcel.writeInt(1);
                        extractedTextRequest.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    IBinder iBinder = null;
                    if (iInputContextCallback != null) {
                        iBinder = iInputContextCallback.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void getSelectedText(int n, int n2, IInputContextCallback iInputContextCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    IBinder iBinder = null;
                    if (iInputContextCallback != null) {
                        iBinder = iInputContextCallback.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(21, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void getTextAfterCursor(int n, int n2, int n3, IInputContextCallback iInputContextCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    IBinder iBinder = null;
                    if (iInputContextCallback != null) {
                        iBinder = iInputContextCallback.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void getTextBeforeCursor(int n, int n2, int n3, IInputContextCallback iInputContextCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    IBinder iBinder = null;
                    if (iInputContextCallback != null) {
                        iBinder = iInputContextCallback.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void performContextMenuAction(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(13, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void performEditorAction(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(12, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void performPrivateCommand(String string2, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(19, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void reportFullscreenMode(boolean bl) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(16, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void requestUpdateCursorAnchorInfo(int n, int n2, IInputContextCallback iInputContextCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    IBinder iBinder = null;
                    if (iInputContextCallback != null) {
                        iBinder = iInputContextCallback.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(22, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void sendKeyEvent(KeyEvent keyEvent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (keyEvent != null) {
                        parcel.writeInt(1);
                        keyEvent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(17, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setComposingRegion(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(20, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setComposingText(CharSequence charSequence, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (charSequence != null) {
                        parcel.writeInt(1);
                        TextUtils.writeToParcel(charSequence, parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setSelection(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(11, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

