/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.Debug;
import android.os.StrictMode;

public final class MemInfoReader {
    final long[] mInfos = new long[9];

    public long getBuffersSizeKb() {
        return this.mInfos[2];
    }

    public long getCachedSize() {
        return 1024L * this.mInfos[3];
    }

    public long getCachedSizeKb() {
        return this.mInfos[3];
    }

    public long getFreeSize() {
        return 1024L * this.mInfos[1];
    }

    public long getFreeSizeKb() {
        return this.mInfos[1];
    }

    public long getShmemSizeKb() {
        return this.mInfos[4];
    }

    public long getSlabSizeKb() {
        return this.mInfos[5];
    }

    public long getSwapFreeSizeKb() {
        return this.mInfos[7];
    }

    public long getSwapTotalSizeKb() {
        return this.mInfos[6];
    }

    public long getTotalSize() {
        return 1024L * this.mInfos[0];
    }

    public long getTotalSizeKb() {
        return this.mInfos[0];
    }

    public long getZramTotalSizeKb() {
        return this.mInfos[8];
    }

    public void readMemInfo() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            Debug.getMemInfo(this.mInfos);
            return;
        }
        finally {
            StrictMode.setThreadPolicy(threadPolicy);
        }
    }
}

