/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.util.Printer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class FastPrintWriter
extends PrintWriter {
    private static Writer sDummyWriter = new Writer(){

        @Override
        public void close() throws IOException {
            throw new UnsupportedOperationException("Shouldn't be here");
        }

        @Override
        public void flush() throws IOException {
            this.close();
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            this.close();
        }
    };
    private final boolean mAutoFlush;
    private final int mBufferLen;
    private final ByteBuffer mBytes;
    private CharsetEncoder mCharset;
    private boolean mIoError;
    private final OutputStream mOutputStream;
    private int mPos;
    private final Printer mPrinter;
    private final String mSeparator;
    private final char[] mText;
    private final Writer mWriter;

    public FastPrintWriter(Printer printer) {
        this(printer, 512);
    }

    public FastPrintWriter(Printer printer, int n) {
        super(sDummyWriter, true);
        if (printer == null) {
            throw new NullPointerException("pr is null");
        }
        this.mBufferLen = n;
        this.mText = new char[n];
        this.mBytes = null;
        this.mOutputStream = null;
        this.mWriter = null;
        this.mPrinter = printer;
        this.mAutoFlush = true;
        this.mSeparator = System.lineSeparator();
        this.initDefaultEncoder();
    }

    public FastPrintWriter(OutputStream outputStream) {
        this(outputStream, false, 8192);
    }

    public FastPrintWriter(OutputStream outputStream, boolean bl) {
        this(outputStream, bl, 8192);
    }

    public FastPrintWriter(OutputStream outputStream, boolean bl, int n) {
        super(sDummyWriter, bl);
        if (outputStream == null) {
            throw new NullPointerException("out is null");
        }
        this.mBufferLen = n;
        this.mText = new char[n];
        this.mBytes = ByteBuffer.allocate(this.mBufferLen);
        this.mOutputStream = outputStream;
        this.mWriter = null;
        this.mPrinter = null;
        this.mAutoFlush = bl;
        this.mSeparator = System.lineSeparator();
        this.initDefaultEncoder();
    }

    public FastPrintWriter(Writer writer) {
        this(writer, false, 8192);
    }

    public FastPrintWriter(Writer writer, boolean bl) {
        this(writer, bl, 8192);
    }

    public FastPrintWriter(Writer writer, boolean bl, int n) {
        super(sDummyWriter, bl);
        if (writer == null) {
            throw new NullPointerException("wr is null");
        }
        this.mBufferLen = n;
        this.mText = new char[n];
        this.mBytes = null;
        this.mOutputStream = null;
        this.mWriter = writer;
        this.mPrinter = null;
        this.mAutoFlush = bl;
        this.mSeparator = System.lineSeparator();
        this.initDefaultEncoder();
    }

    private void appendLocked(char c) throws IOException {
        int n = this.mPos;
        if (n >= -1 + this.mBufferLen) {
            this.flushLocked();
            n = this.mPos;
        }
        this.mText[n] = c;
        this.mPos = n + 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void appendLocked(String string2, int n, int n2) throws IOException {
        int n3 = this.mBufferLen;
        if (n2 <= n3) {
            int n4 = this.mPos;
            if (n4 + n2 > n3) {
                this.flushLocked();
                n4 = this.mPos;
            }
            string2.getChars(n, n + n2, this.mText, n4);
            this.mPos = n4 + n2;
            return;
        } else {
            int n5 = n + n2;
            while (n < n5) {
                int n6 = n + n3;
                int n7 = n6 < n5 ? n3 : n5 - n;
                this.appendLocked(string2, n, n7);
                n = n6;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void appendLocked(char[] cArray, int n, int n2) throws IOException {
        int n3 = this.mBufferLen;
        if (n2 <= n3) {
            int n4 = this.mPos;
            if (n4 + n2 > n3) {
                this.flushLocked();
                n4 = this.mPos;
            }
            System.arraycopy((char[])cArray, (int)n, (char[])this.mText, (int)n4, (int)n2);
            this.mPos = n4 + n2;
            return;
        } else {
            int n5 = n + n2;
            while (n < n5) {
                int n6 = n + n3;
                int n7 = n6 < n5 ? n3 : n5 - n;
                this.appendLocked(cArray, n, n7);
                n = n6;
            }
        }
    }

    private void flushBytesLocked() throws IOException {
        int n = this.mBytes.position();
        if (n > 0) {
            this.mBytes.flip();
            this.mOutputStream.write(this.mBytes.array(), 0, n);
            this.mBytes.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void flushLocked() throws IOException {
        block10: {
            block9: {
                block11: {
                    if (this.mPos <= 0) break block10;
                    if (this.mOutputStream != null) break block11;
                    if (this.mWriter != null) {
                        this.mWriter.write(this.mText, 0, this.mPos);
                        this.mWriter.flush();
                        break block9;
                    } else {
                        int n;
                        int n2 = 0;
                        int n3 = this.mSeparator.length();
                        if (n3 < this.mPos) {
                            n = n3;
                        } else {
                            n = this.mPos;
                            n2 = 0;
                        }
                        while (n2 < n && this.mText[-1 + this.mPos - n2] == this.mSeparator.charAt(-1 + this.mSeparator.length() - n2)) {
                            ++n2;
                        }
                        if (n2 >= this.mPos) {
                            this.mPrinter.println("");
                            break block9;
                        } else {
                            this.mPrinter.println(new String(this.mText, 0, this.mPos - n2));
                        }
                    }
                    break block9;
                }
                CharBuffer charBuffer = CharBuffer.wrap(this.mText, 0, this.mPos);
                CoderResult coderResult = this.mCharset.encode(charBuffer, this.mBytes, true);
                while (true) {
                    if (coderResult.isError()) {
                        throw new IOException(coderResult.toString());
                    }
                    if (!coderResult.isOverflow()) break;
                    this.flushBytesLocked();
                    coderResult = this.mCharset.encode(charBuffer, this.mBytes, true);
                }
                this.flushBytesLocked();
                this.mOutputStream.flush();
            }
            this.mPos = 0;
        }
    }

    private final void initDefaultEncoder() {
        this.mCharset = Charset.defaultCharset().newEncoder();
        this.mCharset.onMalformedInput(CodingErrorAction.REPLACE);
        this.mCharset.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    private final void initEncoder(String string2) throws UnsupportedEncodingException {
        try {
            this.mCharset = Charset.forName(string2).newEncoder();
            this.mCharset.onMalformedInput(CodingErrorAction.REPLACE);
        }
        catch (Exception exception) {
            throw new UnsupportedEncodingException(string2);
        }
        this.mCharset.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    @Override
    public PrintWriter append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            charSequence = "null";
        }
        String string2 = charSequence.subSequence(n, n2).toString();
        this.write(string2, 0, string2.length());
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkError() {
        this.flush();
        Object object = this.lock;
        synchronized (object) {
            return this.mIoError;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void clearError() {
        Object object = this.lock;
        synchronized (object) {
            this.mIoError = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            block6: {
                try {
                    this.flushLocked();
                    if (this.mOutputStream != null) {
                        this.mOutputStream.close();
                        break block6;
                    }
                    if (this.mWriter != null) {
                        this.mWriter.close();
                    }
                }
                catch (IOException iOException) {
                    this.setError();
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            block6: {
                try {
                    this.flushLocked();
                    if (this.mOutputStream != null) {
                        this.mOutputStream.flush();
                        break block6;
                    }
                    if (this.mWriter != null) {
                        this.mWriter.flush();
                    }
                }
                catch (IOException iOException) {
                    this.setError();
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void print(char c) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(c);
            }
            catch (IOException iOException) {}
            return;
        }
    }

    @Override
    public void print(int n) {
        if (n == 0) {
            this.print("0");
            return;
        }
        super.print(n);
    }

    @Override
    public void print(long l) {
        if (l == 0L) {
            this.print("0");
            return;
        }
        super.print(l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void print(String string2) {
        if (string2 == null) {
            string2 = String.valueOf((Object)null);
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(string2, 0, string2.length());
            }
            catch (IOException iOException) {
                this.setError();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void print(char[] cArray) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(cArray, 0, cArray.length);
            }
            catch (IOException iOException) {}
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(this.mSeparator, 0, this.mSeparator.length());
                if (this.mAutoFlush) {
                    this.flushLocked();
                }
            }
            catch (IOException iOException) {
                this.setError();
            }
            return;
        }
    }

    @Override
    public void println(char c) {
        this.print(c);
        this.println();
    }

    @Override
    public void println(int n) {
        if (n == 0) {
            this.println("0");
            return;
        }
        super.println(n);
    }

    @Override
    public void println(long l) {
        if (l == 0L) {
            this.println("0");
            return;
        }
        super.println(l);
    }

    @Override
    public void println(char[] cArray) {
        this.print(cArray);
        this.println();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void setError() {
        Object object = this.lock;
        synchronized (object) {
            this.mIoError = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(int n) {
        Object object = this.lock;
        synchronized (object) {
            char c = (char)n;
            try {
                this.appendLocked(c);
            }
            catch (IOException iOException) {}
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(String string2) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(string2, 0, string2.length());
            }
            catch (IOException iOException) {}
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(String string2, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(string2, n, n2);
            }
            catch (IOException iOException) {}
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(char[] cArray, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(cArray, n, n2);
            }
            catch (IOException iOException) {}
            return;
        }
    }
}

