/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.util.ArraySet;
import dalvik.system.VMRuntime;
import java.lang.reflect.Array;
import java.util.ArrayList;
import libcore.util.EmptyArray;

public class ArrayUtils {
    private static final int CACHE_SIZE = 73;
    private static Object[] sCache = new Object[73];

    private ArrayUtils() {
    }

    public static <T> ArraySet<T> add(ArraySet<T> arraySet, T t) {
        if (arraySet == null) {
            arraySet = new ArraySet();
        }
        arraySet.add(t);
        return arraySet;
    }

    public static <T> ArrayList<T> add(ArrayList<T> arrayList, T t) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        arrayList.add(t);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> T[] appendElement(Class<T> clazz, T[] TArray, T t) {
        Object[] objectArray;
        int n;
        if (TArray != null) {
            n = TArray.length;
            objectArray = (Object[])Array.newInstance(clazz, n + 1);
            System.arraycopy(TArray, 0, objectArray, 0, n);
        } else {
            objectArray = (Object[])Array.newInstance(clazz, 1);
            n = 0;
        }
        objectArray[n] = t;
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int[] appendInt(int[] nArray, int n) {
        if (nArray == null) {
            nArray = new int[]{n};
            return nArray;
        } else {
            int n2 = nArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    int[] nArray2 = new int[n2 + 1];
                    System.arraycopy((int[])nArray, (int)0, (int[])nArray2, (int)0, (int)n2);
                    nArray2[n2] = n;
                    return nArray2;
                }
                if (nArray[n3] == n) return nArray;
                ++n3;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long[] appendLong(long[] lArray, long l) {
        if (lArray == null) {
            lArray = new long[]{l};
            return lArray;
        } else {
            int n = lArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    long[] lArray2 = new long[n + 1];
                    System.arraycopy((long[])lArray, (int)0, (long[])lArray2, (int)0, (int)n);
                    lArray2[n] = l;
                    return lArray2;
                }
                if (lArray[n2] == l) return lArray;
                ++n2;
            }
        }
    }

    public static long[] cloneOrNull(long[] lArray) {
        if (lArray != null) {
            return (long[])lArray.clone();
        }
        return null;
    }

    public static <T> boolean contains(ArraySet<T> arraySet, T t) {
        if (arraySet != null) {
            return arraySet.contains(t);
        }
        return false;
    }

    public static <T> boolean contains(ArrayList<T> arrayList, T t) {
        if (arrayList != null) {
            return arrayList.contains(t);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean contains(int[] nArray, int n) {
        if (nArray != null) {
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] != n) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean contains(long[] lArray, long l) {
        if (lArray != null) {
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                if (lArray[i] != l) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean contains(T[] TArray, T t) {
        return ArrayUtils.indexOf(TArray, t) != -1;
    }

    public static <T> boolean containsAll(T[] TArray, T[] TArray2) {
        int n = TArray2.length;
        for (int i = 0; i < n; ++i) {
            if (ArrayUtils.contains(TArray, TArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] emptyArray(Class<T> clazz) {
        if (clazz == Object.class) {
            return EmptyArray.OBJECT;
        }
        int n = (Integer.MAX_VALUE & clazz.hashCode()) % 73;
        Object object = sCache[n];
        if (object == null || object.getClass().getComponentType() != clazz) {
            ArrayUtils.sCache[n] = object = Array.newInstance(clazz, 0);
        }
        return (Object[])object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean equals(byte[] byArray, byte[] byArray2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (byArray != byArray2) {
            if (byArray == null || byArray2 == null || byArray.length < n || byArray2.length < n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> int indexOf(T[] TArray, T t) {
        if (TArray == null) {
            return -1;
        }
        int n = 0;
        while (n < TArray.length) {
            if (TArray[n] == null) {
                if (t == null) return n;
            } else if (t != null && TArray[n].equals(t)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static <T> boolean isEmpty(T[] TArray) {
        return TArray == null || TArray.length == 0;
    }

    public static <T> T[] newUnpaddedArray(Class<T> clazz, int n) {
        return (Object[])VMRuntime.getRuntime().newUnpaddedArray(clazz, n);
    }

    public static boolean[] newUnpaddedBooleanArray(int n) {
        return (boolean[])VMRuntime.getRuntime().newUnpaddedArray(Boolean.TYPE, n);
    }

    public static byte[] newUnpaddedByteArray(int n) {
        return (byte[])VMRuntime.getRuntime().newUnpaddedArray(Byte.TYPE, n);
    }

    public static char[] newUnpaddedCharArray(int n) {
        return (char[])VMRuntime.getRuntime().newUnpaddedArray(Character.TYPE, n);
    }

    public static float[] newUnpaddedFloatArray(int n) {
        return (float[])VMRuntime.getRuntime().newUnpaddedArray(Float.TYPE, n);
    }

    public static int[] newUnpaddedIntArray(int n) {
        return (int[])VMRuntime.getRuntime().newUnpaddedArray(Integer.TYPE, n);
    }

    public static long[] newUnpaddedLongArray(int n) {
        return (long[])VMRuntime.getRuntime().newUnpaddedArray(Long.TYPE, n);
    }

    public static Object[] newUnpaddedObjectArray(int n) {
        return (Object[])VMRuntime.getRuntime().newUnpaddedArray(Object.class, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> ArraySet<T> remove(ArraySet<T> arraySet, T t) {
        if (arraySet == null) {
            return null;
        }
        arraySet.remove(t);
        if (!arraySet.isEmpty()) return arraySet;
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> ArrayList<T> remove(ArrayList<T> arrayList, T t) {
        if (arrayList == null) {
            return null;
        }
        arrayList.remove(t);
        if (!arrayList.isEmpty()) return arrayList;
        return null;
    }

    public static <T> T[] removeElement(Class<T> clazz, T[] TArray, T t) {
        if (TArray != null) {
            int n = TArray.length;
            for (int i = 0; i < n; ++i) {
                if (TArray[i] != t) continue;
                if (n == 1) {
                    return null;
                }
                Object[] objectArray = (Object[])Array.newInstance(clazz, n - 1);
                System.arraycopy(TArray, 0, objectArray, 0, i);
                System.arraycopy(TArray, i + 1, objectArray, i, -1 + (n - i));
                return objectArray;
            }
        }
        return TArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] removeInt(int[] nArray, int n) {
        if (nArray == null) {
            return null;
        }
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] == n) {
                int[] nArray2 = new int[n2 - 1];
                if (n3 > 0) {
                    System.arraycopy((int[])nArray, (int)0, (int[])nArray2, (int)0, (int)n3);
                }
                if (n3 >= n2 - 1) return nArray2;
                System.arraycopy((int[])nArray, (int)(n3 + 1), (int[])nArray2, (int)n3, (int)(-1 + (n2 - n3)));
                return nArray2;
            }
            ++n3;
        }
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long[] removeLong(long[] lArray, long l) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (lArray[n2] == l) {
                long[] lArray2 = new long[n - 1];
                if (n2 > 0) {
                    System.arraycopy((long[])lArray, (int)0, (long[])lArray2, (int)0, (int)n2);
                }
                if (n2 >= n - 1) return lArray2;
                System.arraycopy((long[])lArray, (int)(n2 + 1), (long[])lArray2, (int)n2, (int)(-1 + (n - n2)));
                return lArray2;
            }
            ++n2;
        }
        return lArray;
    }

    public static long total(long[] lArray) {
        long l = 0L;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            l += lArray[i];
        }
        return l;
    }
}

