/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telecom;

import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telecom.ConnectionRequest;
import android.telecom.DisconnectCause;
import android.telecom.ParcelableConference;
import android.telecom.ParcelableConnection;
import android.telecom.PhoneAccountHandle;
import android.telecom.StatusHints;
import com.android.internal.telecom.IVideoProvider;
import com.android.internal.telecom.RemoteServiceCallback;
import java.util.List;

public interface IConnectionServiceAdapter
extends IInterface {
    public void addConferenceCall(String var1, ParcelableConference var2) throws RemoteException;

    public void handleCreateConnectionComplete(String var1, ConnectionRequest var2, ParcelableConnection var3) throws RemoteException;

    public void onPostDialWait(String var1, String var2) throws RemoteException;

    public void queryRemoteConnectionServices(RemoteServiceCallback var1) throws RemoteException;

    public void removeCall(String var1) throws RemoteException;

    public void setActive(String var1) throws RemoteException;

    public void setAddress(String var1, Uri var2, int var3) throws RemoteException;

    public void setCallCapabilities(String var1, int var2) throws RemoteException;

    public void setCallSubstate(String var1, int var2) throws RemoteException;

    public void setCallerDisplayName(String var1, String var2, int var3) throws RemoteException;

    public void setConferenceableConnections(String var1, List<String> var2) throws RemoteException;

    public void setDialing(String var1) throws RemoteException;

    public void setDisconnected(String var1, DisconnectCause var2) throws RemoteException;

    public void setDisconnectedWithSsNotification(String var1, int var2, String var3, int var4, int var5) throws RemoteException;

    public void setIsConferenced(String var1, String var2) throws RemoteException;

    public void setIsVoipAudioMode(String var1, boolean var2) throws RemoteException;

    public void setOnHold(String var1) throws RemoteException;

    public void setPhoneAccountHandle(String var1, PhoneAccountHandle var2) throws RemoteException;

    public void setRingbackRequested(String var1, boolean var2) throws RemoteException;

    public void setRinging(String var1) throws RemoteException;

    public void setStatusHints(String var1, StatusHints var2) throws RemoteException;

    public void setVideoProvider(String var1, IVideoProvider var2) throws RemoteException;

    public void setVideoState(String var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IConnectionServiceAdapter {
        private static final String DESCRIPTOR = "com.android.internal.telecom.IConnectionServiceAdapter";
        static final int TRANSACTION_addConferenceCall = 11;
        static final int TRANSACTION_handleCreateConnectionComplete = 1;
        static final int TRANSACTION_onPostDialWait = 13;
        static final int TRANSACTION_queryRemoteConnectionServices = 14;
        static final int TRANSACTION_removeCall = 12;
        static final int TRANSACTION_setActive = 2;
        static final int TRANSACTION_setAddress = 19;
        static final int TRANSACTION_setCallCapabilities = 9;
        static final int TRANSACTION_setCallSubstate = 23;
        static final int TRANSACTION_setCallerDisplayName = 20;
        static final int TRANSACTION_setConferenceableConnections = 21;
        static final int TRANSACTION_setDialing = 4;
        static final int TRANSACTION_setDisconnected = 5;
        static final int TRANSACTION_setDisconnectedWithSsNotification = 6;
        static final int TRANSACTION_setIsConferenced = 10;
        static final int TRANSACTION_setIsVoipAudioMode = 17;
        static final int TRANSACTION_setOnHold = 7;
        static final int TRANSACTION_setPhoneAccountHandle = 22;
        static final int TRANSACTION_setRingbackRequested = 8;
        static final int TRANSACTION_setRinging = 3;
        static final int TRANSACTION_setStatusHints = 18;
        static final int TRANSACTION_setVideoProvider = 15;
        static final int TRANSACTION_setVideoState = 16;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IConnectionServiceAdapter asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IConnectionServiceAdapter) {
                return (IConnectionServiceAdapter)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    ConnectionRequest connectionRequest = parcel.readInt() != 0 ? ConnectionRequest.CREATOR.createFromParcel(parcel) : null;
                    ParcelableConnection parcelableConnection = parcel.readInt() != 0 ? ParcelableConnection.CREATOR.createFromParcel(parcel) : null;
                    this.handleCreateConnectionComplete(string2, connectionRequest, parcelableConnection);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setActive(parcel.readString());
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setRinging(parcel.readString());
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setDialing(parcel.readString());
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = parcel.readString();
                    DisconnectCause disconnectCause = parcel.readInt() != 0 ? DisconnectCause.CREATOR.createFromParcel(parcel) : null;
                    this.setDisconnected(string3, disconnectCause);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setDisconnectedWithSsNotification(parcel.readString(), parcel.readInt(), parcel.readString(), parcel.readInt(), parcel.readInt());
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setOnHold(parcel.readString());
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = parcel.readString();
                    int n3 = parcel.readInt();
                    boolean bl = false;
                    if (n3 != 0) {
                        bl = true;
                    }
                    this.setRingbackRequested(string4, bl);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setCallCapabilities(parcel.readString(), parcel.readInt());
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setIsConferenced(parcel.readString(), parcel.readString());
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string5 = parcel.readString();
                    ParcelableConference parcelableConference = parcel.readInt() != 0 ? ParcelableConference.CREATOR.createFromParcel(parcel) : null;
                    this.addConferenceCall(string5, parcelableConference);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeCall(parcel.readString());
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onPostDialWait(parcel.readString(), parcel.readString());
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.queryRemoteConnectionServices(RemoteServiceCallback.Stub.asInterface(parcel.readStrongBinder()));
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setVideoProvider(parcel.readString(), IVideoProvider.Stub.asInterface(parcel.readStrongBinder()));
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setVideoState(parcel.readString(), parcel.readInt());
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string6 = parcel.readString();
                    int n4 = parcel.readInt();
                    boolean bl = false;
                    if (n4 != 0) {
                        bl = true;
                    }
                    this.setIsVoipAudioMode(string6, bl);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string7 = parcel.readString();
                    StatusHints statusHints = parcel.readInt() != 0 ? StatusHints.CREATOR.createFromParcel(parcel) : null;
                    this.setStatusHints(string7, statusHints);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string8 = parcel.readString();
                    Uri uri = parcel.readInt() != 0 ? Uri.CREATOR.createFromParcel(parcel) : null;
                    this.setAddress(string8, uri, parcel.readInt());
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setCallerDisplayName(parcel.readString(), parcel.readString(), parcel.readInt());
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setConferenceableConnections(parcel.readString(), parcel.createStringArrayList());
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string9 = parcel.readString();
                    PhoneAccountHandle phoneAccountHandle = parcel.readInt() != 0 ? PhoneAccountHandle.CREATOR.createFromParcel(parcel) : null;
                    this.setPhoneAccountHandle(string9, phoneAccountHandle);
                    return true;
                }
                case 23: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.setCallSubstate(parcel.readString(), parcel.readInt());
            return true;
        }

        private static class Proxy
        implements IConnectionServiceAdapter {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addConferenceCall(String string2, ParcelableConference parcelableConference) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (parcelableConference != null) {
                        parcel.writeInt(1);
                        parcelableConference.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(11, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleCreateConnectionComplete(String string2, ConnectionRequest connectionRequest, ParcelableConnection parcelableConnection) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (connectionRequest != null) {
                        parcel.writeInt(1);
                        connectionRequest.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (parcelableConnection != null) {
                        parcel.writeInt(1);
                        parcelableConnection.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onPostDialWait(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(13, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void queryRemoteConnectionServices(RemoteServiceCallback remoteServiceCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (remoteServiceCallback != null) {
                        iBinder = remoteServiceCallback.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(14, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void removeCall(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(12, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setActive(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setAddress(String string2, Uri uri, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (uri != null) {
                        parcel.writeInt(1);
                        uri.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(19, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setCallCapabilities(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(9, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setCallSubstate(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(23, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setCallerDisplayName(String string2, String string3, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeInt(n);
                    this.mRemote.transact(20, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setConferenceableConnections(String string2, List<String> list) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeStringList(list);
                    this.mRemote.transact(21, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setDialing(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setDisconnected(String string2, DisconnectCause disconnectCause) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (disconnectCause != null) {
                        parcel.writeInt(1);
                        disconnectCause.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setDisconnectedWithSsNotification(String string2, int n, String string3, int n2, int n3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeString(string3);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setIsConferenced(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(10, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setIsVoipAudioMode(String string2, boolean bl) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(17, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setOnHold(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(7, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setPhoneAccountHandle(String string2, PhoneAccountHandle phoneAccountHandle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (phoneAccountHandle != null) {
                        parcel.writeInt(1);
                        phoneAccountHandle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(22, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setRingbackRequested(String string2, boolean bl) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(8, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setRinging(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setStatusHints(String string2, StatusHints statusHints) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (statusHints != null) {
                        parcel.writeInt(1);
                        statusHints.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(18, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setVideoProvider(String string2, IVideoProvider iVideoProvider) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = null;
                    if (iVideoProvider != null) {
                        iBinder = iVideoProvider.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(15, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setVideoState(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(16, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

