/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.SystemProperties;
import android.util.Log;
import dalvik.system.profiler.BinaryHprofWriter;
import dalvik.system.profiler.HprofData;
import dalvik.system.profiler.SamplingProfiler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import libcore.io.IoUtils;

public class SamplingProfilerIntegration {
    public static final String SNAPSHOT_DIR = "/data/snapshots";
    private static final String TAG = "SamplingProfilerIntegration";
    private static final boolean enabled;
    private static final AtomicBoolean pending;
    private static SamplingProfiler samplingProfiler;
    private static final int samplingProfilerDepth;
    private static final int samplingProfilerMilliseconds;
    private static final Executor snapshotWriter;
    private static long startMillis;

    static {
        pending = new AtomicBoolean(false);
        samplingProfilerMilliseconds = SystemProperties.getInt("persist.sys.profiler_ms", 0);
        samplingProfilerDepth = SystemProperties.getInt("persist.sys.profiler_depth", 4);
        if (samplingProfilerMilliseconds > 0) {
            File file = new File(SNAPSHOT_DIR);
            file.mkdirs();
            file.setWritable(true, false);
            file.setExecutable(true, false);
            if (file.isDirectory()) {
                snapshotWriter = Executors.newSingleThreadExecutor(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable runnable) {
                        return new Thread(runnable, SamplingProfilerIntegration.TAG);
                    }
                });
                enabled = true;
                Log.i(TAG, "Profiling enabled. Sampling interval ms: " + samplingProfilerMilliseconds);
            } else {
                snapshotWriter = null;
                enabled = true;
                Log.w(TAG, "Profiling setup failed. Could not create /data/snapshots");
            }
        } else {
            snapshotWriter = null;
            enabled = false;
            Log.i(TAG, "Profiling disabled.");
        }
    }

    private static void generateSnapshotHeader(String string2, PackageInfo packageInfo, PrintStream printStream) {
        printStream.println("Version: 3");
        printStream.println("Process: " + string2);
        if (packageInfo != null) {
            printStream.println("Package: " + packageInfo.packageName);
            printStream.println("Package-Version: " + packageInfo.versionCode);
        }
        printStream.println("Build: " + Build.FINGERPRINT);
        printStream.println();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void start() {
        if (!enabled) {
            return;
        }
        if (samplingProfiler != null) {
            Log.e(TAG, "SamplingProfilerIntegration already started at " + new Date(startMillis));
            return;
        }
        SamplingProfiler.ThreadSet threadSet = SamplingProfiler.newThreadGroupThreadSet((ThreadGroup)Thread.currentThread().getThreadGroup());
        samplingProfiler = new SamplingProfiler(samplingProfilerDepth, threadSet);
        samplingProfiler.start(samplingProfilerMilliseconds);
        startMillis = System.currentTimeMillis();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeSnapshot(final String string2, final PackageInfo packageInfo) {
        block5: {
            block4: {
                if (!enabled) break block4;
                if (samplingProfiler == null) {
                    Log.e(TAG, "SamplingProfilerIntegration is not started");
                    return;
                }
                if (pending.compareAndSet(false, true)) break block5;
            }
            return;
        }
        snapshotWriter.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SamplingProfilerIntegration.writeSnapshotFile(string2, packageInfo);
                    return;
                }
                finally {
                    pending.set(false);
                }
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeSnapshotFile(String var0, PackageInfo var1_1) {
        if (!SamplingProfilerIntegration.enabled) {
            return;
        }
        SamplingProfilerIntegration.samplingProfiler.stop();
        var2_2 = var0.replaceAll(":", ".");
        var3_3 = "/data/snapshots/" + var2_2 + "-" + SamplingProfilerIntegration.startMillis + ".snapshot";
        var4_4 = System.currentTimeMillis();
        var6_5 = null;
        var7_6 = new BufferedOutputStream(new FileOutputStream(var3_3));
        {
            catch (Throwable var9_12) lbl-1000:
            // 2 sources

            {
                while (true) {
                    IoUtils.closeQuietly(var6_5);
                    throw var9_13;
                }
            }
            catch (IOException var10_10) {
                var6_5 = null;
                ** GOTO lbl-1000
            }
            try {
                var8_7 = new PrintStream(var7_6);
                SamplingProfilerIntegration.generateSnapshotHeader(var2_2, var1_1, var8_7);
                if (var8_7.checkError()) {
                    throw new IOException();
                }
            }
            catch (IOException var10_8) {}
            var6_5 = var7_6;
lbl-1000:
            // 2 sources

            {
                Log.e("SamplingProfilerIntegration", "Error writing snapshot to " + var3_3, (Throwable)var10_9);
            }
            IoUtils.closeQuietly((AutoCloseable)var6_5);
            return;
        }
        try {
            BinaryHprofWriter.write((HprofData)SamplingProfilerIntegration.samplingProfiler.getHprofData(), (OutputStream)var7_6);
        }
        catch (Throwable var9_14) {
            var6_5 = var7_6;
            ** continue;
        }
        IoUtils.closeQuietly((AutoCloseable)var7_6);
        new File(var3_3).setReadable(true, false);
        var13_11 = System.currentTimeMillis() - var4_4;
        Log.i("SamplingProfilerIntegration", "Wrote snapshot " + var3_3 + " in " + var13_11 + "ms.");
        SamplingProfilerIntegration.samplingProfiler.start(SamplingProfilerIntegration.samplingProfilerMilliseconds);
    }

    public static void writeZygoteSnapshot() {
        if (!enabled) {
            return;
        }
        SamplingProfilerIntegration.writeSnapshotFile("zygote", null);
        samplingProfiler.shutdown();
        samplingProfiler = null;
        startMillis = 0L;
    }
}

