/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;

public class BatterySipper
implements Comparable<BatterySipper> {
    public long cpuFgTime;
    public long cpuTime;
    public DrainType drainType;
    public long gpsTime;
    public String[] mPackages;
    public long mobileActive;
    public int mobileActiveCount;
    public long mobileRxBytes;
    public long mobileRxPackets;
    public long mobileTxBytes;
    public long mobileTxPackets;
    public double mobilemspp;
    public double noCoveragePercent;
    public String packageWithHighestDrain;
    public double percent;
    public BatteryStats.Uid uidObj;
    public long usageTime;
    public int userId;
    public double value;
    public double[] values;
    public long wakeLockTime;
    public long wifiRunningTime;
    public long wifiRxBytes;
    public long wifiRxPackets;
    public long wifiTxBytes;
    public long wifiTxPackets;

    public BatterySipper(DrainType drainType, BatteryStats.Uid uid, double[] dArray) {
        this.values = dArray;
        if (dArray != null) {
            this.value = dArray[0];
        }
        this.drainType = drainType;
        this.uidObj = uid;
    }

    @Override
    public int compareTo(BatterySipper batterySipper) {
        if (this.drainType != batterySipper.drainType) {
            if (this.drainType == DrainType.OVERCOUNTED) {
                return 1;
            }
            if (batterySipper.drainType == DrainType.OVERCOUNTED) {
                return -1;
            }
        }
        return Double.compare(batterySipper.value, this.value);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void computeMobilemspp() {
        long l = this.mobileRxPackets + this.mobileTxPackets;
        double d = l > 0L ? (double)this.mobileActive / (double)l : 0.0;
        this.mobilemspp = d;
    }

    public String[] getPackages() {
        return this.mPackages;
    }

    public int getUid() {
        if (this.uidObj == null) {
            return 0;
        }
        return this.uidObj.getUid();
    }

    public double[] getValues() {
        return this.values;
    }

    public static final class DrainType
    extends Enum<DrainType> {
        private static final /* synthetic */ DrainType[] $VALUES;
        public static final /* enum */ DrainType APP;
        public static final /* enum */ DrainType BLUETOOTH;
        public static final /* enum */ DrainType CELL;
        public static final /* enum */ DrainType FLASHLIGHT;
        public static final /* enum */ DrainType IDLE;
        public static final /* enum */ DrainType OVERCOUNTED;
        public static final /* enum */ DrainType PHONE;
        public static final /* enum */ DrainType SCREEN;
        public static final /* enum */ DrainType UNACCOUNTED;
        public static final /* enum */ DrainType USER;
        public static final /* enum */ DrainType WIFI;

        static {
            IDLE = new DrainType();
            CELL = new DrainType();
            PHONE = new DrainType();
            WIFI = new DrainType();
            BLUETOOTH = new DrainType();
            FLASHLIGHT = new DrainType();
            SCREEN = new DrainType();
            APP = new DrainType();
            USER = new DrainType();
            UNACCOUNTED = new DrainType();
            OVERCOUNTED = new DrainType();
            DrainType[] drainTypeArray = new DrainType[]{IDLE, CELL, PHONE, WIFI, BLUETOOTH, FLASHLIGHT, SCREEN, APP, USER, UNACCOUNTED, OVERCOUNTED};
            $VALUES = drainTypeArray;
        }

        public static DrainType valueOf(String string2) {
            return Enum.valueOf(DrainType.class, string2);
        }

        public static DrainType[] values() {
            return (DrainType[])$VALUES.clone();
        }
    }
}

