/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.net.LinkAddress;
import android.net.RouteInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class VpnConfig
implements Parcelable {
    public static final Parcelable.Creator<VpnConfig> CREATOR = new Parcelable.Creator<VpnConfig>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public VpnConfig createFromParcel(Parcel parcel) {
            boolean bl = true;
            VpnConfig vpnConfig = new VpnConfig();
            vpnConfig.user = parcel.readString();
            vpnConfig.interfaze = parcel.readString();
            vpnConfig.session = parcel.readString();
            vpnConfig.mtu = parcel.readInt();
            parcel.readTypedList(vpnConfig.addresses, LinkAddress.CREATOR);
            parcel.readTypedList(vpnConfig.routes, RouteInfo.CREATOR);
            vpnConfig.dnsServers = parcel.createStringArrayList();
            vpnConfig.searchDomains = parcel.createStringArrayList();
            vpnConfig.allowedApplications = parcel.createStringArrayList();
            vpnConfig.disallowedApplications = parcel.createStringArrayList();
            vpnConfig.configureIntent = (PendingIntent)parcel.readParcelable(null);
            vpnConfig.startTime = parcel.readLong();
            boolean bl2 = parcel.readInt() != 0 ? bl : false;
            vpnConfig.legacy = bl2;
            boolean bl3 = parcel.readInt() != 0 ? bl : false;
            vpnConfig.blocking = bl3;
            boolean bl4 = parcel.readInt() != 0 ? bl : false;
            vpnConfig.allowBypass = bl4;
            boolean bl5 = parcel.readInt() != 0 ? bl : false;
            vpnConfig.allowIPv4 = bl5;
            if (parcel.readInt() == 0) {
                bl = false;
            }
            vpnConfig.allowIPv6 = bl;
            return vpnConfig;
        }

        public VpnConfig[] newArray(int n) {
            return new VpnConfig[n];
        }
    };
    public static final String DIALOGS_PACKAGE = "com.android.vpndialogs";
    public static final String LEGACY_VPN = "[Legacy VPN]";
    public static final String SERVICE_INTERFACE = "android.net.VpnService";
    public List<LinkAddress> addresses = new ArrayList<LinkAddress>();
    public boolean allowBypass;
    public boolean allowIPv4;
    public boolean allowIPv6;
    public List<String> allowedApplications;
    public boolean blocking;
    public PendingIntent configureIntent;
    public List<String> disallowedApplications;
    public List<String> dnsServers;
    public String interfaze;
    public boolean legacy;
    public int mtu = -1;
    public List<RouteInfo> routes = new ArrayList<RouteInfo>();
    public List<String> searchDomains;
    public String session;
    public long startTime = -1L;
    public String user;

    public static Intent getIntentForConfirmation() {
        Intent intent = new Intent();
        ComponentName componentName = ComponentName.unflattenFromString(Resources.getSystem().getString(17039430));
        intent.setClassName(componentName.getPackageName(), componentName.getClassName());
        return intent;
    }

    public static PendingIntent getIntentForStatusPanel(Context context) {
        Intent intent = new Intent();
        intent.setClassName(DIALOGS_PACKAGE, "com.android.vpndialogs.ManageDialog");
        intent.addFlags(0x50800000);
        return PendingIntent.getActivityAsUser(context, 0, intent, 0, null, UserHandle.CURRENT);
    }

    public static CharSequence getVpnLabel(Context context, String string2) throws PackageManager.NameNotFoundException {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent(SERVICE_INTERFACE);
        intent.setPackage(string2);
        List<ResolveInfo> list = packageManager.queryIntentServices(intent, 0);
        if (list != null && list.size() == 1) {
            return list.get(0).loadLabel(packageManager);
        }
        return packageManager.getApplicationInfo(string2, 0).loadLabel(packageManager);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addLegacyAddresses(String string2) {
        if (!string2.trim().equals("")) {
            String[] stringArray = string2.trim().split(" ");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] stringArray2 = stringArray[i].split("/");
                LinkAddress linkAddress = new LinkAddress(InetAddress.parseNumericAddress((String)stringArray2[0]), Integer.parseInt(stringArray2[1]));
                this.addresses.add(linkAddress);
                this.updateAllowedFamilies(linkAddress.getAddress());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addLegacyRoutes(String string2) {
        if (!string2.trim().equals("")) {
            String[] stringArray = string2.trim().split(" ");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] stringArray2 = stringArray[i].split("/");
                RouteInfo routeInfo = new RouteInfo(new LinkAddress(InetAddress.parseNumericAddress((String)stringArray2[0]), Integer.parseInt(stringArray2[1])), null);
                this.routes.add(routeInfo);
                this.updateAllowedFamilies(routeInfo.getDestination().getAddress());
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void updateAllowedFamilies(InetAddress inetAddress) {
        if (inetAddress instanceof Inet4Address) {
            this.allowIPv4 = true;
            return;
        }
        this.allowIPv6 = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeString(this.user);
        parcel.writeString(this.interfaze);
        parcel.writeString(this.session);
        parcel.writeInt(this.mtu);
        parcel.writeTypedList(this.addresses);
        parcel.writeTypedList(this.routes);
        parcel.writeStringList(this.dnsServers);
        parcel.writeStringList(this.searchDomains);
        parcel.writeStringList(this.allowedApplications);
        parcel.writeStringList(this.disallowedApplications);
        parcel.writeParcelable(this.configureIntent, n);
        parcel.writeLong(this.startTime);
        int n3 = this.legacy ? n2 : 0;
        parcel.writeInt(n3);
        int n4 = this.blocking ? n2 : 0;
        parcel.writeInt(n4);
        int n5 = this.allowBypass ? n2 : 0;
        parcel.writeInt(n5);
        int n6 = this.allowIPv4 ? n2 : 0;
        parcel.writeInt(n6);
        if (!this.allowIPv6) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }
}

