/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Slog;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.TextServicesManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class InputMethodUtils {
    public static final boolean DEBUG = false;
    private static final Locale ENGLISH_LOCALE;
    public static final int NOT_A_SUBTYPE_ID = -1;
    private static final String NOT_A_SUBTYPE_ID_STR;
    private static final Locale[] SEARCH_ORDER_OF_FALLBACK_LOCALES;
    public static final String SUBTYPE_MODE_ANY;
    public static final String SUBTYPE_MODE_KEYBOARD = "keyboard";
    public static final String SUBTYPE_MODE_VOICE = "voice";
    private static final String TAG = "InputMethodUtils";
    private static final String TAG_ASCII_CAPABLE = "AsciiCapable";
    private static final String TAG_ENABLED_WHEN_DEFAULT_IS_NOT_ASCII_CAPABLE = "EnabledWhenDefaultIsNotAsciiCapable";
    private static String[] mBundledThirdPartyImes;

    static {
        SUBTYPE_MODE_ANY = null;
        ENGLISH_LOCALE = new Locale("en");
        NOT_A_SUBTYPE_ID_STR = String.valueOf(-1);
        Locale[] localeArray = new Locale[]{Locale.ENGLISH, Locale.US, Locale.UK};
        SEARCH_ORDER_OF_FALLBACK_LOCALES = localeArray;
    }

    private InputMethodUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean canAddToLastInputMethod(InputMethodSubtype inputMethodSubtype) {
        return inputMethodSubtype == null || !inputMethodSubtype.isAuxiliary();
    }

    public static boolean checkIfPackageBelongsToUid(AppOpsManager appOpsManager, int n, String string2) {
        try {
            appOpsManager.checkPackage(n, string2);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public static boolean containsSubtypeOf(InputMethodInfo inputMethodInfo, String string2, String string3) {
        int n = inputMethodInfo.getSubtypeCount();
        int n2 = 0;
        while (n2 < n) {
            InputMethodSubtype inputMethodSubtype = inputMethodInfo.getSubtypeAt(n2);
            if (inputMethodSubtype.getLocale().startsWith(string2) && (string3 == SUBTYPE_MODE_ANY || TextUtils.isEmpty(string3) || string3.equalsIgnoreCase(inputMethodSubtype.getMode()))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean containsSubtypeOf(InputMethodInfo inputMethodInfo, Locale locale, boolean bl, String string2) {
        int n = inputMethodInfo.getSubtypeCount();
        int n2 = 0;
        while (n2 < n) {
            InputMethodSubtype inputMethodSubtype = inputMethodInfo.getSubtypeAt(n2);
            if (!(!bl ? !TextUtils.equals(inputMethodSubtype.getLocale(), locale.toString()) : !new Locale(InputMethodUtils.getLanguageFromLocaleString(inputMethodSubtype.getLocale())).getLanguage().equals(locale.getLanguage()))) {
                if (string2 == SUBTYPE_MODE_ANY || TextUtils.isEmpty(string2) || string2.equalsIgnoreCase(inputMethodSubtype.getMode())) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputMethodSubtype findLastResortApplicableSubtypeLocked(Resources resources, List<InputMethodSubtype> list, String string2, String string3, boolean bl) {
        if (list == null) return null;
        if (list.size() == 0) {
            return null;
        }
        if (TextUtils.isEmpty(string3)) {
            string3 = resources.getConfiguration().locale.toString();
        }
        String string4 = InputMethodUtils.getLanguageFromLocaleString(string3);
        boolean bl2 = false;
        InputMethodSubtype inputMethodSubtype = null;
        InputMethodSubtype inputMethodSubtype2 = null;
        int n = list.size();
        int n2 = 0;
        while (true) {
            block9: {
                String string5;
                InputMethodSubtype inputMethodSubtype3;
                block10: {
                    block8: {
                        if (n2 >= n) break block8;
                        inputMethodSubtype3 = list.get(n2);
                        String string6 = inputMethodSubtype3.getLocale();
                        string5 = InputMethodUtils.getLanguageFromLocaleString(string6);
                        if (string2 != null && !list.get(n2).getMode().equalsIgnoreCase(string2)) break block9;
                        if (inputMethodSubtype2 == null) {
                            inputMethodSubtype2 = inputMethodSubtype3;
                        }
                        if (!string3.equals(string6)) break block10;
                        inputMethodSubtype = inputMethodSubtype3;
                    }
                    if (inputMethodSubtype != null) return inputMethodSubtype;
                    if (bl) return inputMethodSubtype2;
                    return inputMethodSubtype;
                }
                if (!bl2 && string4.equals(string5)) {
                    inputMethodSubtype = inputMethodSubtype3;
                    bl2 = true;
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getApiCallStack() {
        String string2 = "";
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException runtimeException) {
            StackTraceElement[] stackTraceElementArray = runtimeException.getStackTrace();
            for (int i = 1; i < stackTraceElementArray.length; ++i) {
                String string3 = stackTraceElementArray[i].toString();
                if (TextUtils.isEmpty(string2)) {
                    string2 = string3;
                    continue;
                }
                if (string3.indexOf("Transact(") >= 0) break;
                string2 = string3;
            }
            return string2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ArrayList<InputMethodInfo> getDefaultEnabledImes(Context context, boolean bl, ArrayList<InputMethodInfo> arrayList) {
        ArrayList<InputMethodInfo> arrayList2;
        Locale locale = InputMethodUtils.getFallbackLocaleForDefaultIme(arrayList, context);
        if (!bl) {
            arrayList2 = new ArrayList<InputMethodInfo>();
            for (int i = 0; i < arrayList.size(); ++i) {
                InputMethodInfo inputMethodInfo = arrayList.get(i);
                if (!InputMethodUtils.isSystemIme(inputMethodInfo) || !inputMethodInfo.isDefault(context) || !InputMethodUtils.isImeThatHasSubtypeOf(inputMethodInfo, locale, false, SUBTYPE_MODE_KEYBOARD)) continue;
                arrayList2.add(inputMethodInfo);
            }
            return arrayList2;
        }
        Locale locale2 = InputMethodUtils.getSystemLocaleFromContext(context);
        arrayList2 = new ArrayList();
        boolean bl2 = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            InputMethodInfo inputMethodInfo = arrayList.get(i);
            if (!InputMethodUtils.isSystemIme(inputMethodInfo) || !inputMethodInfo.isDefault(context)) continue;
            boolean bl3 = InputMethodUtils.isImeThatHasSubtypeOf(inputMethodInfo, locale2, false, SUBTYPE_MODE_KEYBOARD);
            if (bl3 || InputMethodUtils.isImeThatHasSubtypeOf(inputMethodInfo, locale, false, SUBTYPE_MODE_ANY)) {
                arrayList2.add(inputMethodInfo);
            }
            bl2 |= bl3;
        }
        if (!bl2) {
            for (int i = 0; i < arrayList.size(); ++i) {
                InputMethodInfo inputMethodInfo = arrayList.get(i);
                if (!InputMethodUtils.isSystemIme(inputMethodInfo) || !inputMethodInfo.isDefault(context) || InputMethodUtils.isImeThatHasSubtypeOf(inputMethodInfo, locale, false, SUBTYPE_MODE_KEYBOARD) || !InputMethodUtils.isImeThatHasSubtypeOf(inputMethodInfo, locale2, true, SUBTYPE_MODE_ANY)) continue;
                arrayList2.add(inputMethodInfo);
            }
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (arrayList2.get(i).isAuxiliaryIme()) return arrayList2;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            InputMethodInfo inputMethodInfo = arrayList.get(i);
            if (!InputMethodUtils.isSystemAuxilialyImeThatHasAutomaticSubtype(inputMethodInfo)) continue;
            arrayList2.add(inputMethodInfo);
        }
        return arrayList2;
    }

    private static List<InputMethodSubtype> getEnabledInputMethodSubtypeList(Context context, InputMethodInfo inputMethodInfo, List<InputMethodSubtype> list, boolean bl) {
        if (bl && list.isEmpty()) {
            list = InputMethodUtils.getImplicitlyApplicableSubtypesLocked(context.getResources(), inputMethodInfo);
        }
        return InputMethodSubtype.sort(context, 0, inputMethodInfo, list);
    }

    public static Locale getFallbackLocaleForDefaultIme(ArrayList<InputMethodInfo> arrayList, Context context) {
        for (Locale locale : SEARCH_ORDER_OF_FALLBACK_LOCALES) {
            for (int i = 0; i < arrayList.size(); ++i) {
                InputMethodInfo inputMethodInfo = arrayList.get(i);
                if (!InputMethodUtils.isSystemIme(inputMethodInfo) || !inputMethodInfo.isDefault(context) || !InputMethodUtils.containsSubtypeOf(inputMethodInfo, locale, false, SUBTYPE_MODE_KEYBOARD)) continue;
                return locale;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CharSequence getImeAndSubtypeDisplayName(Context context, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
        CharSequence charSequence = inputMethodInfo.loadLabel(context.getPackageManager());
        if (inputMethodSubtype == null) return charSequence;
        CharSequence[] charSequenceArray = new CharSequence[2];
        charSequenceArray[0] = inputMethodSubtype.getDisplayName(context, inputMethodInfo.getPackageName(), inputMethodInfo.getServiceInfo().applicationInfo);
        String string2 = TextUtils.isEmpty(charSequence) ? "" : " - " + charSequence;
        charSequenceArray[1] = string2;
        return TextUtils.concat(charSequenceArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ArrayList<InputMethodSubtype> getImplicitlyApplicableSubtypesLocked(Resources resources, InputMethodInfo inputMethodInfo) {
        ArrayList<InputMethodSubtype> arrayList = InputMethodUtils.getSubtypes(inputMethodInfo);
        String string2 = resources.getConfiguration().locale.toString();
        if (TextUtils.isEmpty(string2)) {
            return new ArrayList<InputMethodSubtype>();
        }
        String string3 = resources.getConfiguration().locale.getLanguage();
        HashMap<String, InputMethodSubtype> hashMap = new HashMap<String, InputMethodSubtype>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string4;
            InputMethodSubtype inputMethodSubtype = (InputMethodSubtype)arrayList.get(i);
            if (!inputMethodSubtype.overridesImplicitlyEnabledSubtype() || hashMap.containsKey(string4 = inputMethodSubtype.getMode())) continue;
            hashMap.put(string4, inputMethodSubtype);
        }
        if (hashMap.size() > 0) {
            return new ArrayList<InputMethodSubtype>(hashMap.values());
        }
        for (int i = 0; i < n; ++i) {
            InputMethodSubtype inputMethodSubtype;
            InputMethodSubtype inputMethodSubtype2 = (InputMethodSubtype)arrayList.get(i);
            String string5 = inputMethodSubtype2.getLocale();
            String string6 = inputMethodSubtype2.getMode();
            if (!InputMethodUtils.getLanguageFromLocaleString(string5).equals(string3) || !string2.startsWith(string5) || (inputMethodSubtype = (InputMethodSubtype)hashMap.get(string6)) != null && (string2.equals(inputMethodSubtype.getLocale()) || !string2.equals(string5))) continue;
            hashMap.put(string6, inputMethodSubtype2);
        }
        InputMethodSubtype inputMethodSubtype = (InputMethodSubtype)hashMap.get(SUBTYPE_MODE_KEYBOARD);
        ArrayList<InputMethodSubtype> arrayList2 = new ArrayList(hashMap.values());
        if (inputMethodSubtype != null && !inputMethodSubtype.containsExtraValueKey(TAG_ASCII_CAPABLE)) {
            for (int i = 0; i < n; ++i) {
                InputMethodSubtype inputMethodSubtype3 = (InputMethodSubtype)arrayList.get(i);
                if (!SUBTYPE_MODE_KEYBOARD.equals(inputMethodSubtype3.getMode()) || !inputMethodSubtype3.containsExtraValueKey(TAG_ENABLED_WHEN_DEFAULT_IS_NOT_ASCII_CAPABLE)) continue;
                arrayList2.add(inputMethodSubtype3);
            }
        }
        if (inputMethodSubtype != null) return arrayList2;
        InputMethodSubtype inputMethodSubtype4 = InputMethodUtils.findLastResortApplicableSubtypeLocked(resources, arrayList, SUBTYPE_MODE_KEYBOARD, string2, true);
        if (inputMethodSubtype4 == null) return arrayList2;
        arrayList2.add(inputMethodSubtype4);
        return arrayList2;
    }

    public static String getLanguageFromLocaleString(String string2) {
        int n = string2.indexOf(95);
        if (n < 0) {
            return string2;
        }
        return string2.substring(0, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputMethodInfo getMostApplicableDefaultIME(List<InputMethodInfo> list) {
        if (list == null) return null;
        if (list.isEmpty()) {
            return null;
        }
        int n = list.size();
        int n2 = -1;
        while (n > 0) {
            InputMethodInfo inputMethodInfo;
            if (InputMethodUtils.isSystemImeThatHasEnglishKeyboardSubtype(inputMethodInfo = list.get(--n))) {
                if (!inputMethodInfo.isAuxiliaryIme()) return inputMethodInfo;
            }
            if (n2 >= 0 || !InputMethodUtils.isSystemIme(inputMethodInfo) || inputMethodInfo.isAuxiliaryIme()) continue;
            n2 = n;
        }
        return list.get(Math.max(n2, 0));
    }

    public static ArrayList<InputMethodSubtype> getOverridingImplicitlyEnabledSubtypes(InputMethodInfo inputMethodInfo, String string2) {
        ArrayList<InputMethodSubtype> arrayList = new ArrayList<InputMethodSubtype>();
        int n = inputMethodInfo.getSubtypeCount();
        for (int i = 0; i < n; ++i) {
            InputMethodSubtype inputMethodSubtype = inputMethodInfo.getSubtypeAt(i);
            if (!inputMethodSubtype.overridesImplicitlyEnabledSubtype() || !inputMethodSubtype.getMode().equals(string2)) continue;
            arrayList.add(inputMethodSubtype);
        }
        return arrayList;
    }

    public static String getStackTrace() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException runtimeException) {
            StackTraceElement[] stackTraceElementArray = runtimeException.getStackTrace();
            for (int i = 1; i < stackTraceElementArray.length; ++i) {
                stringBuilder.append(stackTraceElementArray[i].toString() + "\n");
            }
            return stringBuilder.toString();
        }
    }

    public static int getSubtypeIdFromHashCode(InputMethodInfo inputMethodInfo, int n) {
        if (inputMethodInfo != null) {
            int n2 = inputMethodInfo.getSubtypeCount();
            for (int i = 0; i < n2; ++i) {
                if (n != inputMethodInfo.getSubtypeAt(i).hashCode()) continue;
                return i;
            }
        }
        return -1;
    }

    public static ArrayList<InputMethodSubtype> getSubtypes(InputMethodInfo inputMethodInfo) {
        ArrayList<InputMethodSubtype> arrayList = new ArrayList<InputMethodSubtype>();
        int n = inputMethodInfo.getSubtypeCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(inputMethodInfo.getSubtypeAt(i));
        }
        return arrayList;
    }

    public static Locale getSystemLocaleFromContext(Context context) {
        try {
            Locale locale = context.getResources().getConfiguration().locale;
            return locale;
        }
        catch (Resources.NotFoundException notFoundException) {
            return null;
        }
    }

    public static boolean isImeThatHasSubtypeOf(InputMethodInfo inputMethodInfo, Locale locale, boolean bl, String string2) {
        if (locale == null) {
            return false;
        }
        return InputMethodUtils.containsSubtypeOf(inputMethodInfo, locale, bl, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isSystemAuxilialyImeThatHasAutomaticSubtype(InputMethodInfo inputMethodInfo) {
        if (InputMethodUtils.isSystemIme(inputMethodInfo) && inputMethodInfo.isAuxiliaryIme()) {
            int n = inputMethodInfo.getSubtypeCount();
            for (int i = 0; i < n; ++i) {
                if (!inputMethodInfo.getSubtypeAt(i).overridesImplicitlyEnabledSubtype()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSystemIme(InputMethodInfo inputMethodInfo) {
        return (1 & inputMethodInfo.getServiceInfo().applicationInfo.flags) != 0;
    }

    @Deprecated
    public static boolean isSystemImeThatHasEnglishKeyboardSubtype(InputMethodInfo inputMethodInfo) {
        if (!InputMethodUtils.isSystemIme(inputMethodInfo)) {
            return false;
        }
        return InputMethodUtils.containsSubtypeOf(inputMethodInfo, ENGLISH_LOCALE.getLanguage(), SUBTYPE_MODE_KEYBOARD);
    }

    private static boolean isValidBundledThirdPartyIme(InputMethodInfo inputMethodInfo) {
        String string2 = inputMethodInfo.getPackageName();
        if (mBundledThirdPartyImes != null && string2 != null) {
            String[] stringArray = mBundledThirdPartyImes;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!string2.equalsIgnoreCase(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidSubtypeId(InputMethodInfo inputMethodInfo, int n) {
        return InputMethodUtils.getSubtypeIdFromHashCode(inputMethodInfo, n) != -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static boolean isValidSystemDefaultIme(boolean bl, InputMethodInfo inputMethodInfo, Context context) {
        block10: {
            block9: {
                mBundledThirdPartyImes = context.getResources().getStringArray(17236038);
                if (!bl || !InputMethodUtils.isSystemIme(inputMethodInfo)) break block9;
                if (inputMethodInfo.getIsDefaultResourceId() != 0) {
                    try {
                        boolean bl2;
                        if (inputMethodInfo.isDefault(context) && (bl2 = InputMethodUtils.containsSubtypeOf(inputMethodInfo, context.getResources().getConfiguration().locale.getLanguage(), SUBTYPE_MODE_ANY))) {
                            return true;
                        }
                    }
                    catch (Resources.NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
                if (InputMethodUtils.isValidBundledThirdPartyIme(inputMethodInfo)) {
                    return true;
                }
                if (inputMethodInfo.getSubtypeCount() == 0) break block10;
            }
            return false;
        }
        Slog.w(TAG, "Found no subtypes in a system IME: " + inputMethodInfo.getPackageName());
        return false;
    }

    private static void setDisabledUntilUsed(PackageManager packageManager, String string2) {
        int n = packageManager.getApplicationEnabledSetting(string2);
        if (n == 0 || n == 1) {
            packageManager.setApplicationEnabledSetting(string2, 4, 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static void setNonSelectedSystemImesDisabledUntilUsed(PackageManager packageManager, List<InputMethodInfo> list) {
        String[] stringArray = Resources.getSystem().getStringArray(17236016);
        if (stringArray == null) return;
        if (stringArray.length == 0) {
            return;
        }
        SpellCheckerInfo spellCheckerInfo = TextServicesManager.getInstance().getCurrentSpellChecker();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                String string2 = stringArray[n2];
                int n3 = 0;
                while (true) {
                    block11: {
                        boolean bl;
                        block10: {
                            int n4 = list.size();
                            bl = false;
                            if (n3 >= n4) break block10;
                            if (!string2.equals(list.get(n3).getPackageName())) break block11;
                            bl = true;
                        }
                        if (!bl) break;
                        break block9;
                    }
                    ++n3;
                }
                if (spellCheckerInfo == null || !string2.equals(spellCheckerInfo.getPackageName())) {
                    boolean bl;
                    ApplicationInfo applicationInfo;
                    try {
                        ApplicationInfo applicationInfo2;
                        applicationInfo = applicationInfo2 = packageManager.getApplicationInfo(string2, 32768);
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Slog.w(TAG, "NameNotFoundException: " + string2, nameNotFoundException);
                        applicationInfo = null;
                    }
                    if (applicationInfo != null && (bl = (1 & applicationInfo.flags) != 0)) {
                        InputMethodUtils.setDisabledUntilUsed(packageManager, string2);
                    }
                }
            }
            ++n2;
        }
    }

    public static class InputMethodSettings {
        private static final char INPUT_METHOD_SEPARATER = ':';
        private static final char INPUT_METHOD_SUBTYPE_SEPARATER = ';';
        private int[] mCurrentProfileIds;
        private int mCurrentUserId;
        private String mEnabledInputMethodsStrCache;
        private final TextUtils.SimpleStringSplitter mInputMethodSplitter = new TextUtils.SimpleStringSplitter(':');
        private final ArrayList<InputMethodInfo> mMethodList;
        private final HashMap<String, InputMethodInfo> mMethodMap;
        private final Resources mRes;
        private final ContentResolver mResolver;
        private final TextUtils.SimpleStringSplitter mSubtypeSplitter = new TextUtils.SimpleStringSplitter(';');

        public InputMethodSettings(Resources resources, ContentResolver contentResolver, HashMap<String, InputMethodInfo> hashMap, ArrayList<InputMethodInfo> arrayList, int n) {
            this.mCurrentProfileIds = new int[0];
            this.setCurrentUserId(n);
            this.mRes = resources;
            this.mResolver = contentResolver;
            this.mMethodMap = hashMap;
            this.mMethodList = arrayList;
        }

        private void addSubtypeToHistory(String string2, String string3) {
            List<Pair<String, String>> list = this.loadInputMethodAndSubtypeHistoryLocked();
            for (Pair<String, String> pair : list) {
                if (!((String)pair.first).equals(string2)) continue;
                list.remove(pair);
                break;
            }
            this.saveSubtypeHistory(list, string2, string3);
        }

        private static void buildEnabledInputMethodsSettingString(StringBuilder stringBuilder, Pair<String, ArrayList<String>> pair) {
            String string2 = (String)pair.first;
            ArrayList arrayList = (ArrayList)pair.second;
            stringBuilder.append(string2);
            for (String string3 : arrayList) {
                stringBuilder.append(';').append(string3);
            }
        }

        private List<Pair<InputMethodInfo, ArrayList<String>>> createEnabledInputMethodAndSubtypeHashCodeListLocked(List<Pair<String, ArrayList<String>>> list) {
            ArrayList<Pair<InputMethodInfo, ArrayList<String>>> arrayList = new ArrayList<Pair<InputMethodInfo, ArrayList<String>>>();
            for (Pair<String, ArrayList<String>> pair : list) {
                InputMethodInfo inputMethodInfo = this.mMethodMap.get(pair.first);
                if (inputMethodInfo == null) continue;
                arrayList.add(new Pair(inputMethodInfo, pair.second));
            }
            return arrayList;
        }

        private List<InputMethodInfo> createEnabledInputMethodListLocked(List<Pair<String, ArrayList<String>>> list) {
            ArrayList<InputMethodInfo> arrayList = new ArrayList<InputMethodInfo>();
            for (Pair<String, ArrayList<String>> pair : list) {
                InputMethodInfo inputMethodInfo = this.mMethodMap.get(pair.first);
                if (inputMethodInfo == null) continue;
                arrayList.add(inputMethodInfo);
            }
            return arrayList;
        }

        private String getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(List<Pair<String, ArrayList<String>>> list, String string2, String string3) {
            for (Pair<String, ArrayList<String>> pair : list) {
                if (!((String)pair.first).equals(string2)) continue;
                ArrayList arrayList = (ArrayList)pair.second;
                InputMethodInfo inputMethodInfo = this.mMethodMap.get(string2);
                if (arrayList.size() == 0) {
                    ArrayList arrayList2;
                    if (inputMethodInfo != null && inputMethodInfo.getSubtypeCount() > 0 && (arrayList2 = InputMethodUtils.getImplicitlyApplicableSubtypesLocked(this.mRes, inputMethodInfo)) != null) {
                        int n = arrayList2.size();
                        for (int i = 0; i < n; ++i) {
                            if (!String.valueOf(((InputMethodSubtype)arrayList2.get(i)).hashCode()).equals(string3)) continue;
                            return string3;
                        }
                    }
                } else {
                    for (String string4 : arrayList) {
                        block9: {
                            if (!string4.equals(string3)) continue;
                            try {
                                if (!InputMethodUtils.isValidSubtypeId(inputMethodInfo, Integer.valueOf(string3))) break block9;
                                return string4;
                            }
                            catch (NumberFormatException numberFormatException) {
                                return NOT_A_SUBTYPE_ID_STR;
                            }
                        }
                        String string5 = NOT_A_SUBTYPE_ID_STR;
                        return string5;
                    }
                }
                return NOT_A_SUBTYPE_ID_STR;
            }
            return null;
        }

        private Pair<String, String> getLastSubtypeForInputMethodLockedInternal(String string2) {
            List<Pair<String, ArrayList<String>>> list = this.getEnabledInputMethodsAndSubtypeListLocked();
            for (Pair<String, String> pair : this.loadInputMethodAndSubtypeHistoryLocked()) {
                String string3;
                String string4 = (String)pair.first;
                if (!TextUtils.isEmpty(string2) && !string4.equals(string2) || TextUtils.isEmpty(string3 = this.getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(list, string4, (String)pair.second))) continue;
                return new Pair<String, String>(string4, string3);
            }
            return null;
        }

        private int getSelectedInputMethodSubtypeHashCode() {
            try {
                int n = Settings.Secure.getIntForUser(this.mResolver, "selected_input_method_subtype", this.mCurrentUserId);
                return n;
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {
                return -1;
            }
        }

        private String getSubtypeHistoryStr() {
            return Settings.Secure.getStringForUser(this.mResolver, "input_methods_subtype_history", this.mCurrentUserId);
        }

        /*
         * Enabled aggressive block sorting
         */
        private List<Pair<String, String>> loadInputMethodAndSubtypeHistoryLocked() {
            ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
            String string2 = this.getSubtypeHistoryStr();
            if (!TextUtils.isEmpty(string2)) {
                this.mInputMethodSplitter.setString(string2);
                while (this.mInputMethodSplitter.hasNext()) {
                    Object object = this.mInputMethodSplitter.next();
                    this.mSubtypeSplitter.setString((String)object);
                    if (!this.mSubtypeSplitter.hasNext()) continue;
                    Object object2 = NOT_A_SUBTYPE_ID_STR;
                    Object object3 = this.mSubtypeSplitter.next();
                    if (this.mSubtypeSplitter.hasNext()) {
                        object2 = this.mSubtypeSplitter.next();
                    }
                    arrayList.add(new Pair<Object, Object>(object3, object2));
                }
            }
            return arrayList;
        }

        private void putEnabledInputMethodsStr(String string2) {
            Settings.Secure.putStringForUser(this.mResolver, "enabled_input_methods", string2, this.mCurrentUserId);
            this.mEnabledInputMethodsStrCache = string2;
        }

        private void putSubtypeHistoryStr(String string2) {
            Settings.Secure.putStringForUser(this.mResolver, "input_methods_subtype_history", string2, this.mCurrentUserId);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void saveSubtypeHistory(List<Pair<String, String>> list, String string2, String string3) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = TextUtils.isEmpty(string2);
            boolean bl2 = false;
            if (!bl) {
                boolean bl3 = TextUtils.isEmpty(string3);
                bl2 = false;
                if (!bl3) {
                    stringBuilder.append(string2).append(';').append(string3);
                    bl2 = true;
                }
            }
            Iterator<Pair<String, String>> iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.putSubtypeHistoryStr(stringBuilder.toString());
                    return;
                }
                Pair<String, String> pair = iterator.next();
                String string4 = (String)pair.first;
                String string5 = (String)pair.second;
                if (TextUtils.isEmpty(string5)) {
                    string5 = NOT_A_SUBTYPE_ID_STR;
                }
                if (bl2) {
                    stringBuilder.append(':');
                } else {
                    bl2 = true;
                }
                stringBuilder.append(string4).append(';').append(string5);
            }
        }

        public void appendAndPutEnabledInputMethodLocked(String string2, boolean bl) {
            if (bl) {
                this.getEnabledInputMethodsStr();
            }
            if (TextUtils.isEmpty(this.mEnabledInputMethodsStrCache)) {
                this.putEnabledInputMethodsStr(string2);
                return;
            }
            this.putEnabledInputMethodsStr(this.mEnabledInputMethodsStrCache + ':' + string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean buildAndPutEnabledInputMethodsStrRemovingIdLocked(StringBuilder stringBuilder, List<Pair<String, ArrayList<String>>> list, String string2) {
            boolean bl = false;
            boolean bl2 = false;
            for (Pair<String, ArrayList<String>> pair : list) {
                if (((String)pair.first).equals(string2)) {
                    bl = true;
                    continue;
                }
                if (bl2) {
                    stringBuilder.append(':');
                } else {
                    bl2 = true;
                }
                InputMethodSettings.buildEnabledInputMethodsSettingString(stringBuilder, pair);
            }
            if (bl) {
                this.putEnabledInputMethodsStr(stringBuilder.toString());
            }
            return bl;
        }

        public void enableAllIMEsIfThereIsNoEnabledIME() {
            if (TextUtils.isEmpty(this.getEnabledInputMethodsStr())) {
                StringBuilder stringBuilder = new StringBuilder();
                int n = this.mMethodList.size();
                for (int i = 0; i < n; ++i) {
                    InputMethodInfo inputMethodInfo = this.mMethodList.get(i);
                    Slog.i(InputMethodUtils.TAG, "Adding: " + inputMethodInfo.getId());
                    if (i > 0) {
                        stringBuilder.append(':');
                    }
                    stringBuilder.append(inputMethodInfo.getId());
                }
                this.putEnabledInputMethodsStr(stringBuilder.toString());
            }
        }

        public int getCurrentUserId() {
            return this.mCurrentUserId;
        }

        public String getDisabledSystemInputMethods() {
            return Settings.Secure.getStringForUser(this.mResolver, "disabled_system_input_methods", this.mCurrentUserId);
        }

        public List<Pair<InputMethodInfo, ArrayList<String>>> getEnabledInputMethodAndSubtypeHashCodeListLocked() {
            return this.createEnabledInputMethodAndSubtypeHashCodeListLocked(this.getEnabledInputMethodsAndSubtypeListLocked());
        }

        public List<InputMethodInfo> getEnabledInputMethodListLocked() {
            return this.createEnabledInputMethodListLocked(this.getEnabledInputMethodsAndSubtypeListLocked());
        }

        public List<InputMethodSubtype> getEnabledInputMethodSubtypeListLocked(Context context, InputMethodInfo inputMethodInfo, boolean bl) {
            ArrayList arrayList = this.getEnabledInputMethodSubtypeListLocked(inputMethodInfo);
            if (bl && arrayList.isEmpty()) {
                arrayList = InputMethodUtils.getImplicitlyApplicableSubtypesLocked(context.getResources(), inputMethodInfo);
            }
            return InputMethodSubtype.sort(context, 0, inputMethodInfo, arrayList);
        }

        public List<InputMethodSubtype> getEnabledInputMethodSubtypeListLocked(InputMethodInfo inputMethodInfo) {
            List<Pair<String, ArrayList<String>>> list = this.getEnabledInputMethodsAndSubtypeListLocked();
            ArrayList<InputMethodSubtype> arrayList = new ArrayList<InputMethodSubtype>();
            if (inputMethodInfo != null) {
                for (Pair<String, ArrayList<String>> pair : list) {
                    InputMethodInfo inputMethodInfo2 = this.mMethodMap.get(pair.first);
                    if (inputMethodInfo2 == null || !inputMethodInfo2.getId().equals(inputMethodInfo.getId())) continue;
                    int n = inputMethodInfo2.getSubtypeCount();
                    for (int i = 0; i < n; ++i) {
                        InputMethodSubtype inputMethodSubtype = inputMethodInfo2.getSubtypeAt(i);
                        for (String string2 : (ArrayList)pair.second) {
                            if (!String.valueOf(inputMethodSubtype.hashCode()).equals(string2)) continue;
                            arrayList.add(inputMethodSubtype);
                        }
                    }
                }
            }
            return arrayList;
        }

        /*
         * Enabled aggressive block sorting
         */
        public List<Pair<String, ArrayList<String>>> getEnabledInputMethodsAndSubtypeListLocked() {
            ArrayList<Pair<String, ArrayList<String>>> arrayList = new ArrayList<Pair<String, ArrayList<String>>>();
            String string2 = this.getEnabledInputMethodsStr();
            if (!TextUtils.isEmpty(string2)) {
                this.mInputMethodSplitter.setString(string2);
                while (this.mInputMethodSplitter.hasNext()) {
                    Object object = this.mInputMethodSplitter.next();
                    this.mSubtypeSplitter.setString((String)object);
                    if (!this.mSubtypeSplitter.hasNext()) continue;
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    Object object2 = this.mSubtypeSplitter.next();
                    while (this.mSubtypeSplitter.hasNext()) {
                        arrayList2.add(this.mSubtypeSplitter.next());
                    }
                    arrayList.add(new Pair(object2, arrayList2));
                }
            }
            return arrayList;
        }

        public String getEnabledInputMethodsStr() {
            this.mEnabledInputMethodsStrCache = Settings.Secure.getStringForUser(this.mResolver, "enabled_input_methods", this.mCurrentUserId);
            return this.mEnabledInputMethodsStrCache;
        }

        public HashMap<InputMethodInfo, List<InputMethodSubtype>> getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked(Context context) {
            HashMap<InputMethodInfo, List<InputMethodSubtype>> hashMap = new HashMap<InputMethodInfo, List<InputMethodSubtype>>();
            for (InputMethodInfo inputMethodInfo : this.getEnabledInputMethodListLocked()) {
                hashMap.put(inputMethodInfo, this.getEnabledInputMethodSubtypeListLocked(context, inputMethodInfo, true));
            }
            return hashMap;
        }

        public Pair<String, String> getLastInputMethodAndSubtypeLocked() {
            return this.getLastSubtypeForInputMethodLockedInternal(null);
        }

        public String getLastSubtypeForInputMethodLocked(String string2) {
            Pair<String, String> pair = this.getLastSubtypeForInputMethodLockedInternal(string2);
            if (pair != null) {
                return (String)pair.second;
            }
            return null;
        }

        public String getSelectedInputMethod() {
            return Settings.Secure.getStringForUser(this.mResolver, "default_input_method", this.mCurrentUserId);
        }

        public int getSelectedInputMethodSubtypeId(String string2) {
            InputMethodInfo inputMethodInfo = this.mMethodMap.get(string2);
            if (inputMethodInfo == null) {
                return -1;
            }
            return InputMethodUtils.getSubtypeIdFromHashCode(inputMethodInfo, this.getSelectedInputMethodSubtypeHashCode());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isCurrentProfile(int n) {
            synchronized (this) {
                if (n == this.mCurrentUserId) {
                    return true;
                }
                int n2 = 0;
                while (n2 < this.mCurrentProfileIds.length) {
                    if (n == this.mCurrentProfileIds[n2]) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }

        public boolean isShowImeWithHardKeyboardEnabled() {
            return Settings.Secure.getIntForUser(this.mResolver, "show_ime_with_hard_keyboard", 0, this.mCurrentUserId) == 1;
        }

        public boolean isSubtypeSelected() {
            return this.getSelectedInputMethodSubtypeHashCode() != -1;
        }

        public void putSelectedInputMethod(String string2) {
            Settings.Secure.putStringForUser(this.mResolver, "default_input_method", string2, this.mCurrentUserId);
        }

        public void putSelectedSubtype(int n) {
            Settings.Secure.putIntForUser(this.mResolver, "selected_input_method_subtype", n, this.mCurrentUserId);
        }

        public void saveCurrentInputMethodAndSubtypeToHistory(String string2, InputMethodSubtype inputMethodSubtype) {
            String string3 = NOT_A_SUBTYPE_ID_STR;
            if (inputMethodSubtype != null) {
                string3 = String.valueOf(inputMethodSubtype.hashCode());
            }
            if (InputMethodUtils.canAddToLastInputMethod(inputMethodSubtype)) {
                this.addSubtypeToHistory(string2, string3);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setCurrentProfileIds(int[] nArray) {
            synchronized (this) {
                this.mCurrentProfileIds = nArray;
                return;
            }
        }

        public void setCurrentUserId(int n) {
            this.mCurrentUserId = n;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setShowImeWithHardKeyboard(boolean bl) {
            ContentResolver contentResolver = this.mResolver;
            int n = bl ? 1 : 0;
            Settings.Secure.putIntForUser(contentResolver, "show_ime_with_hard_keyboard", n, this.mCurrentUserId);
        }
    }
}

